/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AmPmField;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WholeNumField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeWidget
extends JComponent {
    private JLabel timeLabel;
    private WholeNumField hourf;
    private WholeNumField minf;
    private WholeNumField secf;
    private AmPmField ampmf;
    private JPanel timePanel;
    private String timeString = "";
    private int hour = -1;
    private int min = -1;
    private int sec = -1;
    private String ampmStr = "";
    private JFrame parent;

    public TimeWidget(JFrame jFrame) {
        this(jFrame, -1, -1, -1, "");
    }

    public TimeWidget(JFrame jFrame, String string) {
        this(jFrame, -1, -1, -1, "");
    }

    public TimeWidget(JFrame jFrame, int n, int n2, int n3, String string) {
        this.parent = jFrame;
        this.hour = n;
        this.min = n2;
        this.sec = n3;
        this.ampmStr = string;
        this.createGui();
    }

    private void createGui() {
        this.timePanel = new JPanel();
        this.timePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.timeLabel = new JLabel(ResourceStrings.getString("time_string"));
        this.timeLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.timeLabel.setFont(Constants.PROPS_LABEL_FONT);
        int n = (int)Math.floor(3.579139311666667E7);
        this.hourf = new WholeNumField(-1, 2, 24);
        this.hourf.setMinimumSize(this.hourf.getPreferredSize());
        this.hourf.setHorizontalAlignment(4);
        this.minf = new WholeNumField(-1, 2, 60);
        this.minf.setMinimumSize(this.minf.getPreferredSize());
        this.minf.setHorizontalAlignment(4);
        this.secf = new WholeNumField(-1, 2, 60);
        this.secf.setMinimumSize(this.secf.getPreferredSize());
        this.secf.setHorizontalAlignment(4);
        this.ampmf = new AmPmField(2);
        this.ampmf.setHorizontalAlignment(4);
        if (this.hour > -1) {
            this.hourf.setValue(this.hour);
        }
        if (this.min > -1) {
            this.minf.setValue(this.min);
        }
        if (this.sec > -1) {
            this.secf.setValue(this.sec);
        }
        Constraints.constrain(this.timePanel, this.hourf, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 0);
        Constraints.constrain(this.timePanel, this.minf, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.timePanel, this.secf, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.timePanel, this.ampmf, 3, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.timePanel, this.timeLabel, 4, 0, 1, 1, 0, 17, 1.0, 1.0, 0, 10, 0, 5);
        this.setLayout(new BorderLayout());
        this.add((Component)this.timePanel, "Center");
    }

    public void setEnabled(boolean bl) {
        this.timeLabel.setEnabled(bl);
        this.hourf.setEnabled(bl);
        this.hourf.setEditable(bl);
        this.minf.setEnabled(bl);
        this.minf.setEditable(bl);
        this.secf.setEnabled(bl);
        this.secf.setEditable(bl);
        this.ampmf.setEnabled(bl);
        this.ampmf.setEditable(bl);
        this.timePanel.repaint();
    }

    public String getTimeStr() {
        int n = this.getHrInt();
        int n2 = this.getMinInt();
        int n3 = this.getSecInt();
        String string = "AM";
        if (n > 12) {
            string = "PM";
            if ((n -= 12) == 24) {
                n2 = 0;
                n3 = 0;
            }
        } else {
            string = this.getAmPmStr();
            if (string.equals("")) {
                string = "AM";
            }
        }
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = 0;
        }
        if (n < 0 || n2 < 0 || n3 < 0) {
            this.timeString = "";
        } else {
            String string2;
            String string3;
            String string4 = "0";
            String string5 = "0";
            String string6 = "0";
            String string7 = String.valueOf(n);
            if (string7.length() == 1) {
                string7 = string4.concat(string7);
            }
            if ((string3 = String.valueOf(n2)).length() == 1) {
                string3 = string5.concat(string3);
            }
            if ((string2 = String.valueOf(n3)).length() == 1) {
                string2 = string6.concat(string2);
            }
            this.timeString = string7.concat(string3.concat(string2.concat(string)));
        }
        return this.timeString;
    }

    public String getTimeString() {
        String string = "";
        String string2 = this.getTimeStr();
        if (string2.length() > 0) {
            String string3 = string2.substring(0, 2);
            String string4 = string2.substring(2, 4);
            String string5 = string2.substring(4, 6);
            String string6 = string2.substring(6, 8);
            String string7 = ":";
            String string8 = " ";
            string = string3.concat(string7.concat(string4.concat(string7.concat(string5.concat(string8.concat(string6))))));
        }
        return string;
    }

    public void setTimeString(String string) {
        if (string == null || string.equals("")) {
            this.setHrInt(-1);
            this.setMinInt(-1);
            this.setSecInt(-1);
            this.setAmPmStr("");
        } else {
            String string2 = "";
            String string3 = string;
            String string4 = string3.substring(0, 2);
            String string5 = string3.substring(3, 5);
            String string6 = string3.substring(6, 8);
            String string7 = string3.substring(9, 11);
            string2 = string4.concat(string5.concat(string6.concat(string7)));
        }
    }

    public int getHrInt() {
        this.hour = this.hourf.getValue();
        return this.hour;
    }

    public void setHrInt(int n) {
        this.hour = n;
        this.hourf.setValue(this.hour);
    }

    public int getMinInt() {
        this.min = this.minf.getValue();
        return this.min;
    }

    public void setMinInt(int n) {
        this.min = n;
        this.minf.setValue(this.min);
    }

    public int getSecInt() {
        this.sec = this.secf.getValue();
        return this.sec;
    }

    public void setSecInt(int n) {
        this.sec = n;
        this.secf.setValue(this.sec);
    }

    public String getAmPmStr() {
        this.ampmStr = this.ampmf.getText();
        return this.ampmStr;
    }

    public void setAmPmStr(String string) {
        this.ampmStr = string;
        this.ampmf.setText(this.ampmStr);
    }

    public boolean isValidTime() {
        String string = "";
        String string2 = this.getAmPmStr();
        String string3 = this.hourf.getText();
        int n = this.hourf.getValue();
        int n2 = this.minf.getValue();
        int n3 = this.secf.getValue();
        if (n == -1 && n2 == -1 && n3 == -1 && string2.equals("")) {
            return true;
        }
        if (n == -1) {
            string = ResourceStrings.getString("er_time1");
            ErrorDialog errorDialog = new ErrorDialog(this.parent, string);
            return false;
        }
        return true;
    }
}

