/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeControlWidget
extends JPanel {
    private static final String formatStr = ResourceStrings.getString("TimeControlWidgetFormat");
    private static final String separatorStr = ResourceStrings.getString("TimeControlWidgetSeparator");
    private static final String[] clockTypeArr = new String[]{ResourceStrings.getString("am"), ResourceStrings.getString("pm"), ResourceStrings.getString("military")};
    private static final String HOUR_STR = new String("hh");
    private static final String MINUTE_STR = new String("mm");
    private static final String SECOND_STR = new String("ss");
    private static final String AMPM_STR = new String("ampm");
    private GridBagLayout bag = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private JComboBox clockTypeCombo = new JComboBox<String>(clockTypeArr);
    private JIntSpinBox hourSpinner = new JIntSpinBox(2, 1, 12);
    private JIntSpinBox minSpinner = new JIntSpinBox(2, 0, 59);
    private JIntSpinBox secSpinner = new JIntSpinBox(2, 0, 59);
    private Vector vComponents = new Vector(6);
    private boolean isAmPm = true;
    private boolean isAm = true;
    private int lastClockType = 0;

    public TimeControlWidget() {
        this.parseFormatString();
        this.createGUI();
        this.addFocusListener(new TCWFocusListener());
    }

    private void parseFormatString() {
        StringTokenizer stringTokenizer = new StringTokenizer(formatStr, separatorStr);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase(HOUR_STR)) {
                this.addSeparator();
                this.vComponents.addElement(this.hourSpinner);
                continue;
            }
            if (string.equalsIgnoreCase(MINUTE_STR)) {
                this.addSeparator();
                this.vComponents.addElement(this.minSpinner);
                continue;
            }
            if (string.equalsIgnoreCase(SECOND_STR)) {
                this.addSeparator();
                this.vComponents.addElement(this.secSpinner);
                continue;
            }
            if (!string.equalsIgnoreCase(AMPM_STR)) continue;
            this.vComponents.addElement(this.clockTypeCombo);
        }
        this.setAmPm(this.vComponents.size() == 6);
    }

    private void addSeparator() {
        if (this.vComponents.size() > 0 && this.vComponents.lastElement() instanceof JIntSpinBox) {
            this.vComponents.addElement(this.getSeparatorLabel());
        }
    }

    private JLabel getSeparatorLabel() {
        JLabel jLabel = new JLabel(separatorStr);
        jLabel.setFont(Constants.PROPS_RO_VALUE_FONT);
        return jLabel;
    }

    private void createGUI() {
        this.setLayout(this.bag);
        this.hourSpinner.setDoubleAught(true);
        this.minSpinner.setDoubleAught(true);
        this.secSpinner.setDoubleAught(true);
        this.clockTypeCombo.setSelectedIndex(this.lastClockType);
        this.clockTypeCombo.addItemListener(new ClockTypeListener());
        if (this.vComponents.size() < 6) {
            this.vComponents.addElement(this.clockTypeCombo);
        }
        Enumeration enumeration = this.vComponents.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Constraints.constrain(this, (Component)e, n, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 3, 0, 3);
            ++n;
        }
    }

    public JIntSpinBox getHourField() {
        return this.hourSpinner;
    }

    public JIntSpinBox getMinuteField() {
        return this.minSpinner;
    }

    public JIntSpinBox getSecondField() {
        return this.secSpinner;
    }

    public void setHour(int n) {
        if (n < 0) {
            this.hourSpinner.removeValue();
        } else {
            this.hourSpinner.setIntValue(n);
        }
    }

    public void setMinute(int n) {
        if (n < 0) {
            this.minSpinner.removeValue();
        } else {
            this.minSpinner.setIntValue(n);
        }
    }

    public void setSecond(int n) {
        if (n < 0) {
            this.secSpinner.removeValue();
        } else {
            this.secSpinner.setIntValue(n);
        }
    }

    public boolean isTimeSet() {
        boolean bl = this.get(11) >= 0 || this.get(12) >= 0 || this.get(13) >= 0;
        return bl;
    }

    public void reset() {
        this.setHour(-1);
        this.setMinute(-1);
        this.setSecond(-1);
    }

    private boolean isAmPm() {
        return this.isAmPm;
    }

    private boolean isAm() {
        return this.isAm;
    }

    private void setAmPm(boolean bl) {
        if (!this.isAmPm && bl) {
            this.militaryToAmPm();
        } else if (this.isAmPm && !bl) {
            this.amPmToMilitary();
        }
        this.isAmPm = bl;
        this.isAm = this.clockTypeCombo.getSelectedIndex() == 0;
    }

    private void amPmToMilitary() {
        int n = this.hourSpinner.getIntValue();
        boolean bl = false;
        if (!this.hourSpinner.getStringValue().equals("")) {
            if (this.lastClockType == 0) {
                if (n == 12) {
                    n = 0;
                    bl = true;
                }
            } else if (this.lastClockType == 1 && n < 12) {
                n += 12;
                bl = true;
            }
        }
        this.hourSpinner.setFloor(0);
        this.hourSpinner.setCeiling(24);
        if (bl) {
            this.hourSpinner.setIntValue(n);
        }
    }

    private void militaryToAmPm() {
        int n = this.hourSpinner.getIntValue();
        boolean bl = false;
        if (!this.hourSpinner.getStringValue().equals("")) {
            if (n == 0 || n == 24) {
                n = 12;
                bl = true;
            } else if (n > 12) {
                n -= 12;
                bl = true;
            }
        }
        this.hourSpinner.setFloor(1);
        this.hourSpinner.setCeiling(12);
        if (bl) {
            this.hourSpinner.setIntValue(n);
        }
    }

    public int get(int n) {
        int n2 = -1;
        switch (n) {
            case 11: {
                if (!this.hourSpinner.getStringValue().equals("")) {
                    n2 = this.hourSpinner.getIntValue();
                }
                if (!this.isAmPm()) break;
                if (this.isAm()) {
                    if (n2 != 12) break;
                    n2 = 0;
                    break;
                }
                if (n2 >= 12) break;
                n2 += 12;
                break;
            }
            case 12: {
                if (this.minSpinner.getStringValue().equals("")) break;
                n2 = this.minSpinner.getIntValue();
                break;
            }
            case 13: {
                if (this.minSpinner.getStringValue().equals("")) break;
                n2 = this.secSpinner.getIntValue();
            }
        }
        return n2;
    }

    private class TCWFocusListener
    implements FocusListener {
        private TCWFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            TimeControlWidget.this.hourSpinner.grabFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class ClockTypeListener
    implements ItemListener {
        private ClockTypeListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            TimeControlWidget.this.setAmPm(TimeControlWidget.this.clockTypeCombo.getSelectedIndex() < 2);
            TimeControlWidget.this.lastClockType = TimeControlWidget.this.clockTypeCombo.getSelectedIndex();
        }
    }
}

