/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.StopwatchClient;

public class Stopwatch
extends Thread {
    private static long _defaultTickInterval = 50L;
    private StopwatchClient client;
    private long start;
    private long now;
    private long elapsed;
    private long hour;
    private long minute;
    private long second;
    private long millisecond;
    private long tickInterval;

    public Stopwatch() {
        this((StopwatchClient)null);
    }

    public Stopwatch(StopwatchClient stopwatchClient) {
        this(stopwatchClient, _defaultTickInterval);
    }

    public Stopwatch(StopwatchClient stopwatchClient, long l) {
        this.tickInterval = l;
        this.start = System.currentTimeMillis();
        this.client = stopwatchClient;
    }

    public void setTickInterval(long l) {
        this.tickInterval = l;
    }

    public void update() {
        this.now = System.currentTimeMillis();
        this.elapsed = this.now - this.start;
        this.millisecond = 0L;
        this.second = 0L;
        this.minute = 0L;
        this.hour = 0L;
        this.second = this.elapsed / 1000L;
        this.millisecond = this.elapsed % 1000L;
        long l = this.millisecond = this.millisecond == 0L ? 0L : this.millisecond / 10L;
        if (this.second > 59L) {
            this.minute = this.second / 60L;
            this.second -= this.minute * 60L;
        }
        if (this.minute > 59L) {
            this.hour = this.minute / 60L;
            this.minute -= this.hour * 60L;
        }
    }

    public String toString() {
        this.update();
        return new String(this.stringValueOf(this.hour) + ":" + this.stringValueOf(this.minute) + ":" + this.stringValueOf(this.second) + ":" + this.stringValueOf(this.millisecond));
    }

    public long getHour() {
        return this.hour;
    }

    public long getMinute() {
        return this.minute;
    }

    public long getSecond() {
        return this.second;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public long elapsedTime() {
        this.update();
        return this.elapsed;
    }

    public void reset() {
        this.start = System.currentTimeMillis();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(this.tickInterval, 0);
                    this.update();
                    if (this.client == null) continue;
                    this.client.tick(this);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private String stringValueOf(long l) {
        if (l < 10L) {
            return "0" + String.valueOf(l);
        }
        return String.valueOf(l);
    }
}

