/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class LogWindow
extends JDialog {
    private JTextArea textArea;
    private JButton clearButton;
    private JButton closeButton;
    private JComponent defaultFocus;

    public LogWindow(JDialog jDialog, int n, int n2) {
        super(jDialog);
        this.createLogWindow(n, n2);
        this.setLocationRelativeTo(jDialog);
    }

    public LogWindow(JFrame jFrame, int n, int n2) {
        super(jFrame);
        this.createLogWindow(n, n2);
        this.setLocationRelativeTo(jFrame);
    }

    private void createLogWindow(int n, int n2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        jPanel.add("Center", this.createLogPanel(n, n2));
        jPanel.add("South", this.createButtonPanel());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogWindow.this.dispose();
            }
        };
        jPanel.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0, true), 2);
        this.getContentPane().add("Center", jPanel);
        this.pack();
        this.defaultFocus = this.closeButton;
        this.defaultFocus.requestFocus();
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                LogWindow.this.defaultFocus.requestFocus();
            }

            public void componentResized(ComponentEvent componentEvent) {
                LogWindow.this.defaultFocus.requestFocus();
            }
        });
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.defaultFocus.requestFocus();
    }

    public void dispose() {
        this.setVisible(false);
        super.dispose();
    }

    private JPanel createLogPanel(int n, int n2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.textArea = new JTextArea(n, n2);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.textArea.setBackground(Color.white);
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 20, 31);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Constraints.constrain(jPanel, jScrollPane, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.clearButton = new JButton(ResourceStrings.getString("LW_ClearButton"));
        this.clearButton.setFocusPainted(true);
        Constraints.constrain(jPanel, this.clearButton, -1, 0, 1, 1, 0, 0, 0, 0);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogWindow.this.clearLog();
            }
        });
        this.closeButton = new JButton(ResourceStrings.getString("LW_CloseButton"));
        this.closeButton.setFocusPainted(true);
        Constraints.constrain(jPanel, this.closeButton, -1, 0, 1, 1, 0, 5, 0, 0);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogWindow.this.dispose();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        Constraints.constrain(jPanel2, jPanel, 0, 0, 1, 1, 0, 13, 1.0, 0.0, 5, 0, 5, 10);
        return jPanel2;
    }

    public synchronized void setLog(String string) {
        this.textArea.setText(string);
    }

    public void appendToLog(String string) {
        if (this.textArea.getRows() == 1) {
            this.setLog(string);
            return;
        }
        this.textArea.append(string + "\n");
    }

    public void clearLog() {
        this.setLog("");
    }
}

