/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.ListProperties;
import java.util.Vector;

public abstract class ListFormatSQL {
    private static final String QUERY_PREFIX = "SELECT * FROM ";
    private static final String QUERY_WHERE = " WHERE ";
    private static final String QUERY_ORDER = " ORDER BY ";
    private static final String QUERY_EQ = "=";
    private static final String QUERY_NE = "<>";
    private static final String QUERY_GT = ">";
    private static final String QUERY_LT = "<";
    private static final String QUERY_LIKE = "LIKE";
    private static final String QUERY_NOT_LIKE = "NOT LIKE";
    private static final String QUERY_NOT = " NOT";
    private static final String QUERY_AND = " AND";
    private static final String QUERY_OR = " OR";
    private static final String QUERY_ASC = "ASC";
    private static final String QUERY_DESC = "DESC";
    private static final String QUERY_NULL = "NULL";
    private static final int FILTER_CT = 1;
    private static final int FILTER_NC = 2;
    private static final int FILTER_SW = 3;
    private static final int FILTER_EW = 4;
    private static final int FILTER_EQ = 5;
    private static final int FILTER_NE = 6;
    private static final int FILTER_LT = 7;
    private static final int FILTER_GT = 8;
    private static final int FILTER_MAX = 8;
    private static final int FILTER_NONE = 1;
    private static final int FILTER_AND = 2;
    private static final int FILTER_OR = 3;
    private static final int FILTER_NOT = 4;
    private static final String[] OPMAP = new String[]{"LIKE", "NOT LIKE", "LIKE", "LIKE", "=", "<>", "<", ">"};
    private String class_name;

    public ListFormatSQL(String string) {
        this.class_name = string;
    }

    public String formatQuery(ListProperties listProperties) throws AdminException {
        FilterItem filterItem = null;
        String string = null;
        if (this.class_name == null || this.class_name.trim().length() == 0) {
            return string;
        }
        string = QUERY_PREFIX + this.class_name;
        Vector vector = new Vector();
        if (listProperties != null) {
            vector = listProperties.getFilters();
        }
        if (vector.size() > 0) {
            string = string + QUERY_WHERE;
            int n = 0;
            while (n < vector.size()) {
                String string2;
                filterItem = (FilterItem)vector.elementAt(n);
                int n2 = filterItem.getBooleanOperator();
                if (n2 != 1) {
                    if (n2 == 4) {
                        string = string + QUERY_NOT;
                    } else if (n > 0) {
                        if (n2 == 2) {
                            string = string + QUERY_AND;
                        } else if (n2 == 3) {
                            string = string + QUERY_OR;
                        } else {
                            throw new AdminClientException("EXM_SQL1");
                        }
                    }
                }
                if ((string2 = this.mapAttributeName(filterItem.getAttribute())) == null) {
                    throw new AdminClientException("EXM_SQL2");
                }
                int n3 = filterItem.getOperator();
                String string3 = this.convertOperator(n3);
                if (string3 == null) {
                    throw new AdminClientException("EXM_SQL3");
                }
                String string4 = filterItem.getValue();
                if (string4 != null) {
                    if (string3.equals(QUERY_LIKE) || string3.equals(QUERY_NOT_LIKE)) {
                        string4 = this.likeValue(n3, string4);
                    }
                    string4 = "'" + string4 + "'";
                } else {
                    string4 = QUERY_NULL;
                }
                string = string + " " + string2 + " " + string3 + " " + string4;
                ++n;
            }
        }
        return string;
    }

    public abstract String mapAttributeName(String var1);

    private String convertOperator(int n) {
        if (n < 1 || n > 8) {
            return null;
        }
        return OPMAP[n - 1];
    }

    private String likeValue(int n, String string) {
        if (n == 1 || n == 2) {
            return "%" + string + "%";
        }
        if (n == 3) {
            return string + "%";
        }
        if (n == 4) {
            return "%" + string;
        }
        return string;
    }
}

