/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.ListFetchEvent;
import com.sun.admin.cis.common.ListFetchListener;
import com.sun.admin.cis.common.QuickVector;
import java.util.Date;
import java.util.Vector;
import javax.swing.SwingUtilities;

public abstract class ListFetch
extends Thread {
    private int serverChunkSize;
    private int displayChunkSize;
    private int objectCount = 0;
    private int numReceived = 0;
    private boolean bInterrupted = false;
    private final int UPDATE_RATE = 10;
    private Vector listeners = new Vector();

    protected abstract int listPrime() throws Exception;

    protected abstract Vector listNext() throws Exception;

    protected abstract void listEnd() throws Exception;

    protected abstract Vector listAll() throws Exception;

    protected abstract Vector listCustomStart();

    protected abstract void listTrace(String var1);

    protected abstract String getTracePrefix();

    public ListFetch(int n, int n2) {
        this.serverChunkSize = n;
        this.displayChunkSize = n2;
    }

    public void run() {
        Vector vector;
        String string = new String(this.getTracePrefix());
        if (string.length() > 0) {
            string = string + ": ";
        }
        if ((vector = this.listCustomStart()).size() > 0) {
            this.fireBatchReady(new ListFetchEvent(vector, this.numReceived, this.objectCount));
        }
        StopWatch stopWatch = new StopWatch();
        try {
            if (this.serverChunkSize > 0) {
                Vector vector2;
                this.objectCount = this.listPrime();
                if (this.objectCount == 0) {
                    this.fireBatchReady(new ListFetchEvent(null, this.numReceived, this.objectCount));
                    return;
                }
                if (this.isInterrupted()) {
                    this.listEnd();
                    throw new InterruptedException();
                }
                int n = 0;
                this.listTrace(string + "Prime server to chunk " + this.objectCount + " objects in chunks of " + this.serverChunkSize);
                int n2 = Math.max(1, this.objectCount / 10);
                if (this.displayChunkSize > n2) {
                    this.listTrace(string + "Display chunk size (" + this.displayChunkSize + ") exceeds 1/" + 10 + " the total number of objects (" + this.objectCount + "), " + "so will send objects to GUI in batches of " + n2);
                }
                do {
                    stopWatch.start();
                    vector2 = this.listNext();
                    this.listTrace(string + "Inbound batch " + ++n + " received from server in " + stopWatch.stop() + " seconds, size is: " + vector2.size());
                    if (this.displayChunkSize <= n2) {
                        this.numReceived += vector2.size();
                        this.fireBatchReady(new ListFetchEvent(vector2, this.numReceived, this.objectCount));
                    } else {
                        QuickVector quickVector = new QuickVector(n2);
                        quickVector.setSize(n2);
                        int n3 = 0;
                        int n4 = 0;
                        stopWatch.start();
                        int n5 = 0;
                        while (n5 < vector2.size()) {
                            quickVector.quickSetElementAt(vector2.elementAt(n5), n3++);
                            if (n3 == n2) {
                                this.numReceived += quickVector.size();
                                this.fireBatchReady(new ListFetchEvent(quickVector, this.numReceived, this.objectCount));
                                this.listTrace(string + "Outbound batch " + ++n4 + " sent to GUI, size is " + quickVector.size());
                                quickVector = new QuickVector(n2);
                                quickVector.setSize(n2);
                                n3 = 0;
                                if (this.isInterrupted()) {
                                    stopWatch.stop();
                                    this.listEnd();
                                    throw new InterruptedException();
                                }
                            }
                            ++n5;
                        }
                        if (n3 > 0) {
                            quickVector.setSize(n3);
                            this.numReceived += quickVector.size();
                            this.fireBatchReady(new ListFetchEvent(quickVector, this.numReceived, this.objectCount));
                            this.listTrace(string + "Outbound batch " + ++n4 + " sent to GUI, size is " + quickVector.size());
                        }
                        this.listTrace(string + n4 + " batches sent to GUI in " + stopWatch.stop() + " seconds");
                    }
                    if (!this.isInterrupted()) continue;
                    this.listEnd();
                    throw new InterruptedException();
                } while (vector2.size() == this.serverChunkSize);
                this.listTrace(string + "Notify server chunking is complete");
                this.listEnd();
                this.fireBatchReady(new ListFetchEvent(null, this.numReceived, this.objectCount));
            } else {
                stopWatch.start();
                Vector vector3 = this.listAll();
                this.objectCount = vector3.size();
                if (this.objectCount == 0) {
                    this.fireBatchReady(new ListFetchEvent(null, this.numReceived, this.objectCount));
                    return;
                }
                if (this.isInterrupted()) {
                    stopWatch.stop();
                    throw new InterruptedException();
                }
                this.listTrace(string + this.objectCount + " objects received in " + stopWatch.stop() + " seconds");
                if (this.displayChunkSize <= 0) {
                    this.listTrace(string + "Sending all objects to GUI");
                    this.numReceived += vector3.size();
                    this.fireBatchReady(new ListFetchEvent(vector3, this.numReceived, this.objectCount));
                } else {
                    int n = 0;
                    int n6 = Math.max(1, this.objectCount / 10);
                    if (this.displayChunkSize > n6) {
                        this.listTrace(string + "DisplayChunksize (" + this.displayChunkSize + ") exceeds 1/" + 10 + " the total number of objects (" + this.objectCount + "), " + "so will send objects to GUI in batches of " + n6);
                    } else {
                        this.listTrace(string + "Send to GUI " + this.objectCount + " objects in chunks of " + this.displayChunkSize);
                        n6 = this.displayChunkSize;
                    }
                    QuickVector quickVector = new QuickVector(n6);
                    quickVector.setSize(n6);
                    int n7 = 0;
                    stopWatch.start();
                    int n8 = 0;
                    while (n8 < vector3.size()) {
                        quickVector.quickSetElementAt(vector3.elementAt(n8), n7++);
                        if (n7 == n6) {
                            this.numReceived += quickVector.size();
                            this.fireBatchReady(new ListFetchEvent(quickVector, this.numReceived, this.objectCount));
                            this.listTrace(string + "Outbound batch " + ++n + " sent to GUI, size is " + quickVector.size());
                            quickVector = new QuickVector(n6);
                            quickVector.setSize(n6);
                            n7 = 0;
                            if (this.isInterrupted()) {
                                stopWatch.stop();
                                throw new InterruptedException();
                            }
                        }
                        ++n8;
                    }
                    if (n7 > 0) {
                        quickVector.setSize(n7);
                        this.numReceived += quickVector.size();
                        this.fireBatchReady(new ListFetchEvent(quickVector, this.numReceived, this.objectCount));
                        this.listTrace(string + "Outbound batch " + ++n + " sent to GUI, size is " + quickVector.size());
                    }
                    this.listTrace(string + n + " batches sent to GUI in " + stopWatch.stop() + " seconds");
                }
                this.fireBatchReady(new ListFetchEvent(null, this.numReceived, this.objectCount));
            }
        }
        catch (InterruptedException interruptedException) {
            this.listTrace(string + "INTERRUPTED!!");
            this.fireBatchReady(new ListFetchEvent(null, this.numReceived, this.objectCount));
        }
        catch (Exception exception) {
            this.fireErrorException(exception);
            this.fireBatchReady(new ListFetchEvent(null, this.numReceived, this.objectCount));
        }
    }

    public synchronized void interrupt() {
        this.bInterrupted = true;
    }

    public synchronized boolean isInterrupted() {
        return this.bInterrupted;
    }

    private void fireBatchReady(final ListFetchEvent listFetchEvent) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int n = 0;
                    while (n < ListFetch.this.listeners.size()) {
                        ListFetchListener listFetchListener = (ListFetchListener)ListFetch.this.listeners.elementAt(n);
                        listFetchListener.batchReady(listFetchEvent);
                        ++n;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fireErrorException(final Exception exception) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    int n = 0;
                    while (n < ListFetch.this.listeners.size()) {
                        ListFetchListener listFetchListener = (ListFetchListener)ListFetch.this.listeners.elementAt(n);
                        listFetchListener.errorException(exception);
                        ++n;
                    }
                }
            });
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    public synchronized void addListFetchListener(ListFetchListener listFetchListener) {
        this.listeners.addElement(listFetchListener);
    }

    public synchronized void removeListFetchListener(ListFetchListener listFetchListener) {
        this.listeners.removeElement(listFetchListener);
    }

    class StopWatch {
        Date startTime;
        Date stopTime;

        StopWatch() {
        }

        public void start() {
            this.startTime = new Date();
        }

        public double stop() {
            this.stopTime = new Date();
            return (double)(this.stopTime.getTime() - this.startTime.getTime()) / 1000.0;
        }
    }
}

