/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constraints;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class JSpinBox
extends JPanel
implements KeyListener {
    private JPanel spinBox;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final Border lineBorder = new LineBorder(Color.black);
    public Toolkit toolkit = Toolkit.getDefaultToolkit();
    public JTextField textField;
    public JButton upButton;
    public JButton downButton;
    public boolean wrapping = true;
    public boolean editable = true;

    public JSpinBox(int n) {
        this.spinBox = this;
        this.createJSpinBox();
        this.textField.setColumns(n);
    }

    public void createJSpinBox() {
        this.spinBox.setLayout(new GridBagLayout());
        this.spinBox.setBorder(lineBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.textField = new JTextField();
        this.textField.setDoubleBuffered(true);
        this.textField.addKeyListener(this);
        this.textField.setBorder(emptyBorder);
        Constraints.constrain(this.spinBox, this.textField, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.upButton = new JButton();
        this.upButton.addKeyListener(this);
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.setContentAreaFilled(false);
        Constraints.constrain(jPanel, this.upButton, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        this.downButton = new JButton();
        this.downButton.addKeyListener(this);
        this.downButton.setContentAreaFilled(false);
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        Constraints.constrain(jPanel, this.downButton, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this.spinBox, jPanel, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
    }

    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
    }

    public void addNotify() {
        super.addNotify();
        Image image = this.createImage(8, 3);
        Graphics graphics = image.getGraphics();
        Polygon polygon = new Polygon();
        polygon.addPoint(4, 0);
        polygon.addPoint(0, 3);
        polygon.addPoint(8, 3);
        graphics.setColor(Color.black);
        graphics.fillPolygon(polygon);
        ImageIcon imageIcon = new ImageIcon(image);
        this.upButton.setIcon(imageIcon);
        Image image2 = this.createImage(8, 3);
        graphics = image2.getGraphics();
        polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(8, 0);
        polygon.addPoint(4, 3);
        graphics.setColor(Color.black);
        graphics.fillPolygon(polygon);
        ImageIcon imageIcon2 = new ImageIcon(image2);
        this.downButton.setIcon(imageIcon2);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setTextField(JTextField jTextField) {
        this.textField = jTextField;
    }

    public JButton getUpButton() {
        return this.upButton;
    }

    public void setUpButton(JButton jButton) {
        this.upButton = jButton;
    }

    public JButton getDownButton() {
        return this.downButton;
    }

    public void setDownButton(JButton jButton) {
        this.downButton = jButton;
    }

    public boolean isWrapping() {
        return this.wrapping;
    }

    public void setWrapping(boolean bl) {
        this.wrapping = bl;
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38) {
            if (this.upButton.isEnabled()) {
                this.upButton.doClick();
            } else {
                this.toolkit.beep();
            }
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.downButton.isEnabled()) {
                this.downButton.doClick();
            } else {
                this.toolkit.beep();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

