/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JListEditor
extends JPanel {
    private JTextField inTextField;
    private JButton addButton;
    private JList outList;
    private Vector vOutKeys;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton deleteButton;
    private JScrollPane outScrollPane;
    private ResourceBundle bundle;
    private ActionListener verifyListener = null;
    private final DefaultListModel outModel = new DefaultListModel();

    public JListEditor(Vector vector) {
        this(vector, "com.sun.admin.cis.resources.Resources", true);
    }

    public JListEditor(Vector vector, boolean bl) {
        this(vector, "com.sun.admin.cis.resources.Resources", bl);
    }

    public JListEditor(Vector vector, String string) {
        this(vector, string, true);
    }

    public JListEditor(Vector vector, String string, boolean bl) {
        this.setLayout(new GridBagLayout());
        try {
            this.bundle = ResourceBundle.getBundle(string, Locale.getDefault());
        }
        catch (Exception exception) {
            this.bundle = null;
        }
        int n = vector.size();
        n = Math.max(n, 3);
        n = Math.min(n, 10);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.inTextField = new JTextField();
        Constraints.constrain(jPanel, this.inTextField, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.outList = new JList(this.outModel);
        this.outList.setVisibleRowCount(n);
        this.outScrollPane = new JScrollPane(20, 30);
        this.outScrollPane.getViewport().setView(this.outList);
        Constraints.constrain(jPanel, this.outScrollPane, 0, 1, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 10, 5);
        Constraints.constrain(this, jPanel, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString("JE_Add");
        this.addButton = new JButton(actionString.getString());
        Constraints.constrain(jPanel2, this.addButton, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 10, 0);
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setEnabled(false);
        this.addButton.setMnemonic(actionString.getMnemonic());
        this.moveUpButton = new JButton();
        Constraints.constrain(jPanel2, this.moveUpButton, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 10, 0);
        this.moveUpButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = new JButton();
        Constraints.constrain(jPanel2, this.moveDownButton, 0, 2, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 10, 0);
        this.moveDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.moveDownButton.setEnabled(false);
        actionString = new ActionString("JE_Delete");
        this.deleteButton = new JButton(actionString.getString());
        Constraints.constrain(jPanel2, this.deleteButton, 0, 3, 1, 1, 0, 16, 0.0, 0.0, 0, 0, 10, 0);
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setMnemonic(actionString.getMnemonic());
        Constraints.constrain(this, jPanel2, 1, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 10, 0);
        Constraints.constrain(this, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        int n2 = Math.max(3, this._setOutItems(vector));
        String string2 = "";
        int n3 = 0;
        while (n3 < n2) {
            string2 = string2 + "A";
            ++n3;
        }
        this.outList.setPrototypeCellValue(string2);
        this.outScrollPane.setMinimumSize(this.outScrollPane.getPreferredSize());
        this.moveUpButton.setVisible(bl);
        this.moveDownButton.setVisible(bl);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), JListEditor.this.inTextField.getText());
                JListEditor.this.verifyListener.actionPerformed(actionEvent2);
            }
        });
        this.setVerifyListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JListEditor.this.acceptInput(true);
            }
        });
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JListEditor.this.moveUp();
            }
        });
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JListEditor.this.moveDown();
            }
        });
        this.inTextField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                if (JListEditor.this.inTextField.getText().length() == 0) {
                    JListEditor.this.addButton.setEnabled(false);
                } else {
                    JListEditor.this.addButton.setEnabled(true);
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.outList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = JListEditor.this.outList.getSelectedIndices();
                if (nArray.length == 1) {
                    if (nArray[0] != 0) {
                        JListEditor.this.moveUpButton.setEnabled(true);
                    } else {
                        JListEditor.this.moveUpButton.setEnabled(false);
                    }
                    if (nArray[0] != JListEditor.this.outModel.getSize() - 1) {
                        JListEditor.this.moveDownButton.setEnabled(true);
                    } else {
                        JListEditor.this.moveDownButton.setEnabled(false);
                    }
                } else {
                    JListEditor.this.moveUpButton.setEnabled(false);
                    JListEditor.this.moveDownButton.setEnabled(false);
                }
                if (nArray.length == 0) {
                    JListEditor.this.deleteButton.setEnabled(false);
                } else {
                    JListEditor.this.deleteButton.setEnabled(true);
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JListEditor.this.removeListSelections();
                JListEditor.this.deleteButton.setEnabled(false);
                JListEditor.this.inTextField.requestFocus();
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.moveUpButton.setIcon(ConsoleUtility.loadImageIcon((String)"/com/sun/admin/cis/common/images/move_up.gif", this.getClass()));
        this.moveDownButton.setIcon(ConsoleUtility.loadImageIcon((String)"/com/sun/admin/cis/common/images/move_dn.gif", this.getClass()));
    }

    public void setUpAddShortcut() {
        this.inTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JListEditor.this.addButton.doClick();
            }
        });
    }

    private void moveTextToList() {
        this.vOutKeys.addElement(this.inTextField.getText());
        this.outModel.addElement(this.inTextField.getText());
        this.outList.ensureIndexIsVisible(this.outModel.getSize() - 1);
        this.inTextField.setText("");
    }

    private void removeListSelections() {
        int[] nArray = this.outList.getSelectedIndices();
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            this.outModel.removeElementAt(n3 - n);
            this.vOutKeys.removeElementAt(n3 - n);
            ++n;
            ++n2;
        }
    }

    private void moveUp() {
        int n = this.outList.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        Object e = this.outModel.getElementAt(n);
        Object e2 = this.outModel.getElementAt(n - 1);
        this.outModel.setElementAt(e2, n);
        this.outModel.setElementAt(e, n - 1);
        this.outList.setSelectedIndex(n - 1);
        e = this.vOutKeys.elementAt(n);
        e2 = this.vOutKeys.elementAt(n - 1);
        this.vOutKeys.setElementAt(e2, n);
        this.vOutKeys.setElementAt(e, n - 1);
    }

    private void moveDown() {
        int n = this.outList.getSelectedIndex();
        if (n >= this.outModel.getSize() - 1) {
            return;
        }
        Object e = this.outModel.getElementAt(n);
        Object e2 = this.outModel.getElementAt(n + 1);
        this.outModel.setElementAt(e2, n);
        this.outModel.setElementAt(e, n + 1);
        this.outList.setSelectedIndex(n + 1);
        e = this.vOutKeys.elementAt(n);
        e2 = this.vOutKeys.elementAt(n + 1);
        this.vOutKeys.setElementAt(e2, n);
        this.vOutKeys.setElementAt(e, n + 1);
    }

    private int _setOutItems(Vector vector) {
        this.vOutKeys = new Vector();
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            String string2 = ResourceStrings.getString(this.bundle, string);
            this.vOutKeys.addElement(string);
            this.outModel.addElement(string2);
            n = Math.max(n, string2.length());
            ++n2;
        }
        return n;
    }

    public void setColumns(int n) {
        this.inTextField.setColumns(n);
        this.inTextField.setMinimumSize(this.inTextField.getPreferredSize());
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "A";
            ++n2;
        }
        this.outList.setPrototypeCellValue(string);
    }

    public void setVisibleRows(int n) {
        this.outList.setVisibleRowCount(n);
        this.outList.setMinimumSize(this.outList.getPreferredSize());
        this.outScrollPane.setMinimumSize(this.outScrollPane.getPreferredSize());
    }

    public void setFocusListeners(FocusListener focusListener, FocusListener focusListener2, FocusListener focusListener3, FocusListener focusListener4, FocusListener focusListener5, FocusListener focusListener6) {
        if (focusListener != null) {
            this.inTextField.addFocusListener(focusListener);
        }
        if (focusListener2 != null) {
            this.outList.addFocusListener(focusListener2);
        }
        if (focusListener3 != null) {
            this.addButton.addFocusListener(focusListener3);
        }
        if (focusListener4 != null) {
            this.deleteButton.addFocusListener(focusListener4);
        }
        if (focusListener5 != null) {
            this.moveUpButton.addFocusListener(focusListener5);
        }
        if (focusListener6 != null) {
            this.moveDownButton.addFocusListener(focusListener6);
        }
    }

    public Vector getOutItems() {
        return this.vOutKeys;
    }

    public void setOutItems(Vector vector) {
        this.outModel.removeAllElements();
        this.vOutKeys = new Vector();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = ResourceStrings.getString(this.bundle, string);
            this.vOutKeys.addElement(string);
            this.outModel.addElement(string2);
            ++n;
        }
    }

    public void setVerifyListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.verifyListener = actionListener;
    }

    public void acceptInput(boolean bl) {
        if (bl) {
            this.moveTextToList();
            this.addButton.setEnabled(false);
        }
        this.inTextField.requestFocus();
    }

    public void setLabel(JLabel jLabel) {
        jLabel.setLabelFor(this.inTextField);
    }

    public void setFont(Font font) {
    }
}

