/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class GenInfoPanel {
    private String theText = "";
    private VOptionPane vOptionPane;
    private LinkListener linkListener;

    public GenInfoPanel(VOptionPane vOptionPane) {
        this.vOptionPane = vOptionPane;
        JEditorPane jEditorPane = vOptionPane.getHelpEditorPane();
        this.linkListener = new LinkListener(this, jEditorPane);
        jEditorPane.addHyperlinkListener(this.linkListener);
    }

    public void setUrl(URL uRL) {
        this.vOptionPane.setHelpHTML(uRL);
    }

    public void setText(String string) {
        this.vOptionPane.setHelpHTML(string);
        this.theText = new String(string);
    }

    public String getText() {
        return this.theText;
    }

    public VOptionPane getVOptionPane() {
        return this.vOptionPane;
    }

    public void setFocusListener(FocusListener focusListener, boolean bl) {
        this.vOptionPane.getContentPane().addFocusListener(focusListener);
        this.vOptionPane.getContentPane().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                GenInfoPanel.this.vOptionPane.getContentPane().requestFocus();
            }
        });
        if (bl) {
            focusListener.focusGained(new FocusEvent(this.vOptionPane.getContentPane(), 1004));
        }
    }

    public void hyperBoot(ContextHelpListener contextHelpListener) {
        this.linkListener.reset(contextHelpListener);
    }

    public boolean isExternalLink(String string) {
        return this.linkListener.isExternalLink(string);
    }

    private class LinkListener
    implements HyperlinkListener {
        private GenInfoPanel infoPanel;
        private JEditorPane editorPane;
        private ContextHelpListener bootListener = null;
        private Vector historyStack = new Vector();
        private static final String BACKURL = ":Back";

        public LinkListener(GenInfoPanel genInfoPanel2, JEditorPane jEditorPane) {
            this.infoPanel = genInfoPanel2;
            this.editorPane = jEditorPane;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ENTERED) {
                this.editorPane.setCursor(Cursor.getPredefinedCursor(12));
            } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                this.editorPane.setCursor(Cursor.getDefaultCursor());
            } else {
                if (this.isExternalLink(hyperlinkEvent.getDescription())) {
                    return;
                }
                if (this.bootListener == null) {
                    return;
                }
                ContextHelpListener contextHelpListener = null;
                if (hyperlinkEvent.getDescription().compareTo(BACKURL) != 0) {
                    int n;
                    int n2;
                    contextHelpListener = new ContextHelpListener(this.bootListener.getCache(), this.bootListener.getToolClass(), this.infoPanel, this.bootListener.getAppPath(), hyperlinkEvent.getDescription());
                    ContextHelpListener contextHelpListener2 = ContextHelpListener.findMatch(contextHelpListener);
                    if (contextHelpListener2 != null) {
                        contextHelpListener.removeFromCache();
                        contextHelpListener = contextHelpListener2;
                    } else if (this.bootListener.getCache() != null && (n2 = this.bootListener.getCache().size()) == (n = this.bootListener.getCache().size())) {
                        this.bootListener.getCache().ensureCapacity(n2 + 1);
                    }
                    this.historyStack.insertElementAt(this.bootListener.getCurrent(), 0);
                } else {
                    if (this.historyStack.size() == 0) {
                        return;
                    }
                    contextHelpListener = (ContextHelpListener)this.historyStack.elementAt(0);
                    this.historyStack.removeElementAt(0);
                }
                contextHelpListener.focusGained(null);
            }
        }

        public void reset(ContextHelpListener contextHelpListener) {
            this.bootListener = contextHelpListener;
            this.historyStack.removeAllElements();
        }

        public boolean isExternalLink(String string) {
            if (string.equals(BACKURL)) {
                return false;
            }
            if (string.indexOf(":/") >= 0) {
                return true;
            }
            if (string.indexOf("/") >= 0) {
                return true;
            }
            return !string.endsWith(".html");
        }
    }
}

