/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FilterPanel
extends JPanel {
    private ResourceBundle bundle;
    private Vector vFilterPanels = new Vector();
    private JRadioButton andRadioBtn;
    private JRadioButton orRadioBtn;
    private ActionListener clientTextActionListener = null;
    private KeyListener keyListener = null;
    private FilterPanel filterPanel = null;
    private String[] attributes;

    public FilterPanel(String[] stringArray, String string, Vector vector, GenInfoPanel genInfoPanel, ActionListener actionListener) {
        this.setLayout(new GridBagLayout());
        this.clientTextActionListener = actionListener;
        this.filterPanel = this;
        this.attributes = stringArray;
        try {
            this.bundle = ResourceBundle.getBundle(string, Locale.getDefault());
        }
        catch (Exception exception) {
            this.bundle = null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = ResourceStrings.getString(this.bundle, stringArray[n]);
            ++n;
        }
        String[] stringArray3 = new String[]{ResourceStrings.getString("contains"), ResourceStrings.getString("excludes"), ResourceStrings.getString("is"), ResourceStrings.getString("starts"), ResourceStrings.getString("ends"), ResourceStrings.getString("greater"), ResourceStrings.getString("less")};
        FilterItemPanel filterItemPanel = new FilterItemPanel(stringArray2, stringArray3);
        Constraints.constrain(this, filterItemPanel, 0, -1, 1, 1, 2, 18, 1.0, 0.0, 0, 32, 5, 5);
        this.vFilterPanels.addElement(filterItemPanel);
        this.andRadioBtn = new JRadioButton(ResourceStrings.getString("and"), true);
        this.andRadioBtn.setForeground(Constants.PROPS_LABEL_COLOR);
        this.andRadioBtn.setFont(Constants.PROPS_LABEL_FONT);
        this.orRadioBtn = new JRadioButton(ResourceStrings.getString("or"), false);
        this.orRadioBtn.setForeground(Constants.PROPS_LABEL_COLOR);
        this.orRadioBtn.setFont(Constants.PROPS_LABEL_FONT);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.andRadioBtn);
        buttonGroup.add(this.orRadioBtn);
        Constraints.constrain(this, this.andRadioBtn, 0, -1, 2, 1, 0, 17, 0.0, 0.0, 0, 32, 0, 0);
        Constraints.constrain(this, this.orRadioBtn, 0, -1, 2, 1, 0, 17, 0.0, 0.0, 0, 32, 5, 0);
        filterItemPanel = new FilterItemPanel(stringArray2, stringArray3);
        Constraints.constrain(this, filterItemPanel, 0, -1, 1, 1, 2, 18, 1.0, 0.0, 0, 32, 5, 5);
        this.vFilterPanels.addElement(filterItemPanel);
        this.keyListener = new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                if (FilterPanel.this.clientTextActionListener == null) {
                    return;
                }
                FilterItemPanel filterItemPanel = null;
                int n = 0;
                int n2 = 0;
                while (n2 < FilterPanel.this.vFilterPanels.size()) {
                    filterItemPanel = (FilterItemPanel)FilterPanel.this.vFilterPanels.elementAt(n2);
                    n += filterItemPanel.getTextField().getText().length();
                    ++n2;
                }
                ActionEvent actionEvent = new ActionEvent(FilterPanel.this.filterPanel, n, "");
                FilterPanel.this.clientTextActionListener.actionPerformed(actionEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        int n2 = 0;
        while (n2 < this.vFilterPanels.size()) {
            filterItemPanel = (FilterItemPanel)this.vFilterPanels.elementAt(n2);
            this.addHelpListener(vector, genInfoPanel, filterItemPanel.getAttrComboBox(), "filter_col1.html");
            this.addHelpListener(vector, genInfoPanel, filterItemPanel.getOperatorComboBox(), "filter_col2.html");
            filterItemPanel.getTextField().addFocusListener(new ContextHelpListener(vector, this.getClass(), genInfoPanel, "html", "filter_col3.html"));
            filterItemPanel.getTextField().addKeyListener(this.keyListener);
            ++n2;
        }
        this.andRadioBtn.addFocusListener(new ContextHelpListener(vector, this.getClass(), genInfoPanel, "html", "filter_method.html"));
        this.orRadioBtn.addFocusListener(new ContextHelpListener(vector, this.getClass(), genInfoPanel, "html", "filter_method.html"));
        this.setDefaultState();
    }

    private void addHelpListener(Vector vector, GenInfoPanel genInfoPanel, Component component, String string) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(vector, genInfoPanel, componentArray[n], string);
                ++n;
            }
        }
        component.addFocusListener(new ContextHelpListener(vector, this.getClass(), genInfoPanel, "html", string));
    }

    private int getSearchAttribute(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 2;
        }
        if (n == 2) {
            return 5;
        }
        if (n == 3) {
            return 3;
        }
        if (n == 4) {
            return 4;
        }
        if (n == 5) {
            return 8;
        }
        if (n == 6) {
            return 7;
        }
        return -1;
    }

    private int getIndex(int n) {
        if (n == 1) {
            return 0;
        }
        if (n == 2) {
            return 1;
        }
        if (n == 5) {
            return 2;
        }
        if (n == 3) {
            return 3;
        }
        if (n == 4) {
            return 4;
        }
        if (n == 8) {
            return 5;
        }
        if (n == 7) {
            return 6;
        }
        return -1;
    }

    private int getBoolean() {
        if (this.andRadioBtn.isSelected()) {
            return 2;
        }
        if (this.orRadioBtn.isSelected()) {
            return 3;
        }
        return -1;
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.vFilterPanels.size()) {
            FilterItemPanel filterItemPanel = (FilterItemPanel)this.vFilterPanels.elementAt(n);
            filterItemPanel.getAttrComboBox().setEnabled(bl);
            filterItemPanel.getOperatorComboBox().setEnabled(bl);
            filterItemPanel.getTextField().setEnabled(bl);
            filterItemPanel.getTextField().setEditable(bl);
            ++n;
        }
        this.andRadioBtn.setEnabled(bl);
        this.orRadioBtn.setEnabled(bl);
        this.repaint();
    }

    public void setDefaultState() {
        int n = 0;
        while (n < this.vFilterPanels.size()) {
            FilterItemPanel filterItemPanel = (FilterItemPanel)this.vFilterPanels.elementAt(n);
            filterItemPanel.getAttrComboBox().setSelectedIndex(0);
            filterItemPanel.getOperatorComboBox().setSelectedIndex(0);
            filterItemPanel.getTextField().setText("");
            ++n;
        }
        this.andRadioBtn.setSelected(true);
        this.repaint();
    }

    public void setFilterItems(Vector vector) {
        this.setDefaultState();
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            FilterItem filterItem = (FilterItem)vector.elementAt(n);
            FilterItemPanel filterItemPanel = (FilterItemPanel)this.vFilterPanels.elementAt(n);
            filterItemPanel.getAttrComboBox().setSelectedItem(ResourceStrings.getString(this.bundle, filterItem.getAttribute()));
            filterItemPanel.getOperatorComboBox().setSelectedIndex(this.getIndex(filterItem.getOperator()));
            filterItemPanel.getTextField().setText(filterItem.getValue());
            this.andRadioBtn.setSelected(true);
            if (filterItem.getBooleanOperator() == 3) {
                this.orRadioBtn.setSelected(true);
            }
            if (filterItem.getBooleanOperator() == 2) {
                this.andRadioBtn.setSelected(true);
            }
            ++n;
        }
    }

    public Vector getFilterItems() {
        Vector<FilterItem> vector = new Vector<FilterItem>();
        int n = 0;
        while (n < this.vFilterPanels.size()) {
            FilterItemPanel filterItemPanel = (FilterItemPanel)this.vFilterPanels.elementAt(n);
            JComboBox jComboBox = filterItemPanel.getAttrComboBox();
            JComboBox jComboBox2 = filterItemPanel.getOperatorComboBox();
            JTextField jTextField = filterItemPanel.getTextField();
            if (jTextField.getText().length() != 0) {
                String string = this.attributes[jComboBox.getSelectedIndex()];
                int n2 = this.getSearchAttribute(jComboBox2.getSelectedIndex());
                int n3 = 1;
                if (vector.size() > 0 && this.andRadioBtn.isSelected()) {
                    n3 = 2;
                }
                if (vector.size() > 0 && this.orRadioBtn.isSelected()) {
                    n3 = 3;
                }
                try {
                    FilterItem filterItem = new FilterItem(string, n2, jTextField.getText(), n3);
                    vector.addElement(filterItem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        return vector;
    }

    private class FilterItemPanel
    extends JPanel {
        private JComboBox cbAttrs;
        private JComboBox cbOperators;
        private JTextField textField;

        public FilterItemPanel(String[] stringArray, String[] stringArray2) {
            this.setLayout(new GridBagLayout());
            this.cbAttrs = new JComboBox<String>(stringArray);
            this.cbAttrs.setSelectedIndex(0);
            this.cbAttrs.setForeground(Constants.PROPS_LABEL_COLOR);
            this.cbAttrs.setFont(Constants.PROPS_LABEL_FONT);
            Constraints.constrain(this, this.cbAttrs, 0, -1, 1, 1, 2, 17, 0.0, 0.0, 0, 0, 5, 0);
            this.cbOperators = new JComboBox<String>(stringArray2);
            this.cbOperators.setSelectedIndex(0);
            this.cbOperators.setForeground(Constants.PROPS_LABEL_COLOR);
            this.cbOperators.setFont(Constants.PROPS_LABEL_FONT);
            this.cbOperators.setMinimumSize(this.cbOperators.getPreferredSize());
            Constraints.constrain(this, this.cbOperators, 1, -1, 1, 1, 2, 17, 0.0, 0.0, 0, 10, 5, 0);
            this.textField = new JTextField(15);
            Constraints.constrain(this, this.textField, 0, -1, 2, 1, 2, 17, 1.0, 0.0, 0, 0, 5, 0);
        }

        public JComboBox getAttrComboBox() {
            return this.cbAttrs;
        }

        public JComboBox getOperatorComboBox() {
            return this.cbOperators;
        }

        public JTextField getTextField() {
            return this.textField;
        }
    }
}

