/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminException;
import java.io.Serializable;

public class FilterItem
implements Serializable {
    public static final int ATTR_CONTAINS = 1;
    public static final int ATTR_DOES_NOT_CONTAIN = 2;
    public static final int ATTR_STARTS_WITH = 3;
    public static final int ATTR_ENDS_WITH = 4;
    public static final int ATTR_EQUALS = 5;
    public static final int ATTR_DOES_NOT_EQUAL = 6;
    public static final int ATTR_LESS_THAN = 7;
    public static final int ATTR_GREATER_THAN = 8;
    public static final int ATTR_MAXIMUM = 8;
    public static final int BOOLEAN_NULL = 1;
    public static final int BOOLEAN_AND = 2;
    public static final int BOOLEAN_OR = 3;
    public static final int MAX_BOOLEAN_METHOD = 3;
    private static final String[] OP_LABEL = new String[]{"contains", "doesn't contain", "starts with", "ends with", "equals", "does not equal", "is less than", "is greater than"};
    private static final String[] BOOL_LABEL = new String[]{"NONE", "AND", "OR"};
    private String attribute = "";
    private int operator = 5;
    private String value = "";
    private int booleanOperator = 1;

    public FilterItem() throws AdminException {
    }

    public FilterItem(String string, int n, String string2, int n2) throws AdminException {
        this.setAttribute(string);
        this.setOperator(n);
        this.setValue(string2);
        this.setBooleanOperator(n2);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String string) throws AdminException {
        if (string == null || string.length() == 0) {
            throw new AdminException("Invalid value for attribute");
        }
        this.attribute = string;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int n) throws AdminException {
        if (n < 1 || n > 8) {
            throw new AdminException("Invalid operator");
        }
        this.operator = n;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) throws AdminException {
        if (string == null) {
            throw new AdminException("Invalid value");
        }
        this.value = string;
    }

    public int getBooleanOperator() {
        return this.booleanOperator;
    }

    public void setBooleanOperator(int n) throws AdminException {
        if (n < 1 || n > 3) {
            throw new AdminException("Invalid operator");
        }
        this.booleanOperator = n;
    }

    public void print() {
        System.out.println("Filter attribute is " + this.attribute);
        System.out.println("Filter operation is " + OP_LABEL[this.operator - 1]);
        System.out.println("Filter value is\t" + this.value);
        System.out.println("Filter boolean is\t" + BOOL_LABEL[this.booleanOperator - 1]);
    }
}

