/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.management.viper.util.ConsoleUtility;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ErrorDialog {
    private JDialog dialog;
    private String title = ResourceStrings.getString("error_title");
    private static ImageIcon errorIcon = null;
    private static ImageIcon infoIcon = null;
    private JButton cancelBtn = new JButton(ResourceStrings.getString("w_ok_button"));
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public ErrorDialog(final JFrame jFrame, final String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ErrorDialog.this.createErrorDialog(jFrame, ErrorDialog.this.title, string, false);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.createErrorDialog(jFrame, this.title, string, false);
        }
    }

    public ErrorDialog(final JFrame jFrame, final String string, final String string2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ErrorDialog.this.createErrorDialog(jFrame, string, string2, false);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.createErrorDialog(jFrame, string, string2, false);
        }
    }

    public ErrorDialog(final JFrame jFrame, final String string, final String string2, final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ErrorDialog.this.createErrorDialog(jFrame, string, string2, bl);
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            this.createErrorDialog(jFrame, string, string2, false);
        }
    }

    private void createErrorDialog(JFrame jFrame, String string, String string2, boolean bl) {
        this.dialog = new JDialog(jFrame, string, true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        SpecialKeyListener specialKeyListener = new SpecialKeyListener();
        this.dialog.addKeyListener(specialKeyListener);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel2, 0, 0, 1, 2, 3, 17, 0.0, 1.0, 5, 5, 5, 0);
        JLabel jLabel = this.getIconLabel(bl);
        Constraints.constrain(jPanel2, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel3 = new JPanel();
        Constraints.constrain(jPanel2, jPanel3, 0, 1, 1, 1, 3, 17, 0.0, 1.0, 0, 0, 0, 0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel4, 1, 0, 1, 1, 1, 17, 1.0, 1.0, 0, 0, 0, 0);
        FlowArea flowArea = new FlowArea(string2, 30, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel4, flowArea, 0, 0, 1, 1, 1, 17, 1.0, 1.0, 20, 10, 20, 20);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(gridBagLayout);
        Constraints.constrain(jPanel, jPanel5, 1, 1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        jPanel3 = new JPanel();
        Constraints.constrain(jPanel5, jPanel3, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.cancelBtn.addActionListener(new CancelBtnListener());
        Constraints.constrain(jPanel5, this.cancelBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        this.dialog.getContentPane().setLayout(gridBagLayout);
        Constraints.constrain(this.dialog.getContentPane(), jPanel, 0, 0, 1, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this.dialog.pack();
        this.dialog.pack();
        this.centerDialog();
        this.dialog.setResizable(false);
        this.cancelBtn.requestFocus();
        this.dialog.setVisible(true);
    }

    private JLabel getIconLabel(boolean bl) {
        JLabel jLabel;
        if (bl) {
            if (infoIcon == null) {
                infoIcon = ConsoleUtility.loadImageIcon((String)"/com/sun/admin/cis/common/images/info_icon.gif", this.getClass());
            }
            jLabel = new JLabel(infoIcon);
        } else {
            if (errorIcon == null) {
                errorIcon = ConsoleUtility.loadImageIcon((String)"/com/sun/admin/cis/common/images/error_icon.gif", this.getClass());
            }
            jLabel = new JLabel(errorIcon);
        }
        return jLabel;
    }

    public void centerDialog() {
        this.dialog.setLocation(ErrorDialog.screenSize.width / 2 - this.dialog.getSize().width / 2, ErrorDialog.screenSize.height / 2 - this.dialog.getSize().height / 2);
    }

    protected class SpecialKeyListener
    extends KeyAdapter {
        protected SpecialKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                ErrorDialog.this.cancelBtn.doClick();
            } else if (keyEvent.getKeyCode() == 27) {
                ErrorDialog.this.dialog.dispose();
            }
        }
    }

    protected class CancelBtnListener
    implements ActionListener {
        protected CancelBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ErrorDialog.this.dialog.dispose();
        }
    }
}

