/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.management.viper.util.ResourceManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ContextHelpListener
implements FocusListener {
    public static final String AUTHORIZATIONS_HELPDIR = "auths";
    public static final String PROFILES_HELPDIR = "profiles";
    private static final int MRU_INDEX = 0;
    private static final int REGISTRY_INDEX = 1;
    private static final int CACHE_INDEX = 2;
    private static final int MIN_CACHE_CAPACITY = 3;
    private Class toolClass;
    private GenInfoPanel infoPanel;
    private String appPath;
    private String helpName;
    private String html;
    private Vector cache;

    public ContextHelpListener(Class clazz, GenInfoPanel genInfoPanel, String string, String string2) {
        this(null, clazz, genInfoPanel, string, string2);
    }

    public ContextHelpListener(Vector vector, Class clazz, GenInfoPanel genInfoPanel, String string, String string2) {
        Vector vector2;
        this.infoPanel = genInfoPanel;
        this.helpName = string2;
        this.appPath = string;
        this.toolClass = clazz;
        this.html = null;
        this.cache = vector;
        if (this.cache != null && this.cache.capacity() < 2) {
            this.cache = null;
        }
        if (this.cache != null && this.cache.isEmpty()) {
            this.cache.ensureCapacity(this.cache.capacity() + 2);
            this.cache.add(0, null);
            this.cache.add(1, new Vector());
        }
        if (this.cache != null && (vector2 = (Vector)this.cache.elementAt(1)) != null) {
            vector2.add(this);
        }
    }

    protected boolean equals(ContextHelpListener contextHelpListener) {
        if (contextHelpListener == null) {
            return false;
        }
        if (this.toolClass != contextHelpListener.getToolClass()) {
            return false;
        }
        if (this.infoPanel != contextHelpListener.getInfoPanel()) {
            return false;
        }
        if (this.appPath.compareTo(contextHelpListener.getAppPath()) != 0) {
            return false;
        }
        if (this.helpName.compareTo(contextHelpListener.getHelpName()) != 0) {
            return false;
        }
        if (this.html.length() != contextHelpListener.getHtml().length()) {
            return false;
        }
        return this.html.compareTo(contextHelpListener.getHtml()) == 0;
    }

    private static boolean equals(ContextHelpListener contextHelpListener, ContextHelpListener contextHelpListener2) {
        if (contextHelpListener == null || contextHelpListener2 == null) {
            return false;
        }
        if (contextHelpListener.getToolClass() != contextHelpListener2.getToolClass()) {
            return false;
        }
        if (contextHelpListener.getInfoPanel() != contextHelpListener2.getInfoPanel()) {
            return false;
        }
        if (contextHelpListener.getAppPath().compareTo(contextHelpListener2.getAppPath()) != 0) {
            return false;
        }
        return contextHelpListener.getHelpName().compareTo(contextHelpListener2.getHelpName()) == 0;
    }

    public static ContextHelpListener findMatch(ContextHelpListener contextHelpListener) {
        if (contextHelpListener.cache == null || contextHelpListener.cache.capacity() < 3 || contextHelpListener.cache.size() < 2) {
            return null;
        }
        int n = 2;
        while (n < contextHelpListener.cache.size()) {
            ContextHelpListener contextHelpListener2 = (ContextHelpListener)contextHelpListener.cache.elementAt(n);
            if (ContextHelpListener.equals(contextHelpListener2, contextHelpListener)) {
                return contextHelpListener2;
            }
            ++n;
        }
        return null;
    }

    private static ContextHelpListener findMatchInRegistry(ContextHelpListener contextHelpListener) {
        if (contextHelpListener.cache == null || contextHelpListener.cache.capacity() < 3 || contextHelpListener.cache.size() < 2) {
            return null;
        }
        Object e = contextHelpListener.cache.elementAt(1);
        if (e == null || !(e instanceof Vector)) {
            return null;
        }
        Vector vector = (Vector)e;
        int n = 0;
        while (n < vector.size()) {
            ContextHelpListener contextHelpListener2;
            Object e2 = vector.elementAt(n);
            if (e2 != null && e2 instanceof ContextHelpListener && ContextHelpListener.equals(contextHelpListener2 = (ContextHelpListener)e2, contextHelpListener)) {
                return contextHelpListener2;
            }
            ++n;
        }
        return null;
    }

    public void removeFromCache() {
        if (this.cache == null) {
            return;
        }
        if (this.cache == null || this.cache.capacity() < 3 || this.cache.size() < 2) {
            return;
        }
        Object e = this.cache.elementAt(1);
        if (e == null || !(e instanceof Vector)) {
            return;
        }
        Vector vector = (Vector)e;
        if (vector != null) {
            return;
        }
        vector.removeElement(this);
    }

    public String getHtml() {
        return this.html;
    }

    public Class getToolClass() {
        return this.toolClass;
    }

    public Vector getCache() {
        return this.cache;
    }

    protected GenInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public String getAppPath() {
        return this.appPath;
    }

    protected String getHelpName() {
        return this.helpName;
    }

    protected void flushHtml() {
        this.html = null;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.html == null) {
            try {
                ContextHelpListener.loadHelp(this);
            }
            catch (AdminException adminException) {
                this.html = adminException.getLocalizedMessage();
            }
        }
        ContextHelpListener.loadHelp(this.cache);
        ContextHelpListener contextHelpListener = null;
        if (this.cache != null) {
            if (this.cache.indexOf(this, 2) < 0) {
                if (this.cache.size() - 1 == this.cache.capacity() - 1) {
                    ContextHelpListener contextHelpListener2 = (ContextHelpListener)this.cache.remove(2);
                    contextHelpListener2.flushHtml();
                }
                this.cache.add(this);
            }
            contextHelpListener = (ContextHelpListener)this.cache.elementAt(0);
        }
        if (contextHelpListener != null && contextHelpListener.equals(this) && this.html.length() == this.infoPanel.getText().length() && this.html.compareTo(this.infoPanel.getText()) == 0) {
            return;
        }
        if (this.cache == null && this.html.length() == this.infoPanel.getText().length() && this.html.compareTo(this.infoPanel.getText()) == 0) {
            return;
        }
        this.infoPanel.setText(this.html);
        if (focusEvent != null) {
            this.infoPanel.hyperBoot(this);
        }
        if (this.cache != null) {
            this.cache.setElementAt(this, 0);
        }
    }

    public static synchronized void loadHelp(ContextHelpListener contextHelpListener) throws AdminException {
        ContextHelpListener contextHelpListener2 = ContextHelpListener.findMatchInRegistry(contextHelpListener);
        if (contextHelpListener2 != null && contextHelpListener2.html != null) {
            contextHelpListener.html = contextHelpListener2.html;
        } else if (contextHelpListener.toolClass != null) {
            String string = contextHelpListener.appPath + "/" + contextHelpListener.helpName;
            contextHelpListener.html = ResourceManager.getLocalizedTextFile((String)string, (Class)contextHelpListener.toolClass);
            if (contextHelpListener.html == null) {
                throw new AdminClientException("EXM_CTXHELP_CantLoadHelpFile", string);
            }
        } else {
            int n = contextHelpListener.appPath.indexOf(":/");
            if (n <= 1) {
                throw new AdminClientException("EXM_CTXHELP_MalformedRightsURL", contextHelpListener.helpName, contextHelpListener.appPath);
            }
            String string = contextHelpListener.appPath.substring(0, n);
            String string2 = contextHelpListener.appPath.substring(n + 2);
            if (string2.compareToIgnoreCase(AUTHORIZATIONS_HELPDIR) == 0) {
                contextHelpListener.html = ResourceManager.getLocalizedAuthHTML((String)string, (String)contextHelpListener.helpName);
            } else if (string2.compareToIgnoreCase(PROFILES_HELPDIR) == 0) {
                contextHelpListener.html = ResourceManager.getLocalizedProfileHTML((String)string, (String)contextHelpListener.helpName);
            } else {
                String string3 = AUTHORIZATIONS_HELPDIR;
                string3 = string3 + "  ";
                string3 = string3 + PROFILES_HELPDIR;
                AdminClientException adminClientException = new AdminClientException("EXM_CTXHELP_UnsupportedDirectory", contextHelpListener.helpName, string2, string);
                adminClientException.addArg(string3);
                throw adminClientException;
            }
            if (contextHelpListener.html == null) {
                throw new AdminClientException("EXM_CTXHELP_CantLoadRightsHelpFile", contextHelpListener.helpName, string2, string);
            }
        }
    }

    public static synchronized void loadHelp(Vector vector) {
        if (vector == null || vector.capacity() < 3 || vector.size() < 2) {
            return;
        }
        Object e = vector.elementAt(1);
        if (e == null || !(e instanceof Vector)) {
            return;
        }
        final Vector vector2 = (Vector)e;
        Thread thread = new Thread(){

            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            int n = 0;
                            while (n < 1.access$000(this.this$0).size()) {
                                ContextHelpListener contextHelpListener;
                                E e = 1.access$000(this.this$0).elementAt(n);
                                if (e != null && e instanceof ContextHelpListener && ContextHelpListener.access$100(contextHelpListener = (ContextHelpListener)e) == null) {
                                    try {
                                        ContextHelpListener.loadHelp(contextHelpListener);
                                    }
                                    catch (AdminException adminException) {
                                        // empty catch block
                                    }
                                }
                                ++n;
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            static /* synthetic */ Vector access$000(1 var0) {
                return var0.vector2;
            }
        };
        thread.start();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public ContextHelpListener getCurrent() {
        return (ContextHelpListener)this.cache.elementAt(0);
    }

    public String toString() {
        if (this.toolClass != null) {
            return this.toolClass.getName() + "." + this.appPath + "." + this.helpName;
        }
        return this.appPath + "." + this.helpName;
    }

    static /* synthetic */ String access$100(ContextHelpListener contextHelpListener) {
        return contextHelpListener.html;
    }
}

