/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class Clock
extends JPanel
implements Runnable {
    private Date currentDate;
    private JLabel clockString;
    private Thread runner;
    private SimpleDateFormat formatter;
    private long startTime;
    private long timeStamp;

    public Clock() {
        this.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.clockString = new JLabel();
        this.clockString.setHorizontalAlignment(0);
        this.clockString.setFont(new Font("SanSerif", 1, 28));
        this.clockString.setForeground(Color.black);
        this.add((Component)this.clockString, "Center");
        this.formatter = new SimpleDateFormat("h:mm:ss a");
        this.runner = new Thread(this);
    }

    public Date getDate() {
        return this.currentDate;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.currentDate = date;
            this.startTime = this.currentDate.getTime();
            this.timeStamp = System.currentTimeMillis();
            if (!this.runner.isAlive()) {
                this.runner.start();
            }
        }
    }

    private void updateDisplay() {
        this.clockString.setText(this.formatter.format(this.currentDate));
    }

    public void run() {
        boolean bl = false;
        while (bl < true) {
            try {
                Thread.sleep(1000L);
                long l = System.currentTimeMillis();
                this.currentDate.setTime(this.startTime + (l - this.timeStamp));
                this.updateDisplay();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

