/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.ResourceStrings;

public class CheckSyntax {
    public static final int NAME_MIN = 2;
    public static final int NAME_LIMIT = 32;
    public static final int DESC_LIMIT = 256;
    private static String errorString;
    private static final int MAX_PASSWD_LEN = 15;

    public void CheckSyntax() {
        CheckSyntax.setErrorString(" ");
    }

    public static void setErrorString(String string) {
        errorString = string;
    }

    public static String getErrorString() {
        return errorString;
    }

    public static boolean isNameOK(String string) {
        String[] stringArray = new String[]{"0", "_", "-", "."};
        if (string.length() < 2) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_name_length1"));
            return false;
        }
        if (!Character.isLetter(string.charAt(0))) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_name_begin"));
            return false;
        }
        if (string.length() > 32) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_name_length2"));
            return false;
        }
        if (!CheckSyntax.isOneLowerCase(string)) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_lowercase"));
            return false;
        }
        if (!CheckSyntax.isStringOK(string, stringArray)) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_name_an"));
            return false;
        }
        return true;
    }

    public static boolean contains(String string, int n) {
        return string.indexOf(n) != -1;
    }

    public static boolean isUIDOK(String string) {
        long l = Long.parseLong(string);
        if (l < 100L) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_uid_100"));
            return false;
        }
        if (l > Integer.MAX_VALUE) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_uid_high"));
            return false;
        }
        if (l == 60001L || l == 60002L || l == 65534L) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_uid_res"));
            return false;
        }
        return true;
    }

    public static boolean isDescLenOK(String string) {
        if (string.length() > 256) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_desc"));
            return false;
        }
        if (string.indexOf("\n") > -1) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_desc"));
            return false;
        }
        if (string.indexOf(":") > -1) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_desc"));
            return false;
        }
        return true;
    }

    public static boolean isPasswordConf(String string, String string2) {
        if (!string.equals(string2)) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_passwd_match"));
            return false;
        }
        return CheckSyntax.isPasswordLenOK(string);
    }

    public static boolean isPasswordLenOK(String string) {
        String[] stringArray = new String[]{"!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "|", "~", "-", "=", "{", "}", "[", "]", ":", ";", "'", "`", "<", ">", "?", ",", ".", "/", "\\", "\""};
        boolean bl = false;
        int n = 0;
        if (!string.equals("")) {
            if (string.length() < 6) {
                CheckSyntax.setErrorString(ResourceStrings.getString("cs_passwd_len"));
                return false;
            }
            if (string.length() > 15) {
                CheckSyntax.setErrorString(ResourceStrings.getString("cs_passwd_len1"));
                return false;
            }
            String string2 = string.substring(0, 6);
            int n2 = 0;
            while (n2 < 6) {
                char c = string2.charAt(n2);
                if (Character.isLetter(c)) {
                    ++n;
                } else if (Character.isDigit(c)) {
                    bl = true;
                } else {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (String.valueOf(c).equals(stringArray[n3])) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                }
                if (n > 1 && bl) {
                    return true;
                }
                ++n2;
            }
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_passwd_char"));
            return false;
        }
        return true;
    }

    public static boolean isHomeDirServerOK(String string) {
        String[] stringArray = new String[]{"0", "-"};
        if (string.equals("")) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_server"));
            return false;
        }
        if (string.length() > 255) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_server_len"));
            return false;
        }
        if (!Character.isLetterOrDigit(string.charAt(0))) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_server_name"));
            return false;
        }
        if (!CheckSyntax.isStringOK(string, stringArray)) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_server_syn"));
            return false;
        }
        return true;
    }

    public static boolean isHomeDirPathnameOK(String string) {
        String[] stringArray = new String[]{"0", "-", "/", ".", "_"};
        if (string.equals("")) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_path"));
            return false;
        }
        if (!String.valueOf(string.charAt(0)).equals("/")) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_path_slash"));
            return false;
        }
        if (!CheckSyntax.isPathLenOK(string)) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_path_len"));
            return false;
        }
        if (!CheckSyntax.isStringOK(string, stringArray)) {
            CheckSyntax.setErrorString(ResourceStrings.getString("cs_hdir_path_syn"));
            return false;
        }
        return true;
    }

    private static boolean isPathLenOK(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (String.valueOf(c).equals("/") && (n3 = n) - n2 > 255) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isOneLowerCase(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isLowerCase(c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isStringOK(String string, String[] stringArray) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetterOrDigit(c)) {
                int n2 = stringArray.length;
                boolean bl = false;
                if (n2 == 1) {
                    return false;
                }
                int n3 = 1;
                while (n3 < n2) {
                    if (String.valueOf(c).equals(stringArray[n3])) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }
}

