/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CalendarWidget
extends JPanel {
    private static final Dimension MIN_SIZE = new Dimension(230, 310);
    private static final String[] headers = new String[]{ResourceStrings.getString("firstDay"), ResourceStrings.getString("secondDay"), ResourceStrings.getString("thirdDay"), ResourceStrings.getString("fourthDay"), ResourceStrings.getString("fifthDay"), ResourceStrings.getString("sixthDay"), ResourceStrings.getString("seventhDay")};
    private static final String[] months = new String[]{ResourceStrings.getString("january"), ResourceStrings.getString("february"), ResourceStrings.getString("march"), ResourceStrings.getString("april"), ResourceStrings.getString("may"), ResourceStrings.getString("june"), ResourceStrings.getString("july"), ResourceStrings.getString("august"), ResourceStrings.getString("september"), ResourceStrings.getString("october"), ResourceStrings.getString("november"), ResourceStrings.getString("december")};
    private GridBagLayout bag = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();
    private Date currentDate;
    private GregorianCalendar gc;
    private JTable calendar;
    private JComboBox monthCombo;
    private JIntSpinBox yearSpinner;
    private YearListener yearListener;
    private boolean bConstructed = false;
    private CalendarTableModel dataModel;
    Object[][] data = new Object[][]{{"", "", "", "", "", "", ""}, {"", "", "", "", "", "", ""}, {"", "", "", "", "", "", ""}, {"", "", "", "", "", "", ""}, {"", "", "", "", "", "", ""}, {"", "", "", "", "", "", ""}};

    public CalendarWidget() {
        this(new GregorianCalendar());
        this.bConstructed = true;
    }

    public CalendarWidget(GregorianCalendar gregorianCalendar) {
        this.setLayout(new BorderLayout());
        this.createGUI();
        this.addFocusListener(new CWFocusListener());
        this.setCalendar(gregorianCalendar);
    }

    private void createGUI() {
        this.setLayout(this.bag);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        this.monthCombo = new JComboBox<String>(months);
        this.monthCombo.setEditable(false);
        this.monthCombo.addItemListener(new MonthListener());
        Constraints.constrain(jPanel, this.monthCombo, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 0);
        this.yearSpinner = new JIntSpinBox(4, 0, 3000);
        this.yearListener = new YearListener();
        this.yearSpinner.setEditable(false);
        this.yearSpinner.getUpButton().addActionListener(this.yearListener);
        this.yearSpinner.getDownButton().addActionListener(this.yearListener);
        Constraints.constrain(jPanel, this.yearSpinner, 1, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 6, 0, 0);
        Constraints.constrain(this, jPanel, 0, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        Constraints.constrain(this, this.buildCalendar(), 0, 1, 1, 1, 1, 17, 1.0, 1.0, 12, 0, 0, 0);
        this.setMinimumSize(MIN_SIZE);
        this.setPreferredSize(MIN_SIZE);
    }

    private JScrollPane buildCalendar() {
        this.dataModel = new CalendarTableModel();
        this.calendar = new CalendarTable(this.dataModel);
        this.calendar.getTableHeader().setReorderingAllowed(false);
        this.calendar.setShowGrid(false);
        this.calendar.setRowSelectionAllowed(false);
        this.calendar.setCellSelectionEnabled(true);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumnModel tableColumnModel = this.calendar.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            ++n;
        }
        return new JScrollPane(this.calendar);
    }

    public void setCalendar(GregorianCalendar gregorianCalendar) {
        this.gc = gregorianCalendar;
        this.setDate(this.gc.getTime());
    }

    public Date getDate() {
        return this.currentDate;
    }

    public void setDate(Date date) {
        if (date != null) {
            this.currentDate = date;
            this.gc.setTime(this.currentDate);
            this.yearSpinner.setIntValue(this.gc.get(1));
            this.monthCombo.setSelectedIndex(this.gc.get(2));
            this.updateDisplay();
        }
    }

    public int getDay() {
        return this.gc.get(5);
    }

    public void setDay(int n) {
        this.gc.set(5, n);
        this.updateDisplay();
    }

    public int getMonth() {
        return this.gc.get(2);
    }

    public void setMonth(int n) {
        switch (n) {
            case 0: {
                this.gc.clear(2);
                this.gc.set(2, 0);
                break;
            }
            case 1: {
                this.gc.clear(2);
                this.gc.set(2, 1);
                break;
            }
            case 2: {
                this.gc.clear(2);
                this.gc.set(2, 2);
                break;
            }
            case 3: {
                this.gc.clear(2);
                this.gc.set(2, 3);
                break;
            }
            case 4: {
                this.gc.clear(2);
                this.gc.set(2, 4);
                break;
            }
            case 5: {
                this.gc.clear(2);
                this.gc.set(2, 5);
                break;
            }
            case 6: {
                this.gc.clear(2);
                this.gc.set(2, 6);
                break;
            }
            case 7: {
                this.gc.clear(2);
                this.gc.set(2, 7);
                break;
            }
            case 8: {
                this.gc.clear(2);
                this.gc.set(2, 8);
                break;
            }
            case 9: {
                this.gc.clear(2);
                this.gc.set(2, 9);
                break;
            }
            case 10: {
                this.gc.clear(2);
                this.gc.set(2, 10);
                break;
            }
            case 11: {
                this.gc.clear(2);
                this.gc.set(2, 11);
                break;
            }
        }
        this.updateDisplay();
    }

    private int getLengthOfMonth(int n, int n2) {
        switch (n) {
            case 1: {
                if (this.gc.isLeapYear(n2)) {
                    return 29;
                }
                return 28;
            }
            case 8: {
                return 30;
            }
            case 3: {
                return 30;
            }
            case 5: {
                return 30;
            }
            case 10: {
                return 30;
            }
        }
        return 31;
    }

    public int getYear() {
        return this.gc.get(1);
    }

    public void setYear(int n) {
        this.gc.clear(1);
        this.gc.set(1, n);
        this.updateDisplay();
    }

    private void updateDisplay() {
        int n;
        int n2;
        int n3 = this.getLengthOfMonth(this.gc.get(2), this.gc.get(1));
        this.initData();
        int n4 = this.gc.get(5);
        if (n4 > n3) {
            n4 -= n3;
        }
        int n5 = this.gc.get(7);
        int n6 = this.gc.get(4);
        int n7 = n6 - 1;
        while (n7 > -1 && n4 > 0) {
            n2 = n5 - 1;
            while (n2 > -1 && n4 > 0) {
                this.data[n7][n2] = new Integer(n4--).toString();
                --n2;
            }
            n5 = 7;
            --n7;
        }
        n4 = this.gc.get(5);
        n5 = this.gc.get(7);
        if (n4 > n3) {
            n4 -= n3;
        }
        n2 = n6 - 1;
        while (n2 < 7 && n4 < n3) {
            n = n5;
            while (n < 7 && n4 < n3) {
                this.data[n2][n] = new Integer(++n4).toString();
                ++n;
            }
            n5 = 0;
            ++n2;
        }
        n = 0;
        int n8 = 0;
        String string = new Integer(this.getDay()).toString();
        int n9 = 0;
        while (n9 < this.dataModel.getRowCount()) {
            int n10 = 0;
            while (n10 < this.dataModel.getColumnCount()) {
                try {
                    if (((String)this.dataModel.getValueAt(n9, n10)).equals(string)) {
                        n = n9;
                        n8 = n10;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n10;
            }
            ++n9;
        }
        this.calendar.clearSelection();
        this.calendar.addRowSelectionInterval(n, n);
        this.calendar.addColumnSelectionInterval(n8, n8);
        this.validate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.height / 7;
        if (n > 1) {
            this.calendar.setRowHeight(n);
        }
        super.paint(graphics);
    }

    private void initData() {
        int n = 0;
        while (n < 6) {
            int n2 = 0;
            while (n2 < 7) {
                this.data[n][n2] = "";
                ++n2;
            }
            ++n;
        }
    }

    public int get(int n) {
        int n2 = -1;
        switch (n) {
            case 5: {
                Integer n3 = new Integer((String)this.calendar.getValueAt(this.calendar.getSelectedRow(), this.calendar.getSelectedColumn()));
                n2 = n3;
                break;
            }
            case 2: {
                n2 = this.monthCombo.getSelectedIndex();
                break;
            }
            case 1: {
                n2 = this.yearSpinner.getIntValue();
            }
        }
        return n2;
    }

    public void addMonthListener(ItemListener itemListener) {
        this.monthCombo.addItemListener(itemListener);
    }

    public void addYearListener(DocumentListener documentListener) {
        this.yearSpinner.getTextField().getDocument().addDocumentListener(documentListener);
    }

    public void daySelectionChanged() {
    }

    protected boolean isConstructed() {
        return this.bConstructed;
    }

    private class CWFocusListener
    implements FocusListener {
        private CWFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            CalendarWidget.this.monthCombo.grabFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class YearListener
    implements ActionListener {
        private YearListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(CalendarWidget.this.yearSpinner.getUpButton())) {
                CalendarWidget.this.setYear(CalendarWidget.this.yearSpinner.getIntValue() + 1);
            } else if (actionEvent.getSource().equals(CalendarWidget.this.yearSpinner.getDownButton())) {
                CalendarWidget.this.setYear(CalendarWidget.this.yearSpinner.getIntValue() - 1);
            }
        }
    }

    private class MonthListener
    implements ItemListener {
        private MonthListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            CalendarWidget.this.setMonth(CalendarWidget.this.monthCombo.getSelectedIndex());
        }
    }

    private class CalendarTableModel
    extends AbstractTableModel {
        private CalendarTableModel() {
        }

        public int getColumnCount() {
            return headers.length;
        }

        public int getRowCount() {
            return CalendarWidget.this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return CalendarWidget.this.data[n][n2];
        }

        public String getColumnName(int n) {
            return headers[n];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            CalendarWidget.this.data[n][n2] = object;
        }
    }

    private class CalendarTable
    extends JTable {
        private boolean bConstructed = true;
        private String daySelected = "";

        public CalendarTable(TableModel tableModel) {
            super(tableModel);
        }

        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            this.daySelected = (String)CalendarWidget.this.calendar.getValueAt(n, n2);
            if (this.daySelected.equals("")) {
                return;
            }
            super.changeSelection(n, n2, false, false);
            if (this.bConstructed && CalendarWidget.this.isConstructed() && CalendarWidget.this.calendar.getSelectedRow() >= 0 && CalendarWidget.this.calendar.getSelectedColumn() >= 0) {
                try {
                    Integer n3 = new Integer(this.daySelected);
                    CalendarWidget.this.setDay(n3);
                    CalendarWidget.this.daySelectionChanged();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }
}

