/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.management.viper.console.gui.VOptionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class AdminDialog
extends JDialog {
    protected AdminDialog adminDlg = this;
    protected JPanel buttonPanel;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton applyBtn = null;
    private JPanel rightPanel;
    private boolean cancelBtnHasFocus = false;
    private GenInfoPanel infoPanel = null;
    private VOptionPane vOptionPane;

    public AdminDialog(Frame frame, String string, boolean bl) {
        super(frame, string, true);
        this.okBtn = new JButton(ResourceStrings.getString("AD_OkButton"));
        if (bl) {
            this.applyBtn = new JButton(ResourceStrings.getString("AD_ApplyButton"));
        }
        this.cancelBtn = new JButton(ResourceStrings.getString("AD_CancelButton"));
        this.setupAdminDialog(bl);
    }

    public AdminDialog(Dialog dialog, String string) {
        super(dialog, string, false);
        this.okBtn = new JButton(ResourceStrings.getString("AD_ApplyButton"));
        this.applyBtn = new JButton(ResourceStrings.getString("AD_ResetButton"));
        this.cancelBtn = new JButton(ResourceStrings.getString("AD_CloseButton"));
        this.setupAdminDialog(true);
    }

    private void setupAdminDialog(boolean bl) {
        Boolean bl2 = (Boolean)AdminCommonTools.CMN_getPreference("global", "DlgInfoPanelOpened", Boolean.TRUE);
        this.vOptionPane = new VOptionPane("", bl2.booleanValue());
        this.infoPanel = new GenInfoPanel(this.vOptionPane);
        this.vOptionPane.getContentPane().setLayout(new BorderLayout());
        this.vOptionPane.setContainer((Component)this);
        this.rightPanel = (JPanel)this.vOptionPane.getContentPane();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.okBtn.setFocusPainted(true);
        Constraints.constrain(this.buttonPanel, this.okBtn, -1, 0, 1, 1, 0, 0, 0, 0);
        if (bl) {
            this.applyBtn.setFocusPainted(true);
            Constraints.constrain(this.buttonPanel, this.applyBtn, -1, 0, 1, 1, 0, 5, 0, 0);
        }
        this.cancelBtn.setFocusPainted(true);
        Constraints.constrain(this.buttonPanel, this.cancelBtn, -1, 0, 1, 1, 0, 5, 0, 0);
        this.cancelBtn.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                AdminDialog.this.cancelBtnHasFocus = true;
            }

            public void focusLost(FocusEvent focusEvent) {
                AdminDialog.this.cancelBtnHasFocus = false;
            }
        });
        JComponent jComponent = this.vOptionPane.getButtonPane();
        jComponent.setLayout(new GridBagLayout());
        Constraints.constrain(jComponent, this.buttonPanel, 0, 0, 1, 1, 0, 13, 1.0, 0.0, 5, 0, 5, 10);
        EscKeyListener escKeyListener = new EscKeyListener();
        EnterKeyListener enterKeyListener = new EnterKeyListener();
        this.vOptionPane.registerKeyboardAction((ActionListener)escKeyListener, KeyStroke.getKeyStroke(27, 0, true), 2);
        this.vOptionPane.registerKeyboardAction((ActionListener)enterKeyListener, KeyStroke.getKeyStroke(10, 0, true), 2);
    }

    public GenInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public JButton getOKBtn() {
        return this.okBtn;
    }

    public JButton getApplyBtn() {
        return this.applyBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public JPanel getbuttonPanel() {
        return this.buttonPanel;
    }

    public void addHelpToInfoPanel(String string) {
        try {
            this.infoPanel.setUrl(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void setDefaultFocusListener(FocusListener focusListener, boolean bl) {
        this.infoPanel.setFocusListener(focusListener, bl);
    }

    public void onEnterKey() {
        if (this.okBtn.hasFocus()) {
            this.okBtn.doClick();
        } else if (this.cancelBtn.hasFocus()) {
            this.cancelBtn.doClick();
        }
    }

    protected class EnterKeyListener
    implements ActionListener {
        protected EnterKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AdminDialog.this.cancelBtnHasFocus) {
                AdminDialog.this.adminDlg.dispose();
            } else {
                AdminDialog.this.adminDlg.onEnterKey();
            }
        }
    }

    protected class EscKeyListener
    implements ActionListener {
        protected EscKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AdminDialog.this.adminDlg.dispose();
        }
    }
}

