/*
 *  Copyright (c) 2000 Sun Microsystems.  All rights reserved.
 *  All rights reserved.
 * 
 *  Use of this software is governed by the terms of the license agreement 
 *  for the Sun ONE Compass Server between the parties.
 */


/* ------------------------------------------------------------------------ */


/*
 * libcs - Sun ONE Compass Server common library
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#ifndef _LIBCS_CS_H_
#define _LIBCS_CS_H_

#ifdef XP_WIN32
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NSAPI_PUBLIC_DEFINES
#define NSAPI_PUBLIC_DEFINES
#ifdef XP_WIN32
#ifndef NSAPI_PUBLIC
#define NSAPI_PUBLIC    __declspec(dllexport)
#endif
typedef enum { B_FALSE, B_TRUE } boolean_t;
#else
#if defined(HPUX) || defined(OSF1) || defined(Linux)
typedef enum { B_FALSE, B_TRUE } boolean_t;
#else
#if defined(AIX)
#include <sys/types.h>		/* for boolean_t */
#define B_FALSE 0		/* boolean_t is an int */
#define B_TRUE  1
#else
#include <sys/types.h>		/* for boolean_t */
#endif /* HPUX */
#endif /* AIX */
#ifndef NSAPI_PUBLIC
#define NSAPI_PUBLIC
#endif
#endif /* XP_WIN32 */
#define NSAPI_PRIVATE   static
#endif /* !NSAPI_PUBLIC_DEFINES */

/* Version string */
NSAPI_PUBLIC const char *LIBCS_Version(void);

#include "libcs/adt.h"
#include "libcs/log.h"
#include "libcs/getopt.h"
#include "libcs/csidcf.h"
#include "libcs/pblock.h"

/* don't know where to put these... */
#include <time.h>
NSAPI_PUBLIC void cs_time2str(time_t, char *, int);
NSAPI_PUBLIC void cs_time2str_simple_dateonly(time_t, char *, int);
NSAPI_PUBLIC void cs_time2str_simple_datetimeonly(time_t, char *, int);
NSAPI_PUBLIC void cs_time2informix(time_t, char *, int);
NSAPI_PUBLIC void cs_str2time(const char *, time_t *);
NSAPI_PUBLIC time_t BAT_ParseTimeString (const char *str, int default_to_gmt);

#ifdef XP_WIN32
typedef __int64 longlong;
typedef unsigned __int64 ulonglong;
#else
typedef long long longlong;
typedef unsigned long long ulonglong;
#endif

/*
 * Where is compass-nick?
 * Sets dir to NULL if can't find compass-nick.
 * Returns -1 on error, 0 on success.
 */
NSAPI_PUBLIC int cs_instance_dir(const char **dir);

/* MD5 Support */
NSAPI_PUBLIC void libcs_md5_print(unsigned char *buf, unsigned char digest[]);
NSAPI_PUBLIC void libcs_md5_print_from_memory(char *s, int sz, char *digestStr);
NSAPI_PUBLIC void libcs_md5_get_from_file(CSIO *file, unsigned char digest[]);
NSAPI_PUBLIC void libcs_md5_get_from_memory(unsigned char *s, int sz, unsigned char digest[]);
#define libcs_md5_print_from_string(s, d) \
	libcs_md5_print_from_memory((s), strlen(s), d)

/* for backwards compatibility */
#define cs_mem2md5str	libcs_md5_print_from_memory
#define cs_mem2md5	libcs_md5_get_from_memory
#define cs_print_md5	libcs_md5_print

/* searches envvar for the given fn */
/* XXX not thread safe -- uses strtok() */
NSAPI_PUBLIC char *cs_search_path(char *fn, char *envvar);

/* process limits shuffling */
/* set file descriptor table to max */
NSAPI_PUBLIC void libcs_max_filedescs(void);  
NSAPI_PUBLIC void libcs_max_heap(void); /* no limits on heap */
NSAPI_PUBLIC void libcs_set_cputime(int r);
NSAPI_PUBLIC void libcs_set_filedescs(int r);

/* like system(3) command on Unix and NT, and allows you to chdir first */
NSAPI_PUBLIC int cs_limited_cli_run(char *cmd, char *working_dir, int fsize, int limtime,
				int mask_signal, int no_pipe, void (*system_poll)(void));
NSAPI_PUBLIC int cs_limited_cli_run_wait(char *cmd, char *working_dir, int fsize, 
				int limtime, int mask_signal, int no_pipe, 
				void (*system_poll)(void), int do_wait, int do_flush);
NSAPI_PUBLIC int cs_cli_run_no_flush(char *cmd, char *working_dir);
NSAPI_PUBLIC int cs_cli_run_no_pipe(char *cmd, char *working_dir);
NSAPI_PUBLIC int cs_cli_run(char *cmd, char *working_dir);
NSAPI_PUBLIC int cs_cli_run_no_pipe_poll(char *cmd, char *working_dir, void (*system_poll)(void));
NSAPI_PUBLIC int cs_cli_run_poll(char *cmd, char *working_dir, void (*system_poll)(void));

/* stuff stolen from base */
NSAPI_PUBLIC char *libcs_uri_escape(char *od, char *s);
NSAPI_PUBLIC void libcs_uri_unescape(char *s);

#ifdef XP_UNIX
/* 
 *  libcs_daemonize - daemonizes a process with a fork() 
 *  if do_fork is non-zero.  If pidfile is set, it'll write
 *  the new process id to that file.  Unix only.
 *
 *  WARNING: on errors it logs the error with cslog_error, and exit(3)'s.
 */
NSAPI_PUBLIC void libcs_daemonize(int do_fork, char *pidfile);
#endif

/* Some XP - cross-platform stuff */

#if defined(XP_WIN32)
#undef strcasecmp
#define strcasecmp		stricmp
#undef strncasecmp
#define strncasecmp		strnicmp
#endif

/* legacy */
#define LIBCS_strcasecmp	strcasecmp
#define LIBCS_strncasecmp	strncasecmp

NSAPI_PUBLIC longlong libcs_filesize(char *fn);
NSAPI_PUBLIC time_t libcs_filelmt(char *fn);
NSAPI_PUBLIC int libcs_isdir(const char *dir);

#ifdef XP_WIN32
#include <io.h>	/* _access, rename */
#define libcs_srandom(x)		srand((unsigned int)x)
#define libcs_random()			((int)rand())
#define libcs_unlink(fn)		_unlink(fn)
#define libcs_rename(a,b)		rename(a,b)
#define libcs_mkdir(fn)			_mkdir(fn)
#define libcs_chdir(d)			SetCurrentDirectory(d)
#define libcs_file_isreadable(fn)	(_access(fn, 04) == 0)
#define libcs_file_iswritable(fn)	(_access(fn, 02) == 0)
#define libcs_file_ispresent(fn)	(_access(fn, 00) == 0)
#else
#include <unistd.h> /* access */
#define libcs_srandom(x)		srand((unsigned int)x)
#define libcs_random()			((int)rand())
#define libcs_random_r(x)			((int)rand_r((unsigned int *)x))
#define libcs_unlink(fn)		unlink(fn)
#define libcs_rename(a,b)		rename(a,b)
#define libcs_mkdir(fn)			mkdir(fn, 0755)
#define libcs_chdir(d)			chdir(d)
#define libcs_file_isreadable(fn)	(access(fn, R_OK) == 0)
#define libcs_file_iswritable(fn)	(access(fn, W_OK) == 0)
#define libcs_file_ispresent(fn)	(access(fn, F_OK) == 0)
#endif

#if defined(IRIX) || defined(SOLARIS) || defined(OSF1)
#ifndef HAVE_TIME_R
#define HAVE_TIME_R
#endif
#endif
#if defined(SOLARIS) || defined(OSF1) || defined(AIX) || defined (IRIX)
#define BSD_RLIMIT
#include <sys/time.h>
#include <sys/resource.h>
#endif
 
/* Thread-safe variants of localtime and gmtime; stolen from base/file.h */
#ifdef HAVE_TIME_R
#ifdef OSF1 /* grumble */
#define libcs_localtime(curtime, ret) (localtime_r(curtime, ret), ret)
#define libcs_gmtime(curtime, ret) (gmtime_r(curtime, ret), ret)
#else
#define libcs_localtime(curtime, ret) localtime_r(curtime, ret)
#define libcs_gmtime(curtime, ret) gmtime_r(curtime, ret)
#endif
#else
#define libcs_localtime(curtime, ret) localtime(curtime)
#define libcs_gmtime(curtime, ret) gmtime(curtime)
#endif

#ifdef XP_WIN32
/* get error message after a failure of a system call, message must be freed */
LPTSTR libcs_GetErrStr();
void libcs_FreeErrStr(LPTSTR lpMsgBuf);
#endif

/* run a command line program and open a pipe to it,
   write handle set to wrt_fd, shall be closed by parent process,
   return the pid of child process */
#ifdef XP_WIN32
NSAPI_PUBLIC int libcs_pipe2cmd(char *cmd, HANDLE *wrt_fd);
#else
NSAPI_PUBLIC int libcs_pipe2cmd(char *cmd, int *wrt_fd);
#endif

/* closes all of the file descriptors starting
 * with start, except the fds in e[] which is 
 * terminated by a seminal of -1.
 */
void close_all_fds_except(int start, int *e);

#ifdef __cplusplus
};
#endif

/* -------------------------------------------------------------------------- */
/* A dynamic array which can grow as more items appened */
typedef struct _dynamic_buf {
	int size;		/* array size */
	int index;		/* place for next item */
	int delta;		/* amount to increase when overflow */
	void **ary; 		/* an array of pointers to data */
	void (*elm_free)(void *); 	/* free for element */
} dynamic_buf;

dynamic_buf *dynbuf_create(int size, int delta);
void dynbuf_destroy(dynamic_buf *dyn);
int dynbuf_append(dynamic_buf *dyn, void *data);
void *dynbuf_get(dynamic_buf *dyn, int index);
/* -------------------------------------------------------------------------- */
/* create temp file and return the temp file name */
NSAPI_PUBLIC char *cs_tempnam(char *prefix);
/* -------------------------------------------------------------------------- */

#endif /* _LIBCS_CS_H_ */
