/*
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */

#include "robotapi.h"

/*
 *  Extracts the first 256 bytes of the document, and places it in the RD 
 */
NSAPI_PUBLIC int copy_partial_text_into_rd(libcs_pblock *pb, CSFilter *f, CSResource *r)
{
	int value_sz;
	char *attribute = "partial-text";

	/* don't overwrite any previous value */
	if (SOIF_Find(r->rd, attribute))
		return REQ_PROCEED;

	if (r->data->datalen < 1)		/* no data for the document */
		return REQ_PROCEED;

	value_sz = (r->data->datalen > 256 ) ? 256 : r->data->datalen;

	if (CSIO_IS_IN_MEMORY(r->data)) {
		/* document is in memory, so copy into RD */
		SOIF_Insert(r->rd, attribute, r->data->data, value_sz);

	} else if (CSIO_IS_IN_FILE(r->data)) {
		/* it's on disk, so read it into memory, and insert into RD */
		char *v = MALLOC(value_sz+1);	/* the value */

		csio_rewind(r->data);
		if (csio_copy(r->data, v, value_sz) != value_sz) {
			FREE(v);
			return REQ_PROCEED;
		}
		SOIF_Insert(r->rd, attribute, v, value_sz);
		FREE(v);
	}
	return REQ_PROCEED;
}
