#!/usr/bin/perl
#
# Export script to prepare an S1PS 6.2 migration from 3.01b, 3.01c and 3.01csp1
#
# dest will be export_dir/target_intance

$cs_301c_bin = "../plugins/compass/bin"; 
$cs_301b_bin = "../bin/compass/bin"; 
@robotdbs = ("enumerate.db", "enumerate_bak.db", "vid.db", "url-visited.db" );
undef $cs_bin, $version, $prefix;
$exported_ok = 0;

undef $instance, $export_dir;
undef $ds_basedn, $ds_host, $ds_port, $ds_binddn, $ds_bindpw;
while (1) {
    undef $tmp;
    $tmp = shift @ARGV;
    last if (!$tmp); 
    
    usage() if ($tmp eq "--help");
    version() if ($tmp eq "--version");
    if ($tmp eq "-i" or $tmp eq "-I") {
	$instance = shift @ARGV;
	usage() if (!$instance);
    }
    elsif ($tmp eq "-o" or $tmp eq "-O") {
	$export_dir = shift @ARGV;
	usage() if (!$export_dir);
    }
    elsif ($tmp eq "-b") {
	$ds_basedn = shift @ARGV;
	usage() if (!$ds_basedn);
    }
    elsif ($tmp eq "-h") {
	$ds_host = shift @ARGV;
	usage() if (!$ds_host);
    }
    elsif ($tmp eq "-p") {
	$ds_port = shift @ARGV;
	usage() if (!$ds_port);
    }
    elsif ($tmp eq "-D") {
	$ds_binddn = shift @ARGV;
	usage() if (!$ds_binddn);
    }
    elsif ($tmp eq "-w") {
	$ds_bindpw = shift @ARGV;
	usage() if (!$ds_bindpw);
    }
    else {
	usage();
    }
}
if ($ds_bindpw or $ds_binddn or $ds_basedn or $ds_host or $ds_port) {
    #one for all
    usage() if (!$ds_bindpw);
    usage() if (!$ds_binddn);
    usage() if (!$ds_host);
    usage() if (!$ds_port);
    usage() if (!$ds_basedn);
}

#$export_dir = shift @ARGV;
#$instance = shift @ARGV;
 
$hn = `hostname`;
chomp($hn);
if ($^O ne "MSWin32") {
    $dn = `domainname`;
    chomp($dn);
    $mhost = "$hn.$dn";
}
else {
    #not important for Win32
    $mhost = $hn;
}

if (defined $instance) {
    $instance =~ s!/$!!o;
    chdir($instance);
    chdir("..");
}

# Checking OS
if ($^O eq "MSWin32") {
    $cwd = `cd`;
}
else {
    $cwd =`pwd`;
}
chomp($cwd);

undef $ExportDir;
if (defined $export_dir) {
    die "The $export_dir is expected but can't be found" if (! -e $export_dir);
    chdir($export_dir);
    if ($^O eq "MSWin32") {
	$exp = `cd`;
    }
    else {
	$exp =`pwd`;
    }
    chomp($exp);
    if ($exp ne $cwd) { # not the parent of the instance
	$ExportDir = $exp;
    }
}

#now it is in the server root
chdir($cwd);
if (-e "bin/compass") {
    $cs_bin = $cs_301b_bin;
    $version = "301b";  # 301b and 301bsp1 is same for migration
    $prefix = "compass-";
}
else {
    $cs_bin = $cs_301c_bin;
    $prefix = "https-";
    if (-e "plugins/compass/search/admin") {
        $version = "301c";
    }
    else {
        $version = "301csp1";
    }
}

if (defined $instance) {
    chdir($cwd);
    die "The $instance is expected but can't be found" if (! -e $instance);
    $tmp = $instance;
    undef $nick;
    $tmp =~ m/$prefix(\S+)/i and $nick = $1;

    if ((! -e "$instance/config/csid.conf" ) or  (!$nick)) {
	print("Invalid instance\n");
    }
    else {
        export_instance("$prefix$nick", $cwd);
    }
}
else {
    opendir(DIR, $cwd) || die "Cannot open dir $cwd\n";
    @insts = grep(/$prefix/,readdir(DIR));
    chomp(@insts);
    closedir(DIR);
    for ($ndx = 0; $ndx < scalar(@insts) ; $ndx++) {
	chdir($cwd);
        export_instance($insts[$ndx], $cwd);
    }
}
if ($exported_ok < 1) {
    print("No instance has been exported.\n");
    print("Please check whether directories are correct.\n");
}
else {
    print("Number of instance(s) exported: $exported_ok\n");
}

sub copyFile {
    my($src,$dest) = @_;
    my($buf, $n);
    open( SRC, $src ) or warn "copyFile: Can't open SRC($src): $!\n";
    open( DEST, ">$dest" ) or warn "Can't create DEST($dest): $1\n";
    if ($^O eq "MSWin32") {
	binmode SRC;	# if it wasn't so sad...
	binmode DEST;
    }
    while ($n = sysread SRC, $buf, 1024) {
	syswrite DEST, $buf, $n;
    }
    close( SRC );
    close( DEST );
}


sub export_instance {
    my($ServerRoot, $cwd) = @_;
    my($csidfn, $magnusfn, $owner, $port, $shost, $nick, $ddir);

    chdir($ServerRoot);

#check whether is Compass
    $csidfn  = "config/csid.conf";
    return if (! -e "$csidfn");

    print "Exporting instance $ServerRoot...\n";
    if (-e "logs/pid" || -e "logs/robot.pid") {
	print "Please stop the server and the robot first.\n";
	return;
    }
    if (defined $ExportDir) {
        if (! -d "$ExportDir/$ServerRoot") {
	    mkdir("$ExportDir/$ServerRoot", 0644);
	    mkdir("$ExportDir/$ServerRoot/tmp", 0644);
	    mkdir("$ExportDir/$ServerRoot/robot", 0644);
	    mkdir("$ExportDir/$ServerRoot/config", 0644);
        }
    }

    $magnusfn="config/magnus.conf";
    open(CONF_OLD, $magnusfn) or die "magnus.conf missing";
    undef $fname, $owner, $port, $shost, $nick;
    while(<CONF_OLD>) {
	    $owner = $1 if m/^User (\S+)/i;
	    $port = $1 if m/^Port (\d+)/i;
	    $shost = $1 if m/^ServerName (\S+)/i;
	    $nick = $1 if m/^ServerID\W+https-(\S+)/i;
    }
    close(CONF_OLD);
  
    $port = "80" if (!$port);
    $owner = "root" if (!$owner); 

    if (!$ExportDir) {
	$ddir = "tmp";
    }
    else {
	$ddir = "$ExportDir/$ServerRoot/tmp";
    }
    die "The $ddir is expected but can't be found." if (! -e $ddir);
    open(CONF_NEW, ">$ddir/migration60.info") or die "Can't create info file";
    print CONF_NEW "OldVersion=$version\n";
    print CONF_NEW "DoMigrate=1\n";
    #until DSame can handle true multipe instance
    #if ($nick eq $mhost) {
    #	print CONF_NEW "TargetInstanceIsIPS=1\n";
    #}
    #else {
    #    print CONF_NEW "TargetInstanceIsIPS=0\n";
    #}
    print CONF_NEW "OldServerRoot=$cwd\n";
    print CONF_NEW "#NewServerPort=$port\n";
    print CONF_NEW "#NewServerUser=$owner\n";
    if ($mhost =~ $shost) {
	    print CONF_NEW "#NewServerHost=$shost\n";
    }
    else {
	    print CONF_NEW "NewServerHost=$shost\n";
    }
    print CONF_NEW "#NewServerNick=$nick\n";
    print CONF_NEW "#OldCharSet=iso-8859-1\n";
    
    close(CONF_NEW);
    
    print "Exporting database...\n";
   
    my($temp, $dump_cmd, $nr); 
    $temp = "$ddir/migration60.soif";
    $dump_cmd = "$cs_bin/minidba -Z dump > $temp 2>/dev/null";
    if ($^O eq "MSWin32") {
        $dump_cmd =~ s!/!\\!g;
    }
    $nr = system($dump_cmd);
    if ($nr !=0) {
	print "Error($nr)\n";
	return;
	}
    else {
	print "Dump --> $temp OK\n";
    }
   
    if ( -e "config/gv.conf" && -e "config/sie.conf" 
        && -e "../searchmigrate.jar") {
        print "Exporting Interest Profile...\n";
        if ($^O eq "MSWin32") {
            $profile = "java -classpath .;..\\searchmigrate.jar;..\\ldapjdk.jar;..\\bin\\https\\jar\\ldapjdk.jar";
        }
        else {
            $profile = "java -classpath .:../searchmigrate.jar:../ldapjdk.jar:../bin/https/jar/ldapjdk.jar";
        }
        $temp = "$ddir/PKMigrate.ldif";
        $profile = "$profile com.sun.portal.search.rdmgr.PIPMigrate \"$temp\" ";
        if ($ds_host) {
            $profile .= "\"$ds_host\" \"$ds_port\" ";
            $profile .= "\"$ds_binddn\" \"$ds_bindpw\" \"$ds_basedn\"";
        }
        print "$profile\n";
        $nr = system($profile);
        if ($nr !=0) {
            print "Error($nr)\n";
            return;
            }
        else {
            print "Export Interest Profile --> $temp OK\n";
        }
    }

    print "Export Config files...\n";
    # filter config

    if ($version ne "301b") { #301b use verity's filter not compatible
        if (!$ExportDir) {
            copyFile "../plugins/compass/lib/filter/default.cfg", "config/default.cfg";	
            copyFile "../plugins/compass/lib/filter/template.htm", "config/template.htm";
        }
        else {
            $ddir = "$ExportDir/$ServerRoot/config";
            copyFile "../plugins/compass/lib/filter/default.cfg", "$ddir/default.cfg";	
            copyFile "../plugins/compass/lib/filter/template.htm", "$ddir/template.htm";
        }
    }
    
    if ($ExportDir) {
        $ddir = "$ExportDir/$ServerRoot/config";
	system("cp config/*.* $ddir");

        if ($version ne "301b" ) { # too many changes
            print "Export robot files...\n";
            $ddir = "$ExportDir/$ServerRoot/robot";
            system("cp robot/* $ddir");
        }
    }
    
    $exported_ok += 1;   
    return;
}

sub usage {
    print "This script is used to export Compass Server 3.01 data to Sun ONE PS 6.2\n";
    print "Usage: export.pl [-o Export_Directory] [-i Target_Instance] [-h host -p port -D binddn -w passwd -b basedn]\n";
    print "OPTIONS\n";
    print "  -o <directory> where <directory> is the location of export data\n";
    print "     Default is the current directory, which must be the iWS root\n";
    print "  -i <directory> where <directory> is the target instance to be exported\n";
    print " Requirments below are for the directory sever for the Portal Server 6.2\n";
    print " These are the same requirements as for ldapsearch\n";
    print "  -h <host> where <host> is the directory server host\n";
    print "  -p <port> where <port> is the directory server port\n";
    print "  -D <bindn> where <bindn> is the admin dn for the directory server\n";
    print "  -w <passwd> where <passwd> is the admin password\n";
    print "  -b <basedn> where <basedn> is the basedn for search\n";
    print "     Default is all instances under the current directory\n";
    exit(1);
}

sub version {
    print "Name: Sun ONE PS import utility for Compass Server\n";
    print "Version: 6.2\n";
    print "Product: Sun ONE Portal Server\n";
    exit(1);
}

