//
// Do mystical Magical URL completion
//
// if there's a cookie in the local document called 'domain'
// it'll be used to complete 'short' hostnames.
//
// true|false = validateServer(url_string,domain_or_url_string)
//   sets the url_string.value to a FullyQualifiedURL
// 

var saved_url = "";
var saved_host = "";
var saved_port = "";
var saved_proto = "";
var warnStr = "Invalid URL";
if (i18n_warnStr) {
    warnStr = i18n_warnStr;
}

// helper function: string = default_port(string)
//   given a prototype, return the usual port for that type
//   If we've got a 'saved port' from a domain switch, use that.

function default_port(proto) {
    var p;
    if (proto == "https") { 
	p = "443"; 
    } else if (proto == "ftp") {
	p = "21";
    } else if (proto == "gopher") {
	p = "70";
    } else if (proto == "file") {
	p = "";
    } else {
	p = "80";
	if (saved_port) {
	    port = saved_port;
	    restored_port = 1;
	    //   alert('port:' + p);
	}
    }
    return p;
} 

// helper function: string = validatePort(string,string)
//   given a port and optional(?) protocol, validate that the
//   port is a number, within valid UNIX ranges.

function validatePort(port,protocol) {
    port = parseInt(port);
    if (isNaN(port)) {
	if (i18n_portAlert) {
	    alert(i18n_portAlert);
	}
	else {
	    alert('Please enter a numerical value for Port.');
	}
        if (protocol) {
	    port = default_port(protocol);
        } else {
	    port = "";
	}
    } else if ((port < 1) || (port > 65535)) {
	if (i18n_illegalPort_1 && i18n_illegalPort_2) {
	    alert(warnStr + ' - ' + i18n_illegalPort_1 +' (' + port + ')\n' +
		    i18n_illegalPort_2);
	}
	else {
	    alert(warnStr + ' - Illegal Port (' + port + ')\n' +
		    'Port: Use number between 1 and 65535.');
	}
	port = default_port(protocol);
    }
    return port;
}

function compareNumbers(a, b) {
    return a - b;
}

// helper function: string = validatePortList(string)
//   given a comma separated list of ports, validate that each 
//   port is a number, within valid UNIX ranges.
function validatePortList(portlist) {

    if (portlist.length == 0)
	return '';
    bad_port = false;
    portArray = new Array(); 
    ports = portlist.split(',');
port_loop:
    for (var i = 0; i < ports.length; ++i) {
    	port = parseInt(ports[i]);
    	if (isNaN(port) || (port < 1) || (port > 65535)) {
	    bad_port = true;
	    continue;
    	}
    	for (var j = 0; j < portArray.length; ++j) {
    	    if (portArray[j] == port)
		continue port_loop;
    	}
    	portArray[j] = port;
    }
    if (bad_port) {
	if (i18n_badportStr) {
	    alert(i18n_badportStr);
	}
	else {
	    alert('Warning: Ports must be in the range 1 to 65535.');
	}
    }
    return portArray.sort(compareNumbers).join(',');
}

// helper function: toggle_type(popup object)
//   very very form specific...

function toggle_type(popup, urlText) {
    // if it is an URL popup,     
    if (popup.selectedIndex == 0) {
    // changing to URL
    // dumpprops(popup);
    var url = urlText.value;
    if (url.charAt(0) == '*') {
	var i = 1;
	if (url.charAt(1) == '.') { i = 2; }
	if (saved_url) {
	    urlText.value = saved_url;
	}
	else if (saved_host) {
	    urlText.value = saved_host+url.substring(i);
	}
	else {
	    urlText.value = 'www.'+url.substring(i);
	}
    }
} 
validateServer(urlText,popup);
}
// main_function: 
//
function validateServer(item,popup) {
    var restored_port = 0;
    var trimmed = '';

    var i, flag=0; 
    var count = item.value.length;
    if (!popup && item.value.length == 0) {
	if (i18n_needAllParaStr)
	    alert(i18n_needAllParaStr);
	else
	    alert('Please complete all parameters.');
	    
	return false;
    }
    arrayOfStrings = item.value.split(' ');
    if (arrayOfStrings.length >1) { 
	if (i18n_nospaceStr) 
	    alert(warnStr + i18n_nospaceStr + '\n' + item.value);
	else
	    alert(warnStr + '- No Spaces allowed: ' + '\n' + item.value);
	return false;
    }
    
    // We simply will not tolerate backslashes
    regex = /\\/g;
    item.value = item.value.replace(regex,"/");

    if (popup) {
	var a = popup.options;
	if ((a[a.selectedIndex].value == "domain")) {
	    //	    alert('Domain detected. ');
	    saved_url = item.value;
	    //if (item.value.search(/^file:[\/]{2,3}/) != -1) {
		//alert('FILE: protocol does not support domains');
		//popup.options.selectedIndex = 0;    // reset to URL
		//return false;
	    //}
	    // Strip off the protocol for domain specifications
	    var tmp = item.value.split(':');
	    if (tmp.length > 1) {
		saved_proto = tmp[0];
		item.value = item.value.substring(tmp[0].length+3);
	    }
	    // Strip off the port for domain specifications
	    tmp = item.value.split(':');
	    if (tmp.length > 1) {
		item.value = tmp[0];
		var s = item.value.substring(tmp[0].length+1);
		if (s.indexOf("/") == (s.length-1)) {
		    //	alert('Need to trim trailing slash from '+ s);
		    saved_port = s.substring(0,s.length-1);
		} else {
		    saved_port = s;
		}
	       
	    }
	    if ((item.value.indexOf("*.") == 0) ||
		(item.value.indexOf("*") == 0)) {
		//		alert('* in domain needs to be swapped out');
		//		tmp = item.value.split('*.');
		//		alert(tmp[1]);
	    } else {
		// replace host (machine-name) with *
		tmp = item.value.split('.');
		if (tmp.length > 1) {
		    saved_host = tmp[0];
		    item.value = '*';
		    for (var i=1; i < tmp.length; i++) {
			item.value += "." + tmp[i] ;
		    }
		}
	    }
	    return true;
	} else {    // switching to URL
	    if ((item.value.indexOf("*") == 0)) {
		// alert('* in URL string being replaced');
		if (item.value.indexOf("*.")==0) {
		    tmp = item.value.split('*');
		    var skip = tmp[0].length+2;
		} else {
		    tmp = item.value.split('*');
		    var skip = tmp[0].length+1;
		}
		if (saved_host) {
		    item.value = tmp[0] + saved_host + "." +
			         item.value.substring(skip);
		} else {
		    popup.options.selectedIndex = 1;    // domain
		    // item.value = tmp[0] + "www." + item.value.substring(skip);
		}
	    }
	}
    }

    // No POPUP menu in use here.  POPUP only on NewSite
    // so the basic URL expansion starts here:

    var stringToSplit = item.value;

    // Just return if it's completely blank
    if (stringToSplit == '') { 
	return true;
    }
    // Does the URL have spaces? That's bad.
    arrayOfStrings = stringToSplit.split(' ');
    if (arrayOfStrings.length >1) { 
	if (i18n_nospaceStr) 
	    alert(warnStr + i18n_nospaceStr + '\n' + stringToSplit);
	else
	    alert(warnStr + '- No Spaces allowed: ' + '\n' + stringToSplit);
	return false;
    }
    // is there a wildcard for a domain? 
    if (stringToSplit.indexOf('*')>=0) {
	domain_flag = 1;
	var s = stringToSplit;
	// strip up to protocol 
	if (s.indexOf('://')>=0) {
	    s = s.substring(s.indexOf('://')+3);
	}
	// strip port and beyond
	if (s.indexOf(':')>=0) {
	    s = s.substring(0,s.indexOf(':'));
	}
	// strip up to first '/'
	if (s.indexOf('/')>=0) {
	    s = s.substring(0,s.indexOf('/'));
	}
	if (s.indexOf('*')>=0) {
	    s = s.substring(s.indexOf('*'));
	}
	item.value = s;
	if (popup) {
	  popup.options.selectedIndex =1; // domain
	}
	return true;
    }

    // Do some FILE:// completion unless we're in the simulator.
    // Leading ., ~, / or c: imply file:
    if (stringToSplit.search( /^(([\.~\/])|([a-zA-Z][:|]))/i ) != -1) {
	if (document.simulator)      // might be set by calling page
	    return true;
	if (stringToSplit.charAt(0) == '/')
	    stringToSplit = "file:" + stringToSplit;
	else
	    stringToSplit = "file:/" + stringToSplit.replace(/^([a-zA-Z])([:|])/, "$1:");
	//item.value = stringToSplit;
    }

    matches = stringToSplit.match(/^((\w{2,}):)?((\/\/)?([^\/:]*))(:(\d*))?(.*)/);

    var protocol = matches[2].toLowerCase();
    var host = matches[5].toLowerCase();
    var port = matches[7];
    var path = matches[8];

    //alert('pr='+protocol+' h='+host + ' po='+port+' pa='+path);

    // protocol
    if (protocol == '') {
	protocol = saved_proto ? saved_proto : 'http';
    } else {
	if (protocol == "http" 
		|| protocol == "file" 
		|| protocol == "ftp" 
		|| protocol == "gopher" 
		|| protocol == "https"
		// || protocol == "news"
		// || protocol == "snews"
	   ) {
	    // Yup. we be fine
	} else {
	    if (i18n_invalidProtoStr)
		alert(warnStr + i18n_invalidProtoStr + '\n' + protocol);
	    else
		alert(warnStr + '- Protocol not supported: ' + '\n' + protocol);
	    //item.value = '';
	    return false;
	}
    }

    if ( protocol != "file" && host == '') {
	alert(warnStr);
	return false;
    }

    if (protocol == "file" || port == '')
	port = default_port(protocol);
    else
	port = validatePort(port, protocol);

    // normalize host
    /*
    if (protocol == 'file' && host == 'localhost')
	host = '';
    if ( !(protocol == "file" && host == '') && host.indexOf('.') == -1) {
	*/
    if (protocol == 'file' && host == '')
	host = 'localhost';
    // lousy windoze file protocol doesn't use
    // proper hostnames - don't touch them
    if (protocol != 'file' && host != 'localhost' && host.indexOf('.') == -1) {
	// it's the local document's job to set this cookie
	// if not, it returns '' so no harm done.
	if (i18n_needFullHostStr)
	    alert( i18n_needFullHostStr);
	else
	    alert( "Please give full host name");
	return false;
    }

    // normalize path
    if (path.charAt(0) != '/') path = '/' + path;
    // NT doesn't like c: - wants c:/
    if (protocol == 'file' && path.match(/^\/[a-z]:$/i))
	path += "/";

    // reconstruct
    item.value = protocol + ":";
    if (host != '') {
	item.value += "//" + host;
	if (port != '')
	    item.value += ":" + port;
    }
    item.value += path;

    return true;
}

