<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes"/>

<xsl:template match="/">
<html>
<head>
</head>
<body>
<table bgcolor="#ffffff" cellpadding="2" border="0" cellspacing="0">
<xsl:for-each select="market-data/quote-set/quote">
	<tr> 
		<td bgcolor="#ffffff" colspan="2" width="40%" nowrap="yes">
					<font color="#000000">
					<b><xsl:value-of select="./@name"/></b>
					</font>
		</td>
		<td bgcolor="#ffffff" width="20%" fgcolor="#000000"><br /></td>
		<td width="40%" align="right" colspan="2" bgcolor="#ffffff" ><font color="#000000">
			<xsl:value-of select="./@exchange-code"/>, <xsl:value-of select="./@hyperfeed-time"/></font>
		</td>
	</tr>

	<tr>
		<td width="40%"> Last </td>
		<td nowrap="yes" align="right"><b><xsl:value-of select="./@last"/></b></td>
		<td width="15%"><br /></td>
		<td width="40%">Open</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@open"/></td>
	</tr>

	<tr>
		<td width="40%">Change</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@change"/></td>
		<td width="10"><br /></td>
		<td width="40%">Previous Close</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@close"/></td>
	</tr>

	<tr>
		<td width="40%">% Change</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@percent-change"/></td>
		<td width="10"><br /></td>
		<td width="40%">Bid</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@bid"/></td>
	</tr>

	<tr>
		<td width="40%">Volume</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@volume"/></td>
		<td width="10"><br /></td>
		<td width="40%">Ask</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@ask"/></td>
		</tr>

	<tr>
		<td width="40%">Day's High</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high"/></td>
		<td width="10"><br /></td>
		<td width="40%">52 Week High</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@high-52-week"/></td>
	</tr>

	<tr>
		<td width="40%">Day's Low</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low"/></td>
		<td width="10"><br /></td>
		<td width="40%">52 Week Low</td>
		<td nowrap="yes" align="right"><xsl:value-of select="./@low-52-week"/></td>
	</tr>
</xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
