<%-- createchannelcontent.jsp --%>
<%@ page import="com.sun.portal.providers.containers.jsp.single.JSPSingleContainerProvider,
                 com.sun.portal.providers.containers.jsp.table.JSPTableContainerProvider,
                 com.sun.portal.providers.context.*,
                 java.util.Map,
                 java.util.Iterator,
                 java.util.Collections,
                 java.util.List"
%>

<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>

<%
// Get the container's context.
JSPSingleContainerProvider scp = (JSPSingleContainerProvider)pageContext.getAttribute("JSPProvider");
String container = (String)pageContext.getAttribute("container", pageContext.REQUEST_SCOPE);
String parentContainer = scp.getProviderContext().getDefaultChannelName();
String parentContainerProvider = scp.getProviderContext().getProviderName(parentContainer);
JSPTableContainerProvider tcp = (JSPTableContainerProvider)scp.getContainerProviderContext().getProvider(request, scp.getName(), container);
String fontFace1 = (String)pageContext.getAttribute("fontFace1", PageContext.REQUEST_SCOPE);
boolean hasAvailableProviders =false;
boolean hasUserDefinedChannels =false;

// Check is context has channel to create channels.
if (tcp.getContainerProviderContext().existsChannel("JSPCreateChannelContainer")) {

	// Check is container has some providers available that backend creating channels.
	if (tcp.getProviderContext().existsCollectionProperty("JSPCreateChannelContainer","availableProviders")) {
		Map apMap =tcp.getProviderContext().getCollectionProperty("JSPCreateChannelContainer","availableProviders");
  	if (apMap !=null && !apMap.isEmpty()) {
			hasAvailableProviders =true;
		}
	}

	// Check is container has any user defined channels.
	if (tcp.getProviderContext().existsCollectionProperty("JSPCreateChannelContainer","userDefinedChannels")) {
		Map ucdMap =tcp.getContainerProviderContext().getCollectionProperty("JSPCreateChannelContainer","userDefinedChannels");
  	if (ucdMap !=null && !ucdMap.isEmpty()) {
			hasUserDefinedChannels =true;
		}
	}
}
%>
<dt:obtainContainer container="$JSPProvider">
  <dtpc:providerContext>
<%
// Depending on having some backend providers to create channels show link to create channels from them and
// depending on having any user defined channels already show the link that gives user ability to delete them.
if (hasAvailableProviders || hasUserDefinedChannels) {
	%>
	<p>
	<div align="right">
	User Defined Channels:&nbsp;&nbsp;
	<%
	if (hasAvailableProviders) {
		%>
		<a href="<dtpc:getDesktopURL/>?provider=JSPCreateChannelContainer&action=edit&container=<%=container%>&type=create">Create a New Channel</a>
		<%
	}
	if (hasUserDefinedChannels) {
		%>
		&nbsp;|&nbsp;
		<a href="<dtpc:getDesktopURL/>?provider=JSPCreateChannelContainer&action=edit&container=<%=container%>&type=delete">Delete a Channel</a>
		<%
	}
	%>
	&nbsp;&nbsp;</div>
	<%
}
%>
  </dtpc:providerContext>
</dt:obtainContainer>
