<%--
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>

<%-- clientconfig.jsp --%>

<%@ page session="false" %>

<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/desktopContainerProviderContext.tld" prefix="dtcpc" %>
<%@ taglib uri="/tld/desktopTheme.tld" prefix="dttheme" %>
<%@ taglib uri="/tld/jx.tld" prefix="jx" %>

<%-- Some preparation specific to generate client configuration --%>
<%@ include file="clientconfigSetup.jsp" %>

<%-- The presentation of client configuration edit page --%>

<dt:obtainContainer container="$JSPProvider">

<jx:choose>
  <jx:when test="$pc == 'FrameTabContainer'">
    <jsp:include page="framePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTabContainerProvider'">
    <jsp:include page="tabPreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTableContainerProvider'">
    <jsp:include page="tablePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPSingleContainerProvider'">
    <jsp:include page="singlePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:otherwise>
    <jsp:include page="defaultHeader.jsp" flush="true"/>
  </jx:otherwise>
</jx:choose>

<%
    Map map = new HashMap();
    map.put("action", "edit");
    map.put("provider", scp.getName());
    pageContext.setAttribute("desktop_ccmap", map);
%>
<script language="JavaScript">

  function openContentPage(form) {
    var selectedValue = "";
    var selectedText = "";
    for (var i = 0; i < form.client.length; i++) {
      if (form.client.options[i].selected) {
        selectedValue = form.client.options[i].value;
      }
    }

	var url = "<dtpc:getDesktopURL querymap="$desktop_ccmap"/>";
	if (selectedValue != "") {
        <%
          Map map1 = new HashMap();
          map1.put("action", "edit");
          map1.put("provider", "WirelessJSPContentChannel");
          pageContext.setAttribute("desktop_cmap", map1);
        %>
        url = "<dtpc:getDesktopURL querymap="$desktop_cmap"/>" + "&client=" + selectedValue;
	}
    location = url;
  }

  function openLayoutPage(form) {
    var selectedValue = "";
    var selectedText = "";
    for (var i = 0; i < form.client.length; i++) {
      if (form.client.options[i].selected) {
        selectedValue = form.client.options[i].value;
      }
    }

	var url = "<dtpc:getDesktopURL querymap="$desktop_ccmap"/>";
	if (selectedValue != "") {
        <%
          Map map2 = new HashMap();
          map2.put("action", "edit");
          map2.put("provider", "WirelessJSPLayoutChannel");
          pageContext.setAttribute("desktop_lmap", map2);
        %>
        url = "<dtpc:getDesktopURL querymap="$desktop_lmap"/>" + "&client=" + selectedValue;
	}
    location = url;
  }
</script>

<center>
  <form name="clientConfigurationForm" action="<dtpc:getDesktopURL/>" method=post enctype="application/x-www-form-urlencoded">
    <input type="hidden" name="action" size=-1 value="process">
    <input type="hidden" name="provider" size=-1 value="<dt:getName/>">
    <table border="1" cellpadding="0" cellspacing="0" width="100%">
      <tr>
        <td align="center">
          <center>
            <p>
            <table border="0" cellpadding="2" cellspacing="0" width="100%">
              <tr>
                <td valign="top" bgcolor=<dttheme:getAttribute name="titleBarColor"/>>
                  <font size="+2" color=<dttheme:getAttribute name="bgColor"/> face=<dttheme:getAttribute name="fontFace"/>">
                    <b>Mobile Devices</b>
                  </font>
                </td>
              </tr>
              <tr>
                <td bgcolor=<dttheme:getAttribute name="borderColor"/>>
                  <font size="+0" face=<dttheme:getAttribute name="fontFace"/>>
                    Select a mobile device and change the content or layout.  To remove a mobile device from your list, choose remove.
                  </font>
                </td>
              </tr>
              <tr>
                <td>
                  <font size="+0" face=<dttheme:getAttribute name="fontFace"/>>
                    <b>You currently use these mobile devices:</b>
                  </font>
                </td>
              </tr>
              <tr>
                <td valign="top">
                  <select name="client" size=<%=clientSize%>>
                    <jx:forEach var="clientType" items="$selectedClients">
					    <%   
						  String clientType = (String)((Map.Entry)pageContext.getAttribute("clientType")).getKey();
						  String clientName = null;
						  try{
						    clientName = bundle.getString(clientType);
						  }catch(Exception e){
						    clientName = clientType;
						  }
                        %>
                        <option value="<%=clientType%>"><%=clientName%></option>
                    </jx:forEach>
                  </select>
                </td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
            </table> 

          </center>
        </td>
      </tr>
    </table>
    <br>
    <font size=+0 face=<dttheme:getAttribute name="fontFace"/>>
      <input type="button" onclick="openContentPage(this.form)" value="Edit Content" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
      <input type="button" onclick="openLayoutPage(this.form)" value="Edit Layout" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
      <input type="submit" value="Remove" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
      <input type="button" onclick="parent.location='<dtpc:getDesktopURL/>'" value="Finished" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
    </font>
    <br>
  </form>
  <p>
</center>

<jx:choose>
  <jx:when test="$pc == 'FrameTabContainer'">
    <jsp:include page="framePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTabContainerProvider'">
    <jsp:include page="tabPreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTableContainerProvider'">
    <jsp:include page="tablePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPSingleContainerProvider'">
    <jsp:include page="singlePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:otherwise>
    <jsp:include page="defaultMenubar.jsp" flush="true"/>
  </jx:otherwise>
</jx:choose>

<%@ include file="footer.html" %>

</dt:obtainContainer>
