
package com.sun.portal.sample.j2ee.poll.ejb;

import javax.ejb.*;
import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.ArrayList;

import java.util.Iterator;

import javax.naming.Context;
import javax.naming.InitialContext;
import java.sql.Statement;
import java.sql.Connection;
import java.sql.ResultSet;
import javax.sql.DataSource;


/**
 * Created Apr 10, 2003 5:45:15 PM
 * Code generated by the Sun ONE Studio EJB Builder
 * @author ms109488
 */


public class PollBean implements javax.ejb.SessionBean {
    private javax.ejb.SessionContext context;
    
    
    /**
     * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
     */
    public void setSessionContext(javax.ejb.SessionContext aContext) {
        context=aContext;
    }
    
    
    /**
     * @see javax.ejb.SessionBean#ejbActivate()
     */
    public void ejbActivate() {
        System.out.println("ejbActivate() on obj " + this);
    }
    
    
    /**
     * @see javax.ejb.SessionBean#ejbPassivate()
     */
    public void ejbPassivate() {
        System.out.println("ejbPassivate() on obj " + this);
    }
    
    
    /**
     * @see javax.ejb.SessionBean#ejbRemove()
     */
    public void ejbRemove() {
        System.out.println("ejbRemove() on obj " + this);
    }
    
    
    /**
     * See section 7.10.3 of the EJB 2.0 specification
     */
    public void ejbCreate() {
        System.out.println("ejbCreate() on obj " + this);
    }
    
    public List getResults(java.lang.String pollName) {
        List results = new ArrayList();
        StringBuffer query = new StringBuffer();
        DataSource ds = getDataSource();
        long total     = 0;
        if(ds != null) {
            try {
                Connection conn = ds.getConnection();
                Statement  stmt = conn.createStatement();
                ResultSet rs    = null;
                
                query.append("SELECT C.CHOICE, V.COUNT FROM POLL.QUESTIONS Q, POLL.CHOICES C, POLL.VOTE V")
		.append(" WHERE Q.POLLNAME='")
		.append(pollName)
                .append("'")
		.append(" AND Q.ID  = V.QID")
		.append(" AND V.CID = C.ID ORDER BY V.COUNT DESC");
                
                rs = stmt.executeQuery(query.toString());
                while(rs.next()) {
                    Object [] vote = new Object [3];
                    vote[0]   = rs.getString("CHOICE");
                    vote[2]   = new Long(rs.getInt("COUNT"));
                    total += ((Long)vote[2]).longValue();
                    results.add(vote);
                }
                
                stmt.close();
                conn.close();
            } catch (Exception ex) {
                System.out.println("PollBean.getChoices : can not close the database statment and connection " + ex.toString());
            }
        }
        for (int i = 0; i < results.size(); i++ ) {
            Object [] vote = (Object [])results.get(i);
            long count = ((Long)vote[2]).longValue();
            vote[1]  = new Long(Math.round((float)count/total * 100));
        }
        return results;
    }
    
    public List vote(java.lang.String pollName, java.lang.String choice) {
      
        Map results = new HashMap();;
        StringBuffer query = new StringBuffer();
        DataSource ds = getDataSource();
        if(ds != null) {
            try {
                Connection conn = ds.getConnection();
                Statement  stmt = conn.createStatement();
                
                query.append("UPDATE POLL.VOTE SET COUNT=COUNT+1 ")
		.append(" WHERE QID=(SELECT ID FROM POLL.QUESTIONS WHERE POLLNAME='")
		.append(pollName)
                .append("') AND CID=(SELECT ID FROM POLL.CHOICES WHERE CHOICE='")
		.append(choice)
		.append("')");
                
                stmt.executeUpdate(query.toString());
                
                stmt.close();
                conn.close();
            } catch (Exception ex) {
                System.out.println("PollBean.getChoices : can not close the database statment and connection " + ex.toString());
            }
        }
        return getResults(pollName);
    }
    
    public List changeVote(java.lang.String pollName, java.lang.String oldChoice, java.lang.String newChoice) {
        StringBuffer query = new StringBuffer();
        DataSource ds = getDataSource();
        if(ds != null) {
            try {
                Connection conn = ds.getConnection();
		conn.setAutoCommit(false);
                Statement  stmt = conn.createStatement();
                
                query.append("UPDATE POLL.VOTE SET COUNT=COUNT-1 ")
		.append(" WHERE QID=(SELECT ID FROM POLL.QUESTIONS WHERE POLLNAME='")
		.append(pollName)
                .append("')")
		.append(" AND CID=(SELECT ID FROM POLL.CHOICES WHERE CHOICE='")
		.append(oldChoice)
		.append("')");
                
                stmt.executeUpdate(query.toString());
                
                query.delete(0,query.length());
                query.append("UPDATE POLL.VOTE SET COUNT=COUNT+1 ")
		.append(" WHERE QID=(SELECT ID FROM POLL.QUESTIONS WHERE POLLNAME='")
		.append(pollName)
                .append("')")
		.append(" AND CID=(SELECT ID FROM POLL.CHOICES WHERE CHOICE='")
		.append(newChoice)
		.append("')");
                
                stmt.executeUpdate(query.toString());

		conn.commit();
                
                stmt.close();
                conn.close();
            } catch (Exception ex) {
                System.out.println("PollBean.getChoices : can not close the database statment and connection " + ex.toString());
            }
        }
	return getResults(pollName);
        
    }
    
    public List getChoices(java.lang.String pollName) {
        List choices = new ArrayList();;
        StringBuffer query = new StringBuffer();
        DataSource ds = getDataSource();
        if(ds != null) {
            try {
                Connection conn = ds.getConnection();
                Statement  stmt = conn.createStatement();
                ResultSet rs    = null;
                
                query.append(" SELECT C.CHOICE FROM POLL.QUESTIONS Q, POLL.CHOICES C, POLL.VOTE V ")
		.append(" WHERE Q.POLLNAME='")
		.append(pollName)
                .append("'")
		.append(" AND Q.ID  = V.QID")
		.append(" AND V.CID = C.ID");
                
                rs = stmt.executeQuery(query.toString());
                
                while(rs.next()) {
                    choices.add(rs.getString("CHOICE"));
                }
                
                stmt.close();
                conn.close();
            } catch (Exception ex) {
                System.out.println("PollBean.getChoices : can not close the database statment and connection " + ex.toString());
            }
        }
       
    return choices;
    }
    
    public java.lang.String getQuestion(java.lang.String pollName) {
        String question = null;
        StringBuffer query = new StringBuffer();
        DataSource ds = getDataSource();
        if(ds != null) {
            try {
                Connection conn = ds.getConnection();
                Statement  stmt = conn.createStatement();
                ResultSet rs    = null;
                
                query.append(" SELECT QUESTION FROM POLL.QUESTIONS WHERE POLLNAME = '")
                .append(pollName)
                .append("'");
                
                rs = stmt.executeQuery(query.toString());
                
                if(rs.next()) {
                    question = rs.getString("QUESTION");
                }
                
                stmt.close();
                conn.close();
            } catch (Exception ex) {
                System.out.println("PollBean.getQuestion : can not close the database statment and connection " + ex.toString());
            }
        }
        return question;
    }
    
    private Context getContext() {
        Context c = null;
        try {
            c = new InitialContext();
        } catch (Exception ex) {
            System.out.println("PollBean: can't get initial context");
        }
        return c;
    }
    
    private DataSource getDataSource() {
        String dsName = "jdbc/poll";
        Context c = getContext();
        DataSource ds = null;
        if(c != null) {
            try {
                ds  = (javax.sql.DataSource)c.lookup(dsName);
            } catch (Exception e) {
                System.out.println("PollBean: Can not interact with the database : " + e.toString());
            }
        }
        return ds;
    }
    
}
