package com.sun.portal.sample.j2ee.connector.provider;

import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.jsp.JSPProvider;
import com.sun.portal.providers.ProviderException;

import com.sun.portal.sample.j2ee.connector.comet.*;
import javax.resource.cci.*;
import javax.resource.ResourceException;
import javax.naming.InitialContext;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConnectorProvider extends JSPProvider {

    public StringBuffer getContent(HttpServletRequest req, HttpServletResponse res)
                        throws ProviderException {

	String name = (String)req.getParameter("NAME");
	if ( name != null && name.length() != 0 ) {
		execute(name);
	}

        return super.getContent(req, res);

    }

    private void execute(String name) throws ProviderException {
	ProviderContext ctx = getProviderContext();
        boolean ok=false;
        ConnectionFactory cf=null;
        String message = null;

        try {
            javax.naming.Context nc=new InitialContext();
            cf=(ConnectionFactory)nc.lookup("java:comp/env/eis/Comet");
        } catch(Exception e){
            throw new ProviderException(e.getMessage());
        }
	try {

        RecordFactory rf=cf.getRecordFactory();
        MappedRecord input=rf.createMappedRecord("INPUT");
        MappedRecord output=rf.createMappedRecord("OUTPUT");
        input.put("NAME", getFString(10, name));
        output.put("WELCOME_MESSAGE","");

        Connection con=cf.getConnection();

        Interaction inter=con.createInteraction();

        CometInteractionSpec spec=new CometInteractionSpec();
        ok=inter.execute(spec,input,output);
        message=(String)output.get("WELCOME_MESSAGE");
        con.close();

        if ( ok ) {
          ctx.setSessionProperty( "message", message);
        } else {
          ctx.setSessionProperty( "message", "Failed to Execute");
        }
	} catch (ResourceException re) {
	  throw new ProviderException("ConnectionProvider.execute():ResourceException caught", re);
	}

    }

    private String getFString(int length,String val){
        int diff=length-val.length();
        if(diff>0){
           byte[] tmp=new byte[diff];
           for(int i=0;i<diff;i++)
              tmp[i]=(byte)' ';
           return (val+new String(tmp));
        } else{
            if(diff<0)
               return (val.substring(0,length));
            else
               return (val);
        }
    }
}

