#! /usr/perl5/bin/perl -w
#
# ident   "@(#)Error.pm 1.1     03/11/20 SMI"
# 
# Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# This file listed the error code defined for scsnapshot tool.
#

package ScSnapshot::Error;
use strict;

#
# Constructor.
#
sub new 
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self  = {};

    # Error codes
    $self->{CODE} = { OK =>      0, # Success indicator
		      ENOENT =>  2, # No Such file or directory
		      EIO =>     5, # Generic I/O errors
		      ENOEXEC => 8, # Invalid image file format : Parsing error
		      EACCES => 13, # Permission Denied
		      EINVAL => 22  # Invalid Argument
		    };

    bless ($self, $class);
    return $self;
}

#
# Returns the code matching the passed code name.
# Arguments:
#   1) The name of the exit code to retrieve. If the passed name does not
#      match a defined error the program will die with a internal error
#      message.
# 
sub getCode {

  my $self = shift;
  my $name = shift;

  if (!defined($name) || !defined($self->{CODE}->{$name})) {
    die("FATAL INTERNAL ERROR: $name is not a valid exit code name\n");
  }

  return $self->{CODE}->{$name};
}

# Return success for module load
1;
