# Gate Specific Code -- BEGIN
#
# Copyright 1998-2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident  "@(#)dns_mon_check.ksh 1.7     03/10/17 SMI"
# Gate Specific Code -- END
#!/bin/ksh
# Sun Cluster Data Services Builder template version 1.0
#
# Monitor check  Method for DNS.
#
# This method is called by the RGM whenever there is a failover to be performed
# by the fault monitor. This method is called to ensure that the new node that
# dataservice will vbe failing over to is actually healthy enough to host the  
# dataservice. This method makes a call to the validate method that has been
# registered in order to achieve this.

###############################################################################
# Parse program arguments.
#
function parse_args # [args ...]
{
	typeset opt

	while getopts 'R:G:T:' opt
	do
		case "$opt" in

		R)
		# Name of the DNS resource.
		RESOURCE_NAME=$OPTARG
		;;

		G)
		# Name of the resource group in which the resource is
		# configured.
		RESOURCEGROUP_NAME=$OPTARG
		;;

		T)
		# Name of the resource type.
		RESOURCETYPE_NAME=$OPTARG
		;;

		*)
		logger -p ${SYSLOG_FACILITY}.err -t \
		[$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME] \
		"ERROR: Option $OPTARG unknown"
		exit 1
		;;

		esac
	done

}

###############################################################################
# MAIN
##############################################################################

export PATH=/bin:/usr/bin:/usr/cluster/bin:/usr/sbin:/usr/proc/bin:$PATH

# Obtain the syslog facility to use. This will be used to log the messages.
SYSLOG_FACILITY=`scha_cluster_get -O SYSLOG_FACILITY`

# Parse the arguments that have been passed to this method
parse_args "$@"

PMF_TAG=$RESOURCEGROUP_NAME,$RESOURCE_NAME,0.svc
SYSLOG_TAG=$RESOURCETYPE_NAME,$RESOURCEGROUP_NAME,$RESOURCE_NAME

# We need to know the full path for the validate method which resides
# in the directory <RT_BASEDIR>. Get this from the RT_BASEDIR property of the
# resource type.
RT_BASEDIR=`scha_resource_get -O RT_BASEDIR -R $RESOURCE_NAME \
	-G $RESOURCEGROUP_NAME`

# Obtain the name of the validate method for this resource.
VALIDATE_METHOD=`scha_resource_get -O VALIDATE \
	-R $RESOURCE_NAME -G $RESOURCEGROUP_NAME`

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

# Call the validate method so that the dataservice can be failed over 
# successfully to the new node.
$RT_BASEDIR/$VALIDATE_METHOD -R $RESOURCE_NAME -G $RESOURCEGROUP_NAME \
	-T $RESOURCETYPE_NAME

# User added code -- BEGIN vvvvvvvvvvvvvvv
# User added code -- END   ^^^^^^^^^^^^^^^

# Log a message indicating that monitor check was successful.
if [ $? -eq 0 ]; then
	logger -p ${SYSLOG_FACILITY}.info \
		-t [$SYSLOG_TAG] \
		"${ARGV0} Monitor check for DNS successful."
	exit 0
else
	logger -p ${SYSLOG_FACILITY}.err -t [$SYSLOG_TAG] \
		"${ARGV0} Monitor check for DNS not successful."
	exit 1
fi
