/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.SCProperties;
import com.sun.cluster.sccheck.Utils;
import com.sun.cluster.sccheck.WrapperException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ExplorerWrapper
implements Globals {
    private ProgressListener progressListener = null;
    private String originID = null;
    private Logger logger = Logger.getLogger();
    private SCProperties props = SCProperties.getSCProperties();

    public ExplorerWrapper(ProgressListener progressListener, String string) {
        this.progressListener = progressListener;
        this.originID = string;
        this.originID = this.originID == null ? "" : this.originID + ": ";
    }

    public String runExplorer() throws WrapperException {
        this.logger.trace("ExplWrapper.runExplorer() -- ENTER-- ");
        String string = null;
        boolean bl = SCProperties.booleanFromProps("EXPLORER_SKIP", false, this.props);
        this.logger.info("ExplWrapper.runExplorer() explorer.skip: " + bl);
        if (!bl) {
            this.execExplorer();
            string = this.getExplorerGzipName();
        } else {
            try {
                this.logger.trace("ExplWrapper.runExplorer() skip requesting fnname");
                string = this.getExplorerGzipName();
                this.logger.info("ExplWrapper.runExplorer() fname for skip: " + string);
                this.logger.trace("ExplWrapper.runExplorer() skip requesting dirname");
                String string2 = this.getExplorerDirname();
                this.logger.info("ExplWrapper.runExplorer() dname for skip: " + string2);
                if (!string.startsWith(string2)) {
                    this.logger.trace("ExplWrapper.runExplorer() dname/fname mismatch; forcing explorer run");
                    throw new WrapperException();
                }
                Object[] objectArray = new Object[]{this.originID};
                String string3 = I18n.getLocalized("usingExistingExplorerResults", objectArray);
                this.progressListener.postProgress(0, string3);
            }
            catch (WrapperException wrapperException) {
                this.logger.info("ExplWrapper.runExplorer() valid explorer results (both packed & unpacked) not found: forcing explorer run");
                this.execExplorer();
                string = this.getExplorerGzipName();
            }
        }
        this.logger.trace("ExplWrapper.runExplorer() -- EXIT--: " + string);
        return string;
    }

    public String getExplorerDir() throws WrapperException {
        this.logger.trace("ExplWrapper.getExplorerDir() -- ENTER--");
        String string = this.getExplorerDirname();
        this.logger.info("ExplWrapper.getExplorerDir() -- EXIT--: " + string);
        return string;
    }

    private void execExplorer() throws WrapperException {
        this.logger.trace("ExplWrapper.execExplorer() -- ENTER-- ");
        int n = 0;
        String string = null;
        try {
            String[] stringArray = new String[]{"/usr/cluster/lib/sccheck/explorer_wrapper", "run"};
            this.logger.info("ExplWrapper.execExplorer() cmdArray: " + Utils.dumpStringArray(stringArray));
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            InputStream inputStream2 = process.getErrorStream();
            InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2);
            BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
            Object[] objectArray = null;
            String string2 = "";
            this.logger.trace("ExplWrapper.execExplorer() starting read stdout/stderr");
            while ((string = bufferedReader.readLine()) != null) {
                this.logger.info("ExplWrapper.execExplorer() stdout: " + string);
                objectArray = new Object[]{this.originID, string};
                string2 = I18n.getLocalized("execExplorer.progress", objectArray);
                this.progressListener.postProgress(2, string2);
                if (!bufferedReader2.ready()) continue;
                string = bufferedReader2.readLine();
                if (string != null) {
                    this.logger.info("ExplWrapper.execExplorer() mid stderr: " + string);
                    string2 = I18n.getLocalized("stderr");
                    objectArray = new Object[]{this.originID, string2, string};
                    string2 = I18n.getLocalized("execExplorer.progress.err", objectArray);
                    this.progressListener.postProgress(2, string2);
                    continue;
                }
                this.logger.info("ExplWrapper.execExplorer() mid stderr: got null");
            }
            this.logger.trace("ExplWrapper.execExplorer() end reading stdout/stderr");
            this.logger.trace("ExplWrapper.execExplorer() starting final read stderr");
            while ((string = bufferedReader2.readLine()) != null) {
                this.logger.info("ExplWrapper.execExplorer() final stderr: " + string);
                string2 = I18n.getLocalized("stderr");
                objectArray = new Object[]{this.originID, string2, string};
                string2 = I18n.getLocalized("execExplorer.progress.err", objectArray);
                this.progressListener.postProgress(2, string2);
            }
            this.logger.trace("ExplWrapper.execExplorer() end final read stderr");
            n = process.waitFor();
            this.logger.info("ExplWrapper.execExplorer() got return code " + n);
            if (n != 0) {
                this.logger.error("ExplWrapper.execExplorer() throwing WrapperException: " + n);
                objectArray = new Object[]{new String("" + n)};
                string2 = I18n.getLocalized("explorerExitCode", objectArray);
                throw new WrapperException(string2);
            }
        }
        catch (IOException iOException) {
            this.logger.error("ExplWrapper.execExplorer(): IOException ioex: " + iOException.getMessage());
            throw new WrapperException(iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            this.logger.error("ExplWrapper.execExplorer(): InterruptedException iex: " + interruptedException.getMessage());
            throw new WrapperException(interruptedException.getMessage());
        }
        this.logger.trace("ExplWrapper.execExplorer() -- EXIT-- ");
    }

    private String getExplorerGzipName() throws WrapperException {
        String string = null;
        String[] stringArray = new String[]{"/usr/cluster/lib/sccheck/explorer_wrapper", "gzipname"};
        try {
            string = Utils.runCmdOneString(stringArray);
        }
        catch (WrapperException wrapperException) {
            Object[] objectArray = new Object[]{wrapperException.getMessage()};
            String string2 = I18n.getLocalized("explorerResultsDirectoryNameNotFound", objectArray);
            throw new WrapperException(string2);
        }
        return string;
    }

    private String getExplorerDirname() throws WrapperException {
        String string = null;
        String[] stringArray = new String[]{"/usr/cluster/lib/sccheck/explorer_wrapper", "dirname"};
        try {
            string = Utils.runCmdOneString(stringArray);
        }
        catch (WrapperException wrapperException) {
            Object[] objectArray = new Object[]{wrapperException.getMessage()};
            String string2 = I18n.getLocalized("explorerResultsDirectoryNameNotFound", objectArray);
            throw new WrapperException(string2);
        }
        return string;
    }
}

