#! /usr/perl5/bin/perl -w
#
# ident   "@(#)ConfigDataParser.pm 1.1     03/11/27 SMI"
# 
# Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#

#
# Module: ScSnapshot::ConfigDataParser
# 

package ScSnapshot::ConfigDataParser;
use strict; 
use ScSnapshot::RecDescentParser;
use Sun::Solaris::Utils qw(gettext);

#
# Constructor
# Arguments: 
#   1) ScSnapshot::Logging object used to print debug messages.
#      Cannot be undefined.
#   2) A string giving the version of SunCluster software.
#
sub new 
{
    my $proto = shift;
    my $class = ref($proto) || $proto;
    my $self  = {};
    $self->{DATA} = {};
    $self->{DATA}->{scsoftvers} = shift;
    $self->{DATA}->{osversion} = shift;
    $self->{DATA}->{arch} = shift;
    $self->{EXIT_CODE} = shift;
    bless ($self, $class);
    return $self;
}

#
# Gets/Sets the Internal Data Representation resulting from the parsing of 
# the CCR configuration data.
#
sub data 
{
    my $self = shift;
    if (@_) 
    { 
        $self->{DATA} = shift;
    }
    return $self->{DATA};
}

#
# Performs the parsing of the CCR configuration data.
# Fails on any parsing error.
# Arguments:
#   1) String containing the data to be parsed.
#      Cannot be undefined.
#
sub parse
{
    my $self = shift;
    my $data = shift;
    # Create a new ScSnapshot::RecDescentParser.
    # Provide it with a reference on our Internal Data Representation
    # so that it can be updated dynamically during the descent.
    my $parser = ScSnapshot::RecDescentParser->new($self->{DATA});
    # Initiate the parsing on the grammar's starting rule.
    if(!defined($parser->startrule($data))) {
      print STDERR gettext ("FATAL INTERNAL ERROR: An unexpected error occured while parsing the CCR data\n");
      exit $self->{EXIT_CODE}->getCode("ENOEXEC");
    }
}

# Return success for module load
1; 
