/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.WrapperException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils
implements Globals {
    public static int inetAddressToInt(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        int n = Utils.byteArrayToInt(byArray);
        return n;
    }

    public static int dottedQuadToInt(String string) {
        int n = Utils.byteArrayToInt(Utils.dottedQuadToByteArray(string));
        return n;
    }

    public static byte[] dottedQuadToByteArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            byte by;
            String string2 = stringTokenizer.nextToken();
            try {
                n2 = Integer.parseInt(string2);
                if (n2 > 127) {
                    n2 -= 256;
                }
                by = Byte.parseByte(Integer.toString(n2));
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger().info("Utils.dottedQuadToByteArray(): in NumberFormatException on: " + string + ": " + numberFormatException.getMessage());
                by = 0;
            }
            byArray[n3++] = by;
        }
        return byArray;
    }

    public static int byteArrayToInt(byte[] byArray) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < byArray.length) {
            Byte by = new Byte(byArray[n2]);
            int n3 = byArray[n2];
            if (n3 < 0) {
                n3 &= 0xFF;
            }
            n <<= 8;
            n += n3;
            ++n2;
        }
        return n;
    }

    public static void runScript(String string) throws WrapperException {
        Utils.runScript(string, null);
    }

    public static void runScript(String string, String[] stringArray) throws WrapperException {
        Logger logger = Logger.getLogger();
        int n = 0;
        String string2 = null;
        String string3 = "";
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        File file = null;
        try {
            file = File.createTempFile("sccheck_", ".sh");
            file.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println(string);
            printWriter.close();
            String string4 = "/bin/sh " + file.getPath();
            logger.info("Utils.runScript(): " + string4);
            logger.info("Utils.runScript(): " + string);
            process = stringArray == null ? runtime.exec(string4) : runtime.exec(string4, stringArray);
            n = process.waitFor();
            logger.info("Utils.runScript() got return code " + n);
            if (n != 0) {
                InputStream inputStream = process.getErrorStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    logger.info("Utils.runScript() stderr: " + string2);
                    string3 = string3 + string2;
                }
                logger.error("Utils.runScript() throwing WrapperException");
                throw new WrapperException(string3);
            }
        }
        catch (IOException iOException) {
            logger.error("Utils.runScript(): IOException ioex: " + iOException.getMessage());
            throw new WrapperException(iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            logger.error("Utils.runScript(): InterruptedException iex: " + interruptedException.getMessage());
            throw new WrapperException(interruptedException.getMessage());
        }
        logger.trace("Utils.runScript() -- EXIT-- ");
    }

    public static void runCmdNoStdout(String[] stringArray) throws WrapperException {
        Logger logger = Logger.getLogger();
        logger.info("Utils.runCmdNoStdout() cmdArray: " + Utils.dumpStringArray(stringArray));
        int n = 0;
        String string = null;
        String string2 = "";
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            n = process.waitFor();
            logger.info("Utils.runCmdNoStdout() got return code " + n);
            if (n != 0) {
                InputStream inputStream = process.getErrorStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    logger.info("Utils.runCmdNoStdout() stderr: " + string);
                    string2 = string2 + string;
                }
                logger.trace("Utils.runCmdNoStdout() end read stderr");
                logger.error("Utils.runCmdNoStdout() throwing WrapperException: " + n);
                throw new WrapperException(string2);
            }
        }
        catch (IOException iOException) {
            logger.error("Utils.runCmdNoStdout(): IOException ioex: " + iOException.getMessage());
            throw new WrapperException(iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            logger.error("Utils.runCmdNoStdout(): InterruptedException iex: " + interruptedException.getMessage());
            throw new WrapperException(interruptedException.getMessage());
        }
        logger.trace("Utils.runCmdNoStdout() -- EXIT-- ");
    }

    public static String runCmdOneString(String[] stringArray) throws WrapperException {
        Logger logger = Logger.getLogger();
        String string = null;
        int n = 0;
        String string2 = null;
        String string3 = "";
        logger.info("Utils.runCmdOneString() cmdArray: " + Utils.dumpStringArray(stringArray));
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            InputStream inputStream2 = process.getErrorStream();
            InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2);
            BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
            string = bufferedReader.readLine();
            logger.info("Utils.runCmdOneString() result: " + string);
            n = process.waitFor();
            logger.info("Utils.runCmdOneString() returnCode: " + n);
            if (n != 0) {
                while ((string2 = bufferedReader2.readLine()) != null) {
                    logger.info("err: " + string2);
                    string3 = string3 + string2;
                }
                logger.info("Utils.runCmdOneString() error return: " + n);
                throw new WrapperException(string3);
            }
        }
        catch (IOException iOException) {
            logger.info("Utils.runCmdOneString(): IOException: " + iOException.getMessage());
            throw new WrapperException(iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            logger.info("Utils.runCmdOneString(): InterruptedException: " + interruptedException.getMessage());
            throw new WrapperException(interruptedException.getMessage());
        }
        logger.trace("Utils.runCmdOneString() -- EXIT-- ");
        return string;
    }

    public static boolean mkdir(String string) {
        File file = new File(string);
        boolean bl = file.mkdirs();
        return bl;
    }

    public boolean rmrfDir(String string) {
        boolean bl = true;
        File file = new File(string);
        String string2 = file.getPath();
        String[] stringArray = file.list();
        if (!file.exists()) {
            bl = false;
            return bl;
        }
        if (!file.isDirectory()) {
            bl = false;
            return bl;
        }
        if (stringArray == null) {
            bl = false;
            return bl;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string3 = string2 + "/" + stringArray[n];
            File file2 = new File(string3);
            if (file2.isDirectory()) {
                Utils utils = new Utils();
                utils.rmrfDir(string3);
                file2.delete();
            } else {
                file2.delete();
            }
            ++n;
        }
        file.delete();
        return bl;
    }

    public static String dumpStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n == 0) {
                stringBuffer.append("[");
            }
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isDir(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.isDirectory();
    }

    public static boolean stringIsUnique(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            if (string.equals(vector.get(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Utils.main() requires filename argument ");
            System.exit(0);
        }
        Utils utils = new Utils();
        utils.rmrfDir(stringArray[0]);
    }
}

