/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.Session;

public class SessionFactory
implements Globals {
    public static Session getSession(int n) throws SCException {
        Logger logger = Logger.getLogger();
        logger.trace("SessionFactory() -- ENTER -- " + n);
        Session session = null;
        String string = "com.sun.cluster.sccheck.SessionV" + n;
        logger.info("SessionFactory() classname: " + string);
        Object[] objectArray = null;
        String string2 = "";
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            session = (Session)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("Session.getSession() ClassNotFoundException: " + classNotFoundException.getMessage());
            objectArray = new Object[]{string};
            string2 = I18n.getLocalized("unableToLoad", objectArray);
            throw new SCException(string2);
        }
        catch (InstantiationException instantiationException) {
            logger.error("Session.getSession() InstantiationException: " + instantiationException.getMessage());
            objectArray = new Object[]{string, instantiationException.getMessage()};
            string2 = I18n.getLocalized("unableToLoadException", objectArray);
            throw new SCException(string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error("Session.getSession() IllegalAccessException: " + illegalAccessException.getMessage());
            objectArray = new Object[]{string, illegalAccessException.getMessage()};
            string2 = I18n.getLocalized("unableToLoad.exception", objectArray);
            throw new SCException(string2);
        }
        logger.trace("SessionFactory() --EXIT-- " + session);
        return session;
    }
}

