/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Client;
import com.sun.cluster.sccheck.ClientThread;
import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.I18n;
import com.sun.cluster.sccheck.KEWrapper;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.ProgressListener;
import com.sun.cluster.sccheck.SCException;
import com.sun.cluster.sccheck.SCProperties;
import com.sun.cluster.sccheck.Utils;
import com.sun.cluster.sccheck.WrapperException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class SccheckClient
implements Client,
ProgressListener,
Globals {
    private boolean brief = false;
    private boolean verbose = false;
    private boolean vverbose = false;
    private int minSeverity = 0;
    private String hostlist = null;
    private String reportsDir = null;
    private String singleRuleFilePath = "/usr/cluster/lib/sccheck/checklist.cluster.singlenode.xml";
    private String multiRuleFilePath = "/usr/cluster/lib/sccheck/checklist.cluster.multinode.xml";
    private String explorerFilesPath = null;
    private boolean explorerArchiveSpecified = false;
    private String explorersgzDir = null;
    private String explorersUnpackDir = null;
    private Vector zippedExplorers = new Vector();
    private String clientNumber = null;
    private String clientName = null;
    private String privateClientName = null;
    private String clustername = null;
    private String clientVarTmpDir = null;
    private String xslDir = null;
    private String keLogName = null;
    private boolean clientThreadFailed = false;
    private String failedNodes = null;
    private int numHosts = 0;
    private String[] genDates = null;
    private String[] clusterPublicNames = null;
    private String[] clusterPrivateNames = null;
    private String[] sessionPublicNames = null;
    private String[] sessionPrivateNames = null;
    private boolean inClusterMode = true;
    private int maxServerExitCode = 0;
    private int multiReportExitCode = 0;
    private Logger logger = null;
    private SCProperties props = null;

    public SccheckClient() {
        String string;
        boolean bl = false;
        this.clientNumber = System.getProperty("sccheck.clientnumber");
        if (this.clientNumber == null) {
            this.clientNumber = "0";
            this.clientVarTmpDir = "/var/cluster/sccheck/tmp/client." + this.clientNumber;
        }
        try {
            this.props = SCProperties.getSCProperties("/etc/default/sccheck");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl2 = SCProperties.booleanFromProps("LOGGING", false, this.props);
        this.logger = new Logger("/var/cluster/logs/sccheck/client.log." + this.clientNumber, bl2);
        this.logger.info("SccheckClient() -- ENTER; clientNumber: " + this.clientNumber);
        this.logger.info("SccheckClient() java version: " + System.getProperty("java.version"));
        if (!bl2) {
            System.setProperty("ke.client.log", "/dev/null");
        }
        try {
            this.checkRequiredDefines();
        }
        catch (SCException sCException) {
            string = sCException.getMessage();
            this.logger.error("SccheckClient() usage error: " + string);
            this.earlyExit(103, string);
        }
        this.loadOptionalDefines();
        if (this.explorerFilesPath != null) {
            this.expandExplorerList();
            this.explorerArchiveSpecified = true;
        }
        this.logger.info("explorer archive specified : " + this.explorerArchiveSpecified);
        if (this.zippedExplorers.size() > 1) {
            this.logger.trace("More than one explorer archives specified=> jump to  multi nodes checks");
            bl = true;
        } else {
            this.sessionPublicNames = new String[1];
            this.sessionPrivateNames = new String[1];
            this.sessionPublicNames[0] = this.clientName;
            this.sessionPrivateNames[0] = this.privateClientName;
        }
        this.logger.info("do only multi node check : " + bl);
        if (!this.explorerArchiveSpecified) {
            try {
                this.expandHostlist();
            }
            catch (SCException sCException) {
                string = sCException.getMessage();
                this.logger.error("SccheckClient() bad hostname: " + string);
                this.earlyExit(105, string);
            }
        }
        if (!bl) {
            try {
                if (!this.explorerArchiveSpecified) {
                    this.remoteOperations(this.sessionPublicNames, this.sessionPrivateNames, null);
                } else {
                    this.remoteOperations(this.sessionPublicNames, this.sessionPrivateNames, this.zippedExplorers.get(0).toString());
                }
            }
            catch (SCException sCException) {
                string = sCException.getMessage();
                this.logger.error("SccheckClient() remote ops exception: " + string);
                if (this.clientThreadFailed) {
                    this.earlyExit(107, string);
                }
                this.earlyExit(108, string);
            }
        }
        if (this.zippedExplorers.size() > 1) {
            this.logger.trace("SccheckClient(): " + this.clustername + ": running multi-node checks");
            try {
                this.multiReportExitCode = this.runKE(this.zippedExplorers, this.multiRuleFilePath);
            }
            catch (WrapperException wrapperException) {
                this.logger.error("SccheckClient() in WrapperException wex2: " + wrapperException.getMessage());
                this.earlyExit(108, wrapperException.getMessage());
            }
        } else {
            this.logger.trace(this.clustername + ": skipping multi-node checks");
        }
        if (!bl) {
            this.compareGenDates();
        }
        this.logger.trace("SccheckClient() --EXIT-- " + this.maxServerExitCode);
        this.logger.close();
    }

    private void checkRequiredDefines() throws SCException {
        String string = null;
        Vector<String> vector = new Vector<String>();
        vector.addElement("sccheck.clustermode");
        vector.addElement("sccheck.clustername");
        vector.addElement("sccheck.localname");
        vector.addElement("sccheck.privatelocalname");
        vector.addElement("sccheck.publicnodenames");
        vector.addElement("sccheck.privatenodenames");
        vector.addElement("sccheck.outputDir");
        vector.addElement("sccheck.explorersgzDir");
        vector.addElement("sccheck.explorersUnpackDir");
        vector.addElement("sccheck.gunzip");
        vector.addElement("sccheck.tar");
        vector.addElement("ke.client.log");
        vector.addElement("ke.client.xsldir");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = System.getProperty(string2);
            if (string3 != null) continue;
            string = string == null ? string2 : string + ", " + string2;
        }
        if (string != null) {
            Object[] objectArray = new Object[]{string};
            String string4 = I18n.getLocalized("requiredDefinesMissing", objectArray);
            throw new SCException(string4);
        }
        this.clustername = System.getProperty("sccheck.clustername");
        this.logger.info("SccheckClient.checkRequiredDefines() clustername: " + this.clustername);
        this.clientName = System.getProperty("sccheck.localname");
        this.logger.info("SccheckClient.checkRequiredDefines() clientName: " + this.clientName);
        this.privateClientName = System.getProperty("sccheck.privatelocalname");
        this.logger.info("SccheckClient.checkRequiredDefines() private clientName: " + this.privateClientName);
        String string5 = System.getProperty("sccheck.publicnodenames");
        this.clusterPublicNames = this.preProcessNodeNames(string5);
        string5 = System.getProperty("sccheck.privatenodenames");
        this.clusterPrivateNames = this.preProcessNodeNames(string5);
        this.reportsDir = System.getProperty("sccheck.outputDir");
        this.explorersgzDir = System.getProperty("sccheck.explorersgzDir");
        this.explorersUnpackDir = System.getProperty("sccheck.explorersUnpackDir");
        this.inClusterMode = Boolean.getBoolean("sccheck.clustermode");
        this.logger.info("SccheckClient.checkRequiredDefines() inClusterMode: " + this.inClusterMode);
        this.logger.info("SccheckClient.checkRequiredDefines() gunzip: " + System.getProperty("sccheck.gunzip"));
        this.keLogName = System.getProperty("ke.client.log");
        this.logger.info("SccheckClient.checkRequiredDefines() keLogName: " + this.keLogName);
        this.xslDir = System.getProperty("ke.client.xsldir");
        this.logger.info("SccheckClient.checkRequiredDefines() xslDir: " + this.xslDir);
    }

    private void loadOptionalDefines() {
        this.brief = Boolean.getBoolean("sccheck.brief");
        this.logger.info("SccheckClient.loadOptionalDefines() brief: " + this.brief);
        this.verbose = Boolean.getBoolean("sccheck.verbose");
        this.logger.info("SccheckClient.loadOptionalDefines() verbose: " + this.verbose);
        this.vverbose = Boolean.getBoolean("sccheck.vverbose");
        this.logger.info("SccheckClient.loadOptionalDefines() vverbose: " + this.vverbose);
        this.hostlist = System.getProperty("sccheck.hostlist");
        this.logger.info("SccheckClient.loadOptionalDefines() hostlist: " + this.hostlist);
        this.minSeverity = 0;
        Integer n = Integer.getInteger("sccheck.severity");
        if (n != null) {
            this.minSeverity = n;
        }
        this.logger.info("SccheckClient.loadOptionalDefines() minSeverity: " + this.minSeverity);
        String string = System.getProperty("sccheck.singleNodecheckFilePath");
        if (string != null) {
            this.singleRuleFilePath = string;
            this.logger.info("SccheckClient.loadOptionalDefines() single mode rule file path: " + this.singleRuleFilePath);
        }
        if ((string = System.getProperty("sccheck.multiNodeModecheckFilePath")) != null) {
            this.multiRuleFilePath = string;
            this.logger.info("SccheckClient.loadOptionalDefines() multi mode rule file path: " + this.multiRuleFilePath);
        }
        this.explorerFilesPath = System.getProperty("sccheck.explorerFilesPath");
        this.logger.info("SccheckClient.loadOptionalDefines() explorer input files path: " + this.explorerFilesPath);
    }

    private void expandHostlist() throws SCException {
        if (this.inClusterMode) {
            this.expandHostlistClusterMode();
        } else {
            this.expandHostlistNonClusterMode();
        }
        this.logger.info("SccheckClient.expandHostlist() -- sessionPublicNames: " + Utils.dumpStringArray(this.sessionPublicNames));
        this.logger.info("SccheckClient.expandHostlist() -- sessionPrivateNames: " + Utils.dumpStringArray(this.sessionPrivateNames));
    }

    private void remoteOperations(String[] stringArray, String[] stringArray2, String string) throws SCException {
        String string2;
        this.logger.info("SccheckClient.remOps(): " + Utils.dumpStringArray(stringArray) + " / " + Utils.dumpStringArray(stringArray));
        if (string != null) {
            this.postProgress(1, "preparing to run checksagainst specified explorer archive" + string);
        }
        this.numHosts = stringArray.length;
        this.genDates = new String[this.numHosts];
        ClientThread[] clientThreadArray = new ClientThread[this.numHosts];
        int n = 0;
        while (n < this.numHosts) {
            String string3 = stringArray[n];
            string2 = stringArray2[n];
            String string4 = this.explorersgzDir + "/" + string3 + ".expl.gzip";
            String string5 = this.reportsDir + "/" + "sccheck-results" + "." + string3;
            this.logger.info("SccheckClient.remOps() reportsDir: " + this.reportsDir);
            this.logger.info("SccheckClient.remOps() CLIENT_REPORTNAME: sccheck-results");
            this.logger.info("SccheckClient.remOps() reportFilename: " + string5);
            this.logger.info("SccheckClient.remOps() new thread for: " + string3 + "/" + string2);
            if (!this.explorerArchiveSpecified) {
                Object[] objectArray = new Object[]{string3};
                String string6 = I18n.getLocalized("requestingExplorerAndNodeReportFrom", objectArray);
                this.postProgress(1, string6);
            }
            clientThreadArray[n] = new ClientThread(this, this, string3, string2, string4, string5, this.brief, this.minSeverity, this.singleRuleFilePath, string);
            clientThreadArray[n].start();
            ++n;
        }
        try {
            this.waitForClientThreads(clientThreadArray);
        }
        catch (InterruptedException interruptedException) {
            this.logger.error("SccheckClient.remOps() InterruptedException");
            string2 = I18n.getLocalized("interruptionBeforeRequestsCompleted");
            throw new SCException(string2);
        }
        if (this.clientThreadFailed) {
            this.logger.error("SccheckClient.remOps() failedNodes: " + this.failedNodes);
            throw new SCException(this.failedNodes);
        }
        this.logger.trace("SccheckClient.remOps() -- EXIT -- ");
    }

    private int runKE(Vector vector, String string) throws WrapperException {
        this.logger.trace("SccheckClient.runKE() --ENTER--");
        String string2 = this.reportsDir + "/" + "sccheck-results" + "." + this.clustername;
        int n = 0;
        String string3 = I18n.getLocalized("startingMultiNodeChecks");
        this.postProgress(1, string3);
        this.logger.trace("SccheckClient.runKE() about to make KEWrapper");
        this.logger.info("SccheckClient.runKE() explorersUnpackDir: " + this.explorersUnpackDir);
        KEWrapper kEWrapper = null;
        try {
            kEWrapper = new KEWrapper(this, string2, vector, this.explorersUnpackDir, this.brief, this.minSeverity, this.keLogName, this.xslDir);
            kEWrapper.runKE(string);
            string3 = I18n.getLocalized("multiNodeChecksFinished");
            this.postProgress(1, string3);
            kEWrapper.removeUnpackedExplorers();
        }
        catch (WrapperException wrapperException) {
            this.logger.error("SccheckClient.runKE() in WrapperException wex: " + wrapperException.getMessage());
            throw new WrapperException(wrapperException.getMessage());
        }
        n = kEWrapper.getMaxSeverity();
        this.logger.trace("SccheckClient.runKE() --EXIT: " + n);
        return n;
    }

    private void compareGenDates() {
        this.logger.trace("SccheckClient.compareGenDates() -- ENTER -- ");
        String string = this.genDates[0];
        int n = 0;
        while (n < this.genDates.length) {
            if (!string.equals(this.genDates[n])) {
                this.warnGenDates();
                break;
            }
            ++n;
        }
        this.logger.trace("SccheckClient.compareGenDates() -- EXIT -- ");
    }

    public int getExitCode() {
        if (this.getMaxServerExitCode() >= this.getMultiReportExitCode()) {
            return this.getMaxServerExitCode();
        }
        return this.getMultiReportExitCode();
    }

    private void earlyExit(int n) {
        this.earlyExit(n, null);
    }

    private void earlyExit(int n, String string) {
        String string2 = "";
        switch (n) {
            case 101: {
                string2 = "permissionDenied";
                break;
            }
            case 102: {
                string2 = "componentError";
                break;
            }
            case 103: {
                string2 = "internalInvocationError";
                break;
            }
            case 104: {
                string2 = "unableToLoadClusterData";
                break;
            }
            case 105: {
                if (this.inClusterMode) {
                    string2 = "noClusterNodeNameMatching";
                    break;
                }
                string2 = "hostlistNotAllowedInNonClusterMode";
                break;
            }
            case 107: {
                string2 = "unableToRunChecksOn";
                break;
            }
            case 108: {
                string2 = "internalError";
                break;
            }
            default: {
                string2 = "unknownError";
            }
        }
        Object[] objectArray = new Object[]{I18n.getLocalized("sccheck"), I18n.getLocalized(string2), string};
        String string3 = I18n.getLocalized("earlyExitFormat", objectArray);
        System.err.println(string3);
        this.logger.info("SccheckClient.earlyExit() called with code " + n + " (" + string + ")");
        this.logger.close();
        System.exit(n);
    }

    public synchronized void addZippedExplorer(String string) {
        this.zippedExplorers.addElement(string);
    }

    public synchronized void postFailure(String string) {
        this.clientThreadFailed = true;
        this.failedNodes = this.failedNodes == null ? string : this.failedNodes + "," + string;
    }

    public synchronized void addServerExitCode(String string, int n) {
        this.logger.info("SccheckClient.addServerExitCode(): " + n + " from " + string);
        if (n > this.maxServerExitCode) {
            this.maxServerExitCode = n;
        }
        this.logger.info("SccheckClient.addServerExitCode() maxServerExitCode: " + this.maxServerExitCode);
    }

    public synchronized void addGenDate(String string, String string2) {
        this.logger.info("SccheckClient.addGenDate(): " + string2 + " from " + string);
        boolean bl = false;
        int n = 0;
        while (n < this.sessionPublicNames.length) {
            if (this.sessionPublicNames[n].equals(string)) {
                this.genDates[n] = string2;
                bl = true;
                this.logger.info("SccheckClient.addGenDate() match: " + string);
                break;
            }
            ++n;
        }
        if (!bl) {
            this.logger.error("SccheckClient.addGenDate() couldn't match " + string + " in sessionPublicNames[]");
        }
        this.logger.trace("SccheckClient.addGenDate() -- EXIT --");
    }

    public String getLocaleLang() {
        return Locale.getDefault().getLanguage();
    }

    public String getLocaleCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getLocaleVariant() {
        return Locale.getDefault().getVariant();
    }

    public String getAuth() {
        return null;
    }

    public String getPrivateClientHostname() {
        return this.privateClientName;
    }

    public String getClusterName() {
        return this.clustername;
    }

    public synchronized void postProgress(int n, String string) {
        this.logger.info("postProgress: (verbose: " + n + ") " + string);
        if (n == 0 || this.vverbose || n == 1 && this.verbose) {
            Object[] objectArray = new Object[]{I18n.getLocalized("sccheck"), string};
            String string2 = I18n.getLocalized("postProgressFormat", objectArray);
            System.out.println(string2);
        }
    }

    public synchronized void postErrMsg(String string) {
        this.logger.info("postErrMsg: " + string);
        Object[] objectArray = new Object[]{I18n.getLocalized("sccheck"), string};
        String string2 = I18n.getLocalized("postErrMsgFormat", objectArray);
        System.err.println(string2);
    }

    private String[] preProcessNodeNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        String[] stringArray = new String[n];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private void expandExplorerList() {
        if (!this.zippedExplorers.isEmpty()) {
            this.zippedExplorers.clear();
        }
        this.logger.trace("SccheckClient() > expanding explorer archives list");
        StringTokenizer stringTokenizer = new StringTokenizer(this.explorerFilesPath, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!Utils.stringIsUnique(this.zippedExplorers, string)) continue;
            this.logger.trace("SccheckClient() > adding " + string);
            this.zippedExplorers.add(string);
        }
    }

    private void expandHostlistClusterMode() throws SCException {
        int n = 0;
        if (this.hostlist == null) {
            n = this.clusterPublicNames.length;
            this.sessionPublicNames = new String[n];
            this.sessionPrivateNames = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.sessionPublicNames[n2] = this.clusterPublicNames[n2];
                this.sessionPrivateNames[n2] = this.clusterPrivateNames[n2];
                ++n2;
            }
        } else {
            StringBuffer stringBuffer = null;
            StringTokenizer stringTokenizer = new StringTokenizer(this.hostlist, ",");
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (vector.contains(string)) continue;
                vector.add(string);
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string);
            }
            stringTokenizer = new StringTokenizer(stringBuffer.toString(), ",");
            n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            this.sessionPublicNames = new String[n];
            this.sessionPrivateNames = new String[n];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string;
                stringArray[n3] = string = stringTokenizer.nextToken();
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.sessionPublicNames.length) {
                boolean bl = false;
                int n5 = 0;
                while (n5 < this.clusterPublicNames.length) {
                    if (stringArray[n4].equals(this.clusterPublicNames[n5])) {
                        this.sessionPublicNames[n4] = stringArray[n4];
                        this.sessionPrivateNames[n4] = this.clusterPrivateNames[n5];
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    this.logger.error("SccheckClient.expandHostlistClusterMode() hostname not a cluster member: " + stringArray[n4]);
                    throw new SCException(stringArray[n4]);
                }
                ++n4;
            }
        }
    }

    private void expandHostlistNonClusterMode() throws SCException {
        if (this.hostlist != null) {
            throw new SCException(this.hostlist);
        }
        this.sessionPublicNames = new String[]{this.clientName};
        this.sessionPrivateNames = new String[]{"localhost"};
    }

    /*
     * Unable to fully structure code
     */
    private void waitForClientThreads(ClientThread[] var1_1) throws InterruptedException {
        block4: {
            this.logger.trace("SccheckClient.waitForClientThreads() -- ENTER -- ");
            var2_2 = var1_1.length;
            try {
                var3_3 = 0;
                while (var3_3 < var2_2) {
                    var1_1[var3_3].join();
                    ++var3_3;
                }
                break block4;
            }
            catch (InterruptedException var3_4) {
                this.logger.error("SccheckClient.waitForClientThreads() InterruptedException");
                var4_5 = 0;
                ** while (var4_5 < var2_2)
            }
lbl-1000:
            // 1 sources

            {
                var1_1[var4_5].die();
                ++var4_5;
                continue;
            }
lbl17:
            // 1 sources

            throw var3_4;
        }
        this.logger.trace("SccheckClient.waitForClientThreads() -- EXIT -- ");
    }

    private void warnGenDates() {
        this.logger.trace("SccheckClient.warnGenDates() -- ENTER -- ");
        this.postProgress(0, I18n.getLocalized("warnGenDates"));
        if (!this.verbose && !this.vverbose) {
            this.postProgress(0, I18n.getLocalized("rerunWithVVForMoreDetails"));
        }
        int n = 0;
        while (n < this.genDates.length) {
            Object[] objectArray = new Object[]{this.sessionPublicNames[n] + ":", this.genDates[n]};
            String string = I18n.getLocalized("showGenDate", objectArray);
            this.postProgress(1, string);
            ++n;
        }
        this.logger.trace("SccheckClient.warnGenDates() -- EXIT -- ");
    }

    private int getMultiReportExitCode() {
        return this.multiReportExitCode;
    }

    private int getMaxServerExitCode() {
        return this.maxServerExitCode;
    }

    public static void main(String[] stringArray) {
        SccheckClient sccheckClient = new SccheckClient();
        int n = sccheckClient.getExitCode();
        System.exit(n);
    }
}

