/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cluster.sccheck;

import com.sun.cluster.sccheck.Globals;
import com.sun.cluster.sccheck.Logger;
import com.sun.cluster.sccheck.SCException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class SCXmlToText
implements Globals {
    private Logger logger = Logger.getLogger();
    private String outDir = null;
    private int numFilteredChecks = 0;
    private int minSeverity = 0;
    private boolean brief;

    public SCXmlToText(String string, int n, int n2, boolean bl) {
        this.outDir = string;
        this.minSeverity = n2;
        this.brief = bl;
        this.numFilteredChecks = n;
        this.logger.info("SCXmlToText() outDir: " + string);
        this.logger.info("SCXmlToText() minSeverity: " + n2 + "; brief: " + bl);
        this.logger.info("SCXmlToText() numFilteredChecks: " + n);
    }

    public void generateXSLFile() throws SCException {
        Closeable closeable;
        Closeable closeable2;
        this.logger.trace("SCXmlToText.generateXSLFile() -- ENTER --");
        StringBuffer[] stringBufferArray = new StringBuffer[5];
        Object var2_2 = null;
        try {
            closeable2 = new FileReader("/usr/cluster/lib/sccheck/SCXmlToText.xsl.tmpl");
            this.logger.trace("SCXmlToText.generateXSLFile() reading: /usr/cluster/lib/sccheck/SCXmlToText.xsl.tmpl");
            closeable = new BufferedReader((Reader)closeable2);
            String string = "";
            int n = 0;
            while (n < stringBufferArray.length) {
                stringBufferArray[n] = new StringBuffer("");
                ++n;
            }
            int n2 = 0;
            do {
                if ((string = ((BufferedReader)closeable).readLine()) == null) continue;
                stringBufferArray[n2].append(string + "\n");
                if (!string.startsWith("<!-- scheck section marker")) continue;
                ++n2;
            } while (string != null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.info("SCXmlToText: fnfex: " + fileNotFoundException.getMessage());
            throw new SCException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.info("SCXmlToText: ioex: " + iOException.getMessage());
            throw new SCException(iOException.getMessage());
        }
        try {
            this.logger.trace("SCXmlToText.generateXSLFile() writing: " + this.outDir + "/SCXmlToText.xsl");
            closeable2 = new FileWriter(this.outDir + "/SCXmlToText.xsl");
            closeable = new PrintWriter((Writer)closeable2, true);
            ((PrintWriter)closeable).print(stringBufferArray[0]);
            if (this.minSeverity > 0) {
                ((PrintWriter)closeable).println("Severity Filter Allowing      : " + Globals.SEVERITY_STRINGS[this.minSeverity] + " and greater.");
            }
            ((PrintWriter)closeable).print(stringBufferArray[1]);
            if (this.minSeverity > 0) {
                ((PrintWriter)closeable).println("Filtered : " + this.numFilteredChecks);
            }
            ((PrintWriter)closeable).print(stringBufferArray[2]);
            if (!this.brief) {
                ((PrintWriter)closeable).print(stringBufferArray[3]);
            }
            ((PrintWriter)closeable).print(stringBufferArray[4]);
            ((PrintWriter)closeable).close();
        }
        catch (IOException iOException) {
            this.logger.info("SCXmlToText: ioex2: " + iOException.getMessage());
            throw new SCException(iOException.getMessage());
        }
        this.logger.trace("SCXmlToText.generateXSLFile() -- EXIT --");
    }
}

