/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document.schema;

import com.sun.xml.rpc.util.NullIterator;
import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaAttribute;
import com.sun.xml.rpc.wsdl.framework.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class SchemaElement {
    private String _nsURI;
    private String _localName;
    private List _children;
    private List _attributes;
    private Map _nsPrefixes;
    private SchemaElement _parent;
    private QName _qname;
    private Schema _schema;
    private static final String NEW_NS_PREFIX_BASE = "ns";

    public SchemaElement() {
    }

    public SchemaElement(String string) {
        this._localName = string;
    }

    public SchemaElement(QName qName) {
        this._qname = qName;
        this._localName = qName.getLocalPart();
        this._nsURI = qName.getNamespaceURI();
    }

    public String getNamespaceURI() {
        return this._nsURI;
    }

    public void setNamespaceURI(String string) {
        this._nsURI = string;
    }

    public String getLocalName() {
        return this._localName;
    }

    public void setLocalName(String string) {
        this._localName = string;
    }

    public QName getQName() {
        if (this._qname == null) {
            this._qname = new QName(this._nsURI, this._localName);
        }
        return this._qname;
    }

    public SchemaElement getParent() {
        return this._parent;
    }

    public void setParent(SchemaElement schemaElement) {
        this._parent = schemaElement;
    }

    public SchemaElement getRoot() {
        return this._parent == null ? this : this._parent.getRoot();
    }

    public Schema getSchema() {
        return this._parent == null ? this._schema : this._parent.getSchema();
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public void addChild(SchemaElement schemaElement) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(schemaElement);
        schemaElement.setParent(this);
    }

    public void insertChildAtTop(SchemaElement schemaElement) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(0, schemaElement);
        schemaElement.setParent(this);
    }

    public Iterator children() {
        if (this._children == null) {
            return NullIterator.getInstance();
        }
        return this._children.iterator();
    }

    public void addAttribute(SchemaAttribute schemaAttribute) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes.add(schemaAttribute);
        schemaAttribute.setParent(this);
        schemaAttribute.getValue();
    }

    public void addAttribute(String string, String string2) {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        schemaAttribute.setLocalName(string);
        schemaAttribute.setValue(string2);
        this.addAttribute(schemaAttribute);
    }

    public void addAttribute(String string, QName qName) {
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        schemaAttribute.setLocalName(string);
        schemaAttribute.setValue(qName);
        this.addAttribute(schemaAttribute);
    }

    public Iterator attributes() {
        if (this._attributes == null) {
            return NullIterator.getInstance();
        }
        return this._attributes.iterator();
    }

    public SchemaAttribute getAttribute(String string) {
        if (this._attributes != null) {
            Iterator iterator = this._attributes.iterator();
            while (iterator.hasNext()) {
                SchemaAttribute schemaAttribute = (SchemaAttribute)iterator.next();
                if (!string.equals(schemaAttribute.getLocalName())) continue;
                return schemaAttribute;
            }
        }
        return null;
    }

    public String getValueOfMandatoryAttribute(String string) {
        SchemaAttribute schemaAttribute = this.getAttribute(string);
        if (schemaAttribute == null) {
            throw new ValidationException("validation.missingRequiredAttribute", new Object[]{string, this._localName});
        }
        return schemaAttribute.getValue();
    }

    public String getValueOfAttributeOrNull(String string) {
        SchemaAttribute schemaAttribute = this.getAttribute(string);
        if (schemaAttribute == null) {
            return null;
        }
        return schemaAttribute.getValue();
    }

    public boolean getValueOfBooleanAttributeOrDefault(String string, boolean bl) {
        String string2 = this.getValueOfAttributeOrNull(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("0")) {
            return false;
        }
        throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, string2});
    }

    public int getValueOfIntegerAttributeOrDefault(String string, int n) {
        String string2 = this.getValueOfAttributeOrNull(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, string2});
        }
    }

    public QName getValueOfQNameAttributeOrNull(String string) {
        String string2;
        String string3 = this.getValueOfAttributeOrNull(string);
        if (string3 == null) {
            return null;
        }
        String string4 = XmlUtil.getPrefix(string3);
        String string5 = string2 = string4 == null ? this.getURIForPrefix("") : this.getURIForPrefix(string4);
        if (string2 == null) {
            throw new ValidationException("validation.invalidAttributeValue", new Object[]{string, string3});
        }
        return new QName(string2, XmlUtil.getLocalPart(string3));
    }

    public void addPrefix(String string, String string2) {
        if (this._nsPrefixes == null) {
            this._nsPrefixes = new HashMap();
        }
        this._nsPrefixes.put(string, string2);
    }

    public String getURIForPrefix(String string) {
        String string2;
        if (this._nsPrefixes != null && (string2 = (String)this._nsPrefixes.get(string)) != null) {
            return string2;
        }
        if (this._parent != null) {
            return this._parent.getURIForPrefix(string);
        }
        if (this._schema != null) {
            return this._schema.getURIForPrefix(string);
        }
        return null;
    }

    public boolean declaresPrefixes() {
        return this._nsPrefixes != null;
    }

    public Iterator prefixes() {
        if (this._nsPrefixes == null) {
            return NullIterator.getInstance();
        }
        return this._nsPrefixes.keySet().iterator();
    }

    public QName asQName(String string) {
        String string2;
        String string3 = XmlUtil.getPrefix(string);
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = this.getURIForPrefix(string3)) == null) {
            throw new ValidationException("validation.invalidPrefix", string3);
        }
        String string4 = XmlUtil.getLocalPart(string);
        return new QName(string2, string4);
    }

    public String asString(QName qName) {
        if (qName.getNamespaceURI().equals("")) {
            return qName.getLocalPart();
        }
        Object object = this.prefixes();
        while (object.hasNext()) {
            String string = (String)object.next();
            String string2 = this.getURIForPrefix(string);
            if (!string2.equals(qName.getNamespaceURI())) continue;
            if (string.equals("")) {
                return qName.getLocalPart();
            }
            return string + ":" + qName.getLocalPart();
        }
        if (this._parent != null) {
            return this._parent.asString(qName);
        }
        if (this._schema != null && (object = this._schema.asString(qName)) != null) {
            return object;
        }
        object = this.getNewPrefix();
        this.addPrefix((String)object, qName.getNamespaceURI());
        return this.asString(qName);
    }

    protected String getNewPrefix() {
        String string = NEW_NS_PREFIX_BASE;
        int n = 2;
        String string2 = null;
        boolean bl = true;
        while (bl) {
            string2 = string + Integer.toString(n);
            bl = this.getURIForPrefix(string2) != null;
            ++n;
        }
        return string2;
    }
}

