/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util.xml;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.util.xml.NamedNodeMapIterator;
import com.sun.xml.rpc.util.xml.NodeListIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    static TransformerFactory transformerFactory = null;

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getAttributeOrNull(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static String getAttributeNSOrNull(Element element, String string, String string2) {
        Attr attr = element.getAttributeNodeNS(string2, string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public static boolean matchesTagNS(Element element, String string, String string2) {
        return element.getLocalName().equals(string) && element.getNamespaceURI().equals(string2);
    }

    public static boolean matchesTagNS(Element element, QName qName) {
        return element.getLocalName().equals(qName.getLocalPart()) && element.getNamespaceURI().equals(qName.getNamespaceURI());
    }

    public static Iterator getAllChildren(Element element) {
        return new NodeListIterator(element.getChildNodes());
    }

    public static Iterator getAllAttributes(Element element) {
        return new NamedNodeMapIterator(element.getAttributes());
    }

    public static List parseTokenList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public static String getTextForNode(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof Text) {
                stringBuffer.append(node2.getNodeValue());
                continue;
            }
            if (node2 instanceof EntityReference) {
                String string = XmlUtil.getTextForNode(node2);
                if (string == null) {
                    return null;
                }
                stringBuffer.append(string);
                continue;
            }
            return null;
        }
        return stringBuffer.toString();
    }

    public static InputStream getUTF8Stream(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "utf-8");
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        catch (IOException iOException) {
            throw new RuntimeException("should not happen");
        }
    }

    public static ByteInputStream getUTF8ByteInputStream(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "utf-8");
            outputStreamWriter.write(string);
            ((Writer)outputStreamWriter).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteInputStream byteInputStream = new ByteInputStream(byArray, byArray.length);
            return byteInputStream;
        }
        catch (IOException iOException) {
            throw new RuntimeException("should not happen");
        }
    }

    public static Transformer newTransformer() {
        Transformer transformer = null;
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IllegalStateException("Unable to create a JAXP transformer");
        }
        return transformer;
    }
}

