/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.util;

import com.sun.xml.rpc.util.HolderException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.holders.Holder;

public class Holders {
    private static final Map boxedTypes = new HashMap();

    public static Object getValue(Holder holder) {
        Class<?> clazz = holder.getClass();
        try {
            Field field = clazz.getField("value");
            return field.get(holder);
        }
        catch (Exception exception) {
            throw Holders.fieldExtractionException(exception);
        }
    }

    public static void setValue(Holder holder, Object object) {
        Class<?> clazz = holder.getClass();
        try {
            Field field = clazz.getField("value");
            field.set(holder, object);
        }
        catch (Exception exception) {
            throw Holders.fieldExtractionException(exception);
        }
    }

    public static Class stripHolderClass(Class clazz) {
        if (clazz == null || !Holder.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        try {
            Field field = clazz.getField("value");
            Class<?> clazz2 = field.getType();
            return Holders.boxClassIfPrimitive(clazz2);
        }
        catch (Exception exception) {
            throw Holders.fieldExtractionException(exception);
        }
    }

    private static Class boxClassIfPrimitive(Class clazz) {
        Class clazz2 = (Class)boxedTypes.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        return clazz;
    }

    private static HolderException fieldExtractionException(Exception exception) {
        return new HolderException("holder.valuefield.not.found", new LocalizableExceptionAdapter(exception));
    }

    static {
        boxedTypes.put(Boolean.TYPE, Boolean.class);
        boxedTypes.put(Byte.TYPE, Byte.class);
        boxedTypes.put(Character.TYPE, Character.class);
        boxedTypes.put(Short.TYPE, Short.class);
        boxedTypes.put(Integer.TYPE, Integer.class);
        boxedTypes.put(Long.TYPE, Long.class);
        boxedTypes.put(Float.TYPE, Float.class);
        boxedTypes.put(Double.TYPE, Double.class);
    }
}

