/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.xrpcc;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ConfigurationException;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.config.WSDLModelInfo;
import com.sun.xml.rpc.processor.config.parser.ConfigurationParser;
import com.sun.xml.rpc.processor.generator.CustomClassGenerator;
import com.sun.xml.rpc.processor.generator.CustomExceptionGenerator;
import com.sun.xml.rpc.processor.generator.EnumerationEncoderGenerator;
import com.sun.xml.rpc.processor.generator.EnumerationGenerator;
import com.sun.xml.rpc.processor.generator.FaultExceptionBuilderGenerator;
import com.sun.xml.rpc.processor.generator.HolderGenerator;
import com.sun.xml.rpc.processor.generator.InterfaceSerializerGenerator;
import com.sun.xml.rpc.processor.generator.LiteralObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.RemoteInterfaceGenerator;
import com.sun.xml.rpc.processor.generator.RemoteInterfaceImplGenerator;
import com.sun.xml.rpc.processor.generator.SOAPFaultSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SOAPObjectBuilderGenerator;
import com.sun.xml.rpc.processor.generator.SOAPObjectSerializerGenerator;
import com.sun.xml.rpc.processor.generator.SerializerRegistryGenerator;
import com.sun.xml.rpc.processor.generator.ServiceGenerator;
import com.sun.xml.rpc.processor.generator.ServiceInterfaceGenerator;
import com.sun.xml.rpc.processor.generator.ServletConfigGenerator;
import com.sun.xml.rpc.processor.generator.StubGenerator;
import com.sun.xml.rpc.processor.generator.TieGenerator;
import com.sun.xml.rpc.processor.generator.WSDLGenerator;
import com.sun.xml.rpc.processor.util.ClientProcessorEnvironment;
import com.sun.xml.rpc.processor.util.ModelWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.tools.xrpcc.ActionConstants;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.tools.javac.Main;

public class XrpccCompile
implements ActionConstants,
ProcessorNotificationListener {
    String classPathString;
    File destDir;
    File sourceDir;
    File nonclassDestDir;
    File configFile;
    long tm;
    String modelOutputFilename;
    String modelOutputFilenameXML;
    boolean compilerDebug;
    boolean compilerOptimize;
    boolean nocompile;
    boolean keepGenerated;
    boolean status;
    boolean genInterface;
    boolean genStub;
    boolean genTie;
    boolean genServletConfig;
    boolean genService;
    boolean genServiceInterface;
    boolean noEncodedTypes;
    boolean noMultiRefEncoding;
    boolean noValidation;
    boolean noWarn = false;
    boolean explicitServiceContext;
    boolean genWsdl;
    boolean showModel;
    boolean showModelXML;
    boolean printStackTrace;
    boolean noDataBinding;
    boolean doClient;
    boolean doServer;
    boolean importOnly;
    boolean serializeInterfaces;
    boolean searchSchemaForSubtypes;
    boolean useDataHandlerOnly;
    boolean verbose;
    HashMap actions;
    File actionsFile;
    Localizer localizer;
    String sourcePathArg;
    String serializerNameInfix;
    String program;
    OutputStream out;
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;

    public XrpccCompile(OutputStream outputStream, String string) {
        this.out = outputStream;
        this.program = string;
        this.localizer = new Localizer();
        this.actions = new HashMap();
        this.actions.put("remote.interface.generator", new RemoteInterfaceGenerator());
        this.actions.put("remote.interface.impl.generator", new RemoteInterfaceImplGenerator());
        this.actions.put("custom.class.generator", new CustomClassGenerator());
        this.actions.put("soap.object.serializer.generator", new SOAPObjectSerializerGenerator());
        this.actions.put("interface.serializer.generator", new InterfaceSerializerGenerator());
        this.actions.put("soap.object.builder.generator", new SOAPObjectBuilderGenerator());
        this.actions.put("literal.object.serializer.generator", new LiteralObjectSerializerGenerator());
        this.actions.put("stub.generator", new StubGenerator());
        this.actions.put("tie.generator", new TieGenerator());
        this.actions.put("servlet.config.generator", new ServletConfigGenerator());
        this.actions.put("wsdl.generator", new WSDLGenerator());
        this.actions.put("holder.generator", new HolderGenerator());
        this.actions.put("service.interface.generator", new ServiceInterfaceGenerator());
        this.actions.put("service.generator", new ServiceGenerator());
        this.actions.put("serializer.registry.generator", new SerializerRegistryGenerator());
        this.actions.put("custom.exception.generator", new CustomExceptionGenerator());
        this.actions.put("soap.fault.serializer.generator", new SOAPFaultSerializerGenerator());
        this.actions.put("enumeration.generator", new EnumerationGenerator());
        this.actions.put("enumeration.encoder.generator", new EnumerationEncoderGenerator());
        this.actions.put("fault.exception.builder.generator", new FaultExceptionBuilderGenerator());
    }

    public void output(String string) {
        PrintStream printStream = this.out instanceof PrintStream ? (PrintStream)this.out : new PrintStream(this.out, true);
        printStream.println(string);
    }

    public void error(String string) {
        this.output(XrpccCompile.getText(string));
    }

    public void error(String string, String string2) {
        this.output(XrpccCompile.getText(string, string2));
    }

    public void error(String string, String string2, String string3) {
        this.output(XrpccCompile.getText(string, string2, string3));
    }

    public void error(String string, String string2, String string3, String string4) {
        this.output(XrpccCompile.getText(string, string2, string3, string4));
    }

    public void usage() {
        this.error("xrpcc.usage", this.program);
    }

    public synchronized boolean compile(String[] stringArray) {
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        return this.doCompile();
    }

    public File getDestinationDir() {
        return this.destDir;
    }

    public boolean parseArgs(String[] stringArray) {
        int n;
        this.sourcePathArg = null;
        this.classPathString = null;
        this.destDir = null;
        this.sourceDir = null;
        this.configFile = null;
        this.tm = System.currentTimeMillis();
        this.compilerOptimize = false;
        this.compilerDebug = false;
        this.nocompile = false;
        this.keepGenerated = false;
        this.genStub = false;
        this.genService = false;
        this.genTie = false;
        this.genServletConfig = false;
        this.noEncodedTypes = false;
        this.noMultiRefEncoding = false;
        this.actionsFile = null;
        this.serializerNameInfix = null;
        this.serializeInterfaces = false;
        this.verbose = false;
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            if (stringArray[n].equals("")) {
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-g")) {
                this.compilerDebug = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-nowarn")) {
                stringArray[n] = null;
                this.noWarn = true;
                continue;
            }
            if (stringArray[n].equals("-debug")) {
                this.compilerDebug = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                this.verbose = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-version")) {
                this.error("xrpcc.version", "JAX-RPC Reference Implementation", "1.0.1", "R3");
                return false;
            }
            if (stringArray[n].equals("-Xnocompile")) {
                this.nocompile = true;
                this.keepGenerated = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-Xprintstacktrace")) {
                this.printStackTrace = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-Xnodatabinding")) {
                this.noDataBinding = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-Xdatahandleronly")) {
                this.useDataHandlerOnly = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-Xsearchschema")) {
                this.searchSchemaForSubtypes = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-keep") || stringArray[n].equals("-keepgenerated")) {
                this.keepGenerated = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-show")) {
                this.error("xrpcc.option.unsupported", "-show");
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-classpath")) {
                if (n + 1 >= stringArray.length) continue;
                if (this.classPathString != null) {
                    this.error("xrpcc.option.already.seen", "-classpath");
                    this.usage();
                    return false;
                }
                stringArray[n] = null;
                this.classPathString = stringArray[++n];
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-d")) {
                if (n + 1 < stringArray.length) {
                    if (this.destDir != null) {
                        this.error("xrpcc.option.already.seen", "-d");
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.destDir = new File(stringArray[++n]);
                    stringArray[n] = null;
                    if (this.destDir.exists()) continue;
                    this.error("xrpcc.no.such.directory", this.destDir.getPath());
                    this.usage();
                    return false;
                }
                this.error("xrpcc.option.requires.argument", "-d");
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-s")) {
                if (n + 1 < stringArray.length) {
                    if (this.sourceDir != null) {
                        this.error("xrpcc.option.already.seen", "-s");
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.sourceDir = new File(stringArray[++n]);
                    stringArray[n] = null;
                    if (this.sourceDir.exists()) continue;
                    this.error("xrpcc.no.such.directory", this.sourceDir.getPath());
                    this.usage();
                    return false;
                }
                this.error("xrpcc.option.requires.argument", "-s");
                this.usage();
                return false;
            }
            if (stringArray[n].equalsIgnoreCase("-client")) {
                if (this.doServer) {
                    this.error("xrpcc.option.incompatible", stringArray[n]);
                    this.usage();
                    return false;
                }
                stringArray[n] = null;
                this.doClient = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-server")) {
                if (this.doClient) {
                    this.error("xrpcc.option.incompatible", stringArray[n]);
                    this.usage();
                    return false;
                }
                stringArray[n] = null;
                this.doServer = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-both")) {
                if (this.doClient || this.doServer) {
                    this.error("xrpcc.option.incompatible", stringArray[n]);
                    this.usage();
                    return false;
                }
                stringArray[n] = null;
                this.doClient = true;
                this.doServer = true;
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-Ximport")) {
                stringArray[n] = null;
                this.importOnly = true;
                continue;
            }
            if (stringArray[n].startsWith("-Xmodel")) {
                n2 = stringArray[n].indexOf(58);
                if (n2 != -1) {
                    this.modelOutputFilename = stringArray[n].substring(n2 + 1);
                }
                stringArray[n] = null;
                this.showModel = true;
                continue;
            }
            if (stringArray[n].startsWith("-Xxmodel")) {
                n2 = stringArray[n].indexOf(58);
                if (n2 != -1) {
                    this.modelOutputFilenameXML = stringArray[n].substring(n2 + 1);
                    this.showModelXML = true;
                }
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-Xnomultirefs")) {
                stringArray[n] = null;
                this.noMultiRefEncoding = true;
                continue;
            }
            if (stringArray[n].equals("-Xnoencodedtypes")) {
                stringArray[n] = null;
                this.noEncodedTypes = true;
                continue;
            }
            if (stringArray[n].equals("-Xnovalidation")) {
                stringArray[n] = null;
                this.noValidation = true;
                continue;
            }
            if (stringArray[n].equals("-Xexplicitcontext")) {
                stringArray[n] = null;
                this.explicitServiceContext = true;
                continue;
            }
            if (stringArray[n].startsWith("-Xactions")) {
                if (this.actionsFile != null) {
                    this.error("xrpcc.option.already.seen", "-Xactions");
                    this.usage();
                    return false;
                }
                n2 = stringArray[n].indexOf(58);
                if (n2 == -1) {
                    this.error("xrpcc.option.requires.argument", "-Xactions");
                    this.usage();
                    return false;
                }
                this.actionsFile = new File(stringArray[n].substring(n2 + 1));
                stringArray[n] = null;
                if (this.actionsFile.exists()) continue;
                this.error("xrpcc.no.such.file", this.actionsFile.getPath());
                this.usage();
                return false;
            }
            if (stringArray[n].startsWith("-Xserializerinfix")) {
                if (this.serializerNameInfix != null) {
                    this.error("xrpcc.option.already.seen", "-Xserializerinfix");
                    this.usage();
                    return false;
                }
                n2 = stringArray[n].indexOf(58);
                if (n2 == -1) {
                    this.error("xrpcc.option.requires.argument", "-Xserializerinfix");
                    this.usage();
                    return false;
                }
                this.serializerNameInfix = stringArray[n].substring(n2 + 1);
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].startsWith("-Xhttpproxy")) {
                n2 = stringArray[n].indexOf(58);
                if (n2 == -1) {
                    this.error("xrpcc.option.requires.argument", "-Xhttpproxy");
                    this.usage();
                    return false;
                }
                int n3 = stringArray[n].indexOf(58, n2 + 1);
                if (n3 == -1) {
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyHost", stringArray[n].substring(n2 + 1));
                    System.setProperty("proxyPort", "8080");
                } else {
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyHost", stringArray[n].substring(n2 + 1, n3));
                    System.setProperty("proxyPort", stringArray[n].substring(n3 + 1));
                }
                stringArray[n] = null;
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("-XserializeInterfaces")) continue;
            stringArray[n] = null;
            this.serializeInterfaces = true;
        }
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            if (stringArray[n].startsWith("-")) {
                this.error("xrpcc.no.such.option", stringArray[n]);
                this.usage();
                return false;
            }
            if (this.configFile != null) {
                this.error("xrpcc.only.one.configuration.file", stringArray[n]);
                this.usage();
                return false;
            }
            this.configFile = new File(stringArray[n]);
            stringArray[n] = null;
            if (this.configFile.exists()) continue;
            this.error("xrpcc.no.such.file", this.configFile.getPath());
            this.usage();
            return false;
        }
        if (!this.doClient && !this.doServer) {
            this.error("xrpcc.option.mustSpecifyClientOrServer");
            this.usage();
            return false;
        }
        if (this.doClient) {
            this.genStub = true;
            this.genService = true;
            this.genServiceInterface = true;
            this.genInterface = true;
        }
        if (this.doServer) {
            this.genTie = true;
            this.genServletConfig = true;
            this.genWsdl = true;
            this.genInterface = true;
        }
        if (this.importOnly) {
            this.genStub = false;
            this.genTie = false;
            this.genService = false;
            this.genWsdl = false;
            this.genServletConfig = false;
        }
        return true;
    }

    public ProcessorEnvironment getEnv() {
        String string = this.classPathString + File.pathSeparator + System.getProperty("java.class.path");
        ClientProcessorEnvironment clientProcessorEnvironment = new ClientProcessorEnvironment(System.out, string, this);
        int n = clientProcessorEnvironment.getFlags();
        if (!this.noWarn) {
            n |= 2;
        }
        if (this.verbose) {
            n |= 1;
        }
        clientProcessorEnvironment.setFlags(n);
        return clientProcessorEnvironment;
    }

    public boolean doCompile() {
        Object object;
        ProcessorEnvironment processorEnvironment;
        block44: {
            Properties properties = new Properties();
            processorEnvironment = this.getEnv();
            if (this.sourceDir == null) {
                this.sourceDir = this.destDir;
            }
            if (this.nonclassDestDir == null) {
                this.nonclassDestDir = this.destDir;
            }
            properties.setProperty("sourceDirectory", this.sourceDir.getAbsolutePath());
            properties.setProperty("destinationDirectory", this.destDir.getAbsolutePath());
            properties.setProperty("nonclassDestinationDirectory", this.nonclassDestDir.getAbsolutePath());
            properties.setProperty("encodeTypes", this.noEncodedTypes ? "false" : "true");
            properties.setProperty("multiRefEncoding", this.noMultiRefEncoding ? "false" : "true");
            properties.setProperty("validationWSDL", this.noValidation ? "false" : "true");
            properties.setProperty("explicitServiceContext", this.explicitServiceContext ? "true" : "false");
            properties.setProperty("printStackTrace", this.printStackTrace ? "true" : "false");
            properties.setProperty("noDataBinding", this.noDataBinding ? "true" : "false");
            properties.setProperty("serializerInterfaces", this.serializeInterfaces ? "true" : "false");
            properties.setProperty("useDataHandlerOnly", this.useDataHandlerOnly ? "true" : "false");
            properties.setProperty("searchSchemaForSubtypes", this.searchSchemaForSubtypes ? "true" : "false");
            if (this.serializerNameInfix != null) {
                processorEnvironment.getNames().setSerializerNameInfix(this.serializerNameInfix);
            }
            if (this.configFile == null) {
                this.error("xrpcc.configuration.file.not.found");
                this.usage();
                return false;
            }
            String string = XrpccCompile.getText("xrpcc.no.memory");
            String string2 = XrpccCompile.getText("xrpcc.stack.overflow");
            try {
                Serializable serializable;
                ConfigurationParser configurationParser = new ConfigurationParser(processorEnvironment);
                object = configurationParser.parse(new FileInputStream(this.configFile));
                Processor processor = new Processor((Configuration)object, properties);
                if (this.actionsFile != null) {
                    serializable = new Properties();
                    ((Properties)serializable).load(new FileInputStream(this.actionsFile));
                    Enumeration<?> enumeration = ((Properties)serializable).propertyNames();
                    while (enumeration.hasMoreElements()) {
                        Class<?> clazz;
                        String string3 = (String)enumeration.nextElement();
                        String string4 = ((Properties)serializable).getProperty(string3);
                        try {
                            clazz = Class.forName(string4);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.error("xrpcc.invalid.processoraction.class", string4);
                            return false;
                        }
                        Object obj = clazz.newInstance();
                        if (!(obj instanceof ProcessorAction)) {
                            this.error("xrpcc.invalid.processoraction.class", string4);
                            return false;
                        }
                        this.output(XrpccCompile.getText("xrpcc.replacing.action.class", this.actions.get(string3.toLowerCase()).getClass().toString(), obj.getClass().toString()));
                        this.actions.put(string3.toLowerCase(), obj);
                    }
                }
                if (this.importOnly && !(((Configuration)object).getModelInfo() instanceof WSDLModelInfo)) {
                    this.error("xrpcc.option.import.requiresWSDL");
                }
                processor.runModeler();
                if (this.showModel) {
                    if (this.modelOutputFilename == null) {
                        processor.add(new ModelWriter(System.out));
                    } else {
                        serializable = new File(this.modelOutputFilename);
                        if (!((File)serializable).isAbsolute()) {
                            serializable = new File(this.destDir, this.modelOutputFilename);
                        }
                        processor.add(new ModelWriter(new FileOutputStream((File)serializable)));
                    }
                }
                if (this.showModelXML) {
                    serializable = new File(this.modelOutputFilenameXML);
                    if (!((File)serializable).isAbsolute()) {
                        serializable = new File(this.destDir, this.modelOutputFilenameXML);
                    }
                    processor.add(new XMLModelWriter((File)serializable));
                }
                if (this.genServiceInterface) {
                    processor.add((ProcessorAction)this.actions.get("service.interface.generator"));
                }
                if (this.genService) {
                    processor.add((ProcessorAction)this.actions.get("service.generator"));
                    processor.add((ProcessorAction)this.actions.get("serializer.registry.generator"));
                }
                if (this.genInterface && !(((Configuration)object).getModelInfo() instanceof RmiModelInfo)) {
                    processor.add((ProcessorAction)this.actions.get("remote.interface.generator"));
                    processor.add((ProcessorAction)this.actions.get("remote.interface.impl.generator"));
                }
                if (this.genStub || this.genTie) {
                    processor.add((ProcessorAction)this.actions.get("enumeration.generator"));
                    processor.add((ProcessorAction)this.actions.get("enumeration.encoder.generator"));
                    processor.add((ProcessorAction)this.actions.get("holder.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.class.generator"));
                    processor.add((ProcessorAction)this.actions.get("soap.object.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("interface.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("soap.object.builder.generator"));
                    processor.add((ProcessorAction)this.actions.get("literal.object.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.exception.generator"));
                    processor.add((ProcessorAction)this.actions.get("soap.fault.serializer.generator"));
                    processor.add((ProcessorAction)this.actions.get("fault.exception.builder.generator"));
                } else if (this.importOnly) {
                    processor.add((ProcessorAction)this.actions.get("enumeration.generator"));
                    processor.add((ProcessorAction)this.actions.get("holder.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.class.generator"));
                    processor.add((ProcessorAction)this.actions.get("custom.exception.generator"));
                }
                if (this.genStub) {
                    processor.add((ProcessorAction)this.actions.get("stub.generator"));
                }
                if (this.genTie && !this.genService) {
                    processor.add((ProcessorAction)this.actions.get("serializer.registry.generator"));
                }
                if (this.genTie) {
                    processor.add((ProcessorAction)this.actions.get("tie.generator"));
                }
                if (this.genServletConfig) {
                    processor.add((ProcessorAction)this.actions.get("servlet.config.generator"));
                }
                if (this.genWsdl && !(((Configuration)object).getModelInfo() instanceof WSDLModelInfo)) {
                    processor.add((ProcessorAction)this.actions.get("wsdl.generator"));
                }
                processor.runActions();
                if (!this.nocompile && processorEnvironment.getErrorCount() == 0) {
                    this.compileGeneratedClasses(processorEnvironment);
                }
            }
            catch (ConfigurationException configurationException) {
                this.onError(configurationException);
                return false;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.output(string);
                return false;
            }
            catch (StackOverflowError stackOverflowError) {
                if (this.printStackTrace) {
                    processorEnvironment.printStackTrace(stackOverflowError);
                }
                this.output(string2);
                return false;
            }
            catch (Error error) {
                if (processorEnvironment.getErrorCount() == 0) {
                    processorEnvironment.printStackTrace(error);
                    this.error("xrpcc.error", error.getMessage());
                }
            }
            catch (Exception exception) {
                if (processorEnvironment.getErrorCount() != 0) break block44;
                this.output(exception.getMessage());
                processorEnvironment.printStackTrace(exception);
                this.error("xrpcc.error", exception.getMessage());
            }
        }
        boolean bl = true;
        if (processorEnvironment.getErrorCount() > 0) {
            object = "";
            object = processorEnvironment.getErrorCount() > 1 ? XrpccCompile.getText("xrpcc.errors", processorEnvironment.getErrorCount()) : XrpccCompile.getText("xrpcc.1error");
            if (processorEnvironment.getWarningCount() > 0) {
                object = processorEnvironment.getWarningCount() > 1 ? (String)object + ", " + XrpccCompile.getText("xrpcc.warnings", processorEnvironment.getWarningCount()) : (String)object + ", " + XrpccCompile.getText("xrpcc.1warning");
            }
            this.output((String)object);
            bl = false;
        } else if (processorEnvironment.getErrorCount() > 0) {
            if (processorEnvironment.getErrorCount() > 1) {
                this.output(XrpccCompile.getText("xrpcc.warnings", processorEnvironment.getErrorCount()));
            } else {
                this.output(XrpccCompile.getText("xrpcc.1warning"));
            }
        }
        if (!this.keepGenerated) {
            processorEnvironment.deleteGeneratedFiles();
        }
        if (processorEnvironment.verbose()) {
            this.tm = System.currentTimeMillis() - this.tm;
            this.output(XrpccCompile.getText("xrpcc.done_in", Long.toString(this.tm)));
        }
        processorEnvironment.shutdown();
        return bl;
    }

    protected String createClasspathString() {
        if (this.classPathString == null) {
            this.classPathString = "";
        }
        return this.classPathString + File.pathSeparator + System.getProperty("java.class.path");
    }

    protected void compileGeneratedClasses(ProcessorEnvironment processorEnvironment) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object2 = processorEnvironment.getGeneratedFiles();
        while (object2.hasNext()) {
            object = (File)object2.next();
            if (!((File)object).exists() || !((File)object).getName().endsWith(".java")) continue;
            arrayList.add(((File)object).getAbsolutePath());
        }
        if (arrayList.size() > 0) {
            object2 = this.destDir.getAbsolutePath();
            object = this.createClasspathString();
            String[] stringArray = new String[4 + (this.compilerDebug ? 1 : 0) + (this.compilerOptimize ? 1 : 0) + arrayList.size()];
            stringArray[0] = "-d";
            stringArray[1] = object2;
            stringArray[2] = "-classpath";
            stringArray[3] = object;
            int n = 4;
            if (this.compilerDebug) {
                stringArray[n++] = "-g";
            }
            if (this.compilerOptimize) {
                stringArray[n++] = "-O";
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[n + i] = (String)arrayList.get(i);
            }
            Main main = new Main(this.out, "wscompile-javac");
            boolean bl = main.compile(stringArray);
            if (main.compilationReportedErrors()) {
                this.error("xrpcc.compilationFailed");
            }
        }
    }

    public void onError(Localizable localizable) {
        this.output(XrpccCompile.getText("xrpcc.error", this.localizer.localize(localizable)));
    }

    public void onWarning(Localizable localizable) {
        if (!this.noWarn) {
            this.output(XrpccCompile.getText("xrpcc.warning", this.localizer.localize(localizable)));
        }
    }

    public void onInfo(Localizable localizable) {
        this.output(XrpccCompile.getText("xrpcc.info", this.localizer.localize(localizable)));
    }

    public static String getString(String string) {
        if (!resourcesInitialized) {
            XrpccCompile.initResources();
        }
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("com.sun.xml.rpc.resources.xrpcc");
            resourcesInitialized = true;
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("fatal: missing resource bundle: " + missingResourceException.getClassName());
        }
    }

    public static String getText(String string) {
        String string2 = XrpccCompile.getString(string);
        if (string2 == null) {
            string2 = "no text found: \"" + string + "\"";
        }
        return string2;
    }

    public static String getText(String string, int n) {
        return XrpccCompile.getText(string, Integer.toString(n), null, null);
    }

    public static String getText(String string, String string2) {
        return XrpccCompile.getText(string, string2, null, null);
    }

    public static String getText(String string, String string2, String string3) {
        return XrpccCompile.getText(string, string2, string3, null);
    }

    public static String getText(String string, String string2, String string3, String string4) {
        String string5 = XrpccCompile.getString(string);
        if (string5 == null) {
            string5 = "no text found: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        Object[] objectArray = new String[]{string2 != null ? string2.toString() : "null", string3 != null ? string3.toString() : "null", string4 != null ? string4.toString() : "null"};
        return MessageFormat.format(string5, objectArray);
    }
}

