/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.config.ModelFileModelInfo;
import com.sun.xml.rpc.processor.config.RmiInterfaceInfo;
import com.sun.xml.rpc.processor.config.RmiModelInfo;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.XMLModelWriter;
import com.sun.xml.rpc.tools.wscompile.CompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.localization.Localizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class EndpointCompileTool
extends CompileTool {
    protected EndpointInfo endpointInfo;
    protected WebServicesInfo webServicesInfo;
    protected File targetDirectory;
    protected boolean useModel;
    protected String additionalClasspath;
    private static final String PS = System.getProperty("path.separator");
    private static final char PSCHAR = System.getProperty("path.separator").charAt(0);
    private static final String FS = System.getProperty("file.separator");
    private static final char FSCHAR = System.getProperty("file.separator").charAt(0);

    public EndpointCompileTool(OutputStream outputStream, String string, EndpointInfo endpointInfo, WebServicesInfo webServicesInfo, File file, String string2, ProcessorNotificationListener processorNotificationListener) {
        super(outputStream, string);
        this.endpointInfo = endpointInfo;
        this.webServicesInfo = webServicesInfo;
        this.targetDirectory = file;
        this.additionalClasspath = string2;
        this.listener = processorNotificationListener;
        this.useModel = this.endpointInfo.getModel() != null;
    }

    protected void beforeHook() {
        String string = this.targetDirectory.getAbsolutePath();
        this.userClasspath = string + FS + "WEB-INF" + FS + "classes";
        if (this.additionalClasspath != null && this.additionalClasspath.length() > 0) {
            this.userClasspath = this.userClasspath + PS + this.additionalClasspath;
        }
        this.destDir = new File(this.userClasspath);
        this.nonclassDestDir = new File(string + FS + "WEB-INF");
        if (!this.useModel) {
            this.modelFile = new File(this.makeModelFileName());
        }
        this.serializerInfix = "_" + this.endpointInfo.getName() + "_";
        this.keepGenerated = true;
        this.compilerDebug = false;
        this.compilerOptimize = true;
        super.beforeHook();
    }

    protected void withModelHook() {
        Iterator iterator;
        if ((this.endpointInfo.getClientHandlerChainInfo() != null || this.endpointInfo.getServerHandlerChainInfo() != null) && (iterator = this.processor.getModel().getServices()).hasNext()) {
            Service service = (Service)iterator.next();
            this.endpointInfo.setRuntimeServiceName(service.getName());
            Iterator iterator2 = service.getPorts();
            if (iterator2.hasNext()) {
                Port port = (Port)iterator2.next();
                port.setClientHandlerChainInfo(this.endpointInfo.getClientHandlerChainInfo());
                port.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
            }
        }
    }

    protected void afterHook() {
        if (this.environment.getErrorCount() == 0) {
            this.endpointInfo.setRuntimeModel(this.useModel ? this.endpointInfo.getModel() : this.makeAppRelative(this.modelFile));
            this.endpointInfo.setRuntimeWSDL(this.makeAppRelative(this.findGeneratedFileEndingWith(".wsdl")));
            Iterator iterator = this.processor.getModel().getServices();
            if (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                this.endpointInfo.setRuntimeServiceName(service.getName());
                Iterator iterator2 = service.getPorts();
                if (iterator2.hasNext()) {
                    Port port = (Port)iterator2.next();
                    QName qName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
                    if (qName == null) {
                        qName = port.getName();
                    }
                    this.endpointInfo.setRuntimePortName(qName);
                    JavaInterface javaInterface = port.getJavaInterface();
                    this.endpointInfo.setRuntimeTie(this.environment.getNames().tieFor(javaInterface));
                }
            }
        }
    }

    protected Configuration createConfiguration() throws Exception {
        Configuration configuration = new Configuration(this.environment);
        if (this.useModel) {
            ModelFileModelInfo modelFileModelInfo = new ModelFileModelInfo();
            modelFileModelInfo.setLocation(this.makeAbsolute(this.endpointInfo.getModel()));
            configuration.setModelInfo(modelFileModelInfo);
        } else {
            RmiModelInfo rmiModelInfo = new RmiModelInfo();
            rmiModelInfo.setName(this.endpointInfo.getName());
            rmiModelInfo.setTargetNamespaceURI(this.makeTargetNamespaceURI());
            rmiModelInfo.setTypeNamespaceURI(this.makeTypeNamespaceURI());
            rmiModelInfo.setJavaPackageName(this.makeJavaPackageName());
            RmiInterfaceInfo rmiInterfaceInfo = new RmiInterfaceInfo();
            rmiInterfaceInfo.setName(this.endpointInfo.getInterface());
            rmiInterfaceInfo.setServantName(this.endpointInfo.getImplementation());
            rmiInterfaceInfo.setServerHandlerChainInfo(this.endpointInfo.getServerHandlerChainInfo());
            rmiModelInfo.add(rmiInterfaceInfo);
            configuration.setModelInfo(rmiModelInfo);
        }
        return configuration;
    }

    protected String makeTargetNamespaceURI() {
        String string = this.webServicesInfo.getTargetNamespaceBase();
        if (string.endsWith("/") || string.startsWith("urn:")) {
            return string + this.endpointInfo.getName();
        }
        return string + "/" + this.endpointInfo.getName();
    }

    protected String makeTypeNamespaceURI() {
        String string = this.webServicesInfo.getTypeNamespaceBase();
        if (string.endsWith("/") || string.startsWith("urn:")) {
            return string + this.endpointInfo.getName();
        }
        return string + "/" + this.endpointInfo.getName();
    }

    protected String makeModelFileName() {
        return this.targetDirectory.getAbsolutePath() + FS + "WEB-INF" + FS + this.endpointInfo.getName() + "_model.xml.gz";
    }

    protected String makeJavaPackageName() {
        return "jaxrpc.generated." + this.environment.getNames().validJavaPackageName(this.endpointInfo.getName());
    }

    protected String makeAbsolute(String string) {
        if (string == null) {
            return null;
        }
        return new File(this.targetDirectory.getAbsolutePath() + string).getAbsolutePath();
    }

    protected String makeAppRelative(File file) {
        String string;
        if (file == null) {
            return null;
        }
        String string2 = file.getAbsolutePath();
        if (string2.startsWith(string = this.targetDirectory.getAbsolutePath())) {
            return string2.substring(string.length()).replace(FSCHAR, '/');
        }
        return null;
    }

    protected File findGeneratedFileEndingWith(String string) {
        Iterator iterator = this.environment.getGeneratedFiles();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.getAbsolutePath().endsWith(string)) continue;
            return file;
        }
        return null;
    }

    protected void registerProcessorActions(Processor processor) {
        if (!this.useModel) {
            try {
                processor.add(new XMLModelWriter(this.modelFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        processor.add(this.getAction("enumeration.generator"));
        processor.add(this.getAction("enumeration.encoder.generator"));
        processor.add(this.getAction("holder.generator"));
        processor.add(this.getAction("custom.class.generator"));
        processor.add(this.getAction("soap.object.serializer.generator"));
        processor.add(this.getAction("interface.serializer.generator"));
        processor.add(this.getAction("soap.object.builder.generator"));
        processor.add(this.getAction("literal.object.serializer.generator"));
        processor.add(this.getAction("custom.exception.generator"));
        processor.add(this.getAction("soap.fault.serializer.generator"));
        processor.add(this.getAction("fault.exception.builder.generator"));
        processor.add(this.getAction("serializer.registry.generator"));
        processor.add(this.getAction("tie.generator"));
        processor.add(this.getAction("wsdl.generator"));
    }

    public void onError(Localizable localizable) {
    }

    public void onWarning(Localizable localizable) {
    }

    public void onInfo(Localizable localizable) {
    }
}

