/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wsdeploy;

import com.sun.xml.rpc.processor.ProcessorNotificationListener;
import com.sun.xml.rpc.tools.wsdeploy.DeploymentDescriptorParser;
import com.sun.xml.rpc.tools.wsdeploy.EndpointCompileTool;
import com.sun.xml.rpc.tools.wsdeploy.EndpointInfo;
import com.sun.xml.rpc.tools.wsdeploy.EndpointMappingInfo;
import com.sun.xml.rpc.tools.wsdeploy.WebServicesInfo;
import com.sun.xml.rpc.util.ToolBase;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.xml.NullEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;

public class DeployTool
extends ToolBase
implements ProcessorNotificationListener {
    protected boolean doNothing = false;
    protected boolean verbose = false;
    protected boolean keepTemporaryFiles = false;
    protected File sourceFile;
    protected File destFile;
    protected File tmpdirBase;
    protected File tmpdir;
    protected String userClasspath = null;
    public static final String WEBAPP_DD = "WEB-INF/web.xml";
    public static final String WEBAPP_DD_PROCESSED = "WEB-INF/web-before.xml";
    public static final String JAXRPC_RI_DD = "WEB-INF/jaxrpc-ri.xml";
    public static final String JAXRPC_RI_DD_PROCESSED = "WEB-INF/jaxrpc-ri-before.xml";
    public static final String JAXRPC_RI_RUNTIME = "WEB-INF/jaxrpc-ri-runtime.xml";
    private static final String PS = System.getProperty("path.separator");
    private static final char PSCHAR = System.getProperty("path.separator").charAt(0);
    private static final String FS = System.getProperty("file.separator");
    private static final char FSCHAR = System.getProperty("file.separator").charAt(0);

    public DeployTool(OutputStream outputStream, String string) {
        super(outputStream, string);
    }

    protected void initialize() {
        super.initialize();
    }

    protected boolean parseArguments(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("")) {
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].startsWith("-verbose")) {
                this.verbose = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-version")) {
                this.report(this.getMessage("wsdeploy.version", "JAX-RPC Reference Implementation", "1.0.1", "R3"));
                stringArray[n] = null;
                this.doNothing = true;
                return true;
            }
            if (stringArray[n].equals("-keep")) {
                this.keepTemporaryFiles = true;
                stringArray[n] = null;
                continue;
            }
            if (stringArray[n].equals("-o")) {
                if (n + 1 < stringArray.length) {
                    if (this.destFile != null) {
                        this.onError(this.getMessage("wsdeploy.duplicateOption", "-o"));
                        this.usage();
                        return false;
                    }
                    stringArray[n] = null;
                    this.destFile = new File(stringArray[++n]);
                    stringArray[n] = null;
                    if (!this.destFile.isDirectory() && (this.destFile.getParentFile() == null || this.destFile.getParentFile().exists())) continue;
                    this.onError(this.getMessage("wsdeploy.invalidOutputFile", this.destFile.getPath()));
                    this.usage();
                    return false;
                }
                this.onError(this.getMessage("wsdeploy.missingOptionArgument", "-model"));
                this.usage();
                return false;
            }
            if (stringArray[n].equals("-classpath") || stringArray[n].equals("-cp")) {
                if (n + 1 >= stringArray.length) continue;
                if (this.userClasspath != null) {
                    this.onError(this.getMessage("wsdeploy.duplicateOption", stringArray[n]));
                    this.usage();
                    return false;
                }
                stringArray[n] = null;
                this.userClasspath = stringArray[++n];
                stringArray[n] = null;
                continue;
            }
            if (!stringArray[n].equals("-tmpdir")) continue;
            if (n + 1 < stringArray.length) {
                if (this.tmpdirBase != null) {
                    this.onError(this.getMessage("wsdeploy.duplicateOption", "-tmpdir"));
                    this.usage();
                    return false;
                }
                stringArray[n] = null;
                this.tmpdirBase = new File(stringArray[++n]);
                stringArray[n] = null;
                if (this.tmpdirBase.exists()) continue;
                this.onError(this.getMessage("wsdeploy.noSuchDirectory", this.tmpdirBase.getPath()));
                this.usage();
                return false;
            }
            this.onError(this.getMessage("wsdeploy.missingOptionArgument", "-tmpdir"));
            this.usage();
            return false;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            if (stringArray[n].startsWith("-")) {
                this.onError(this.getMessage("wsdeploy.invalidOption", stringArray[n]));
                this.usage();
                return false;
            }
            if (this.sourceFile != null) {
                this.onError(this.getMessage("wsdeploy.multipleWarFiles", stringArray[n]));
                this.usage();
                return false;
            }
            this.sourceFile = new File(stringArray[n]);
            stringArray[n] = null;
            if (this.sourceFile.exists()) continue;
            this.onError(this.getMessage("wsdeploy.fileNotFound", this.sourceFile.getPath()));
            this.usage();
            return false;
        }
        if (this.sourceFile == null) {
            this.onError(this.getMessage("wsdeploy.missingWarFile"));
            this.usage();
            return false;
        }
        if (this.destFile == null) {
            this.onError(this.getMessage("wsdeploy.missingDestinationWarFile"));
            this.usage();
            return false;
        }
        if (this.sourceFile.equals(this.destFile)) {
            this.onError(this.getMessage("wsdeploy.sourceDestinationConflict"));
            this.usage();
            return false;
        }
        return true;
    }

    protected void usage() {
        this.report(this.getMessage("wsdeploy.usage", this.program));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws Exception {
        if (this.doNothing) {
            return;
        }
        if (this.tmpdirBase == null) {
            this.tmpdirBase = new File(System.getProperty("java.io.tmpdir"));
        }
        try {
            this.tmpdir = this.createTemporaryDirectory();
            if (this.verbose) {
                this.onInfo(this.getMessage("wsdeploy.info.createdTempDir", this.tmpdir.getAbsolutePath()));
            }
            this.expandSourceFile();
            DeploymentDescriptorParser deploymentDescriptorParser = new DeploymentDescriptorParser();
            File file = this.translateSourceAppFileName(JAXRPC_RI_DD);
            WebServicesInfo webServicesInfo = deploymentDescriptorParser.parse(new FileInputStream(file));
            file.renameTo(this.translateSourceAppFileName(JAXRPC_RI_DD_PROCESSED));
            this.process(webServicesInfo);
            this.defineServletsAndListeners(webServicesInfo);
            this.createRuntimeDescriptor(webServicesInfo);
            if (this.destFile != null) {
                this.packageDestinationFile();
            }
            Object var5_4 = null;
            if (this.tmpdir == null || this.keepTemporaryFiles) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.tmpdir == null || this.keepTemporaryFiles) throw throwable;
            DeployTool.removeDirectory(this.tmpdir);
            if (this.verbose) {
                this.onInfo(this.getMessage("wsdeploy.info.removedTempDir", this.tmpdir.getAbsolutePath()));
            }
            this.tmpdir = null;
            throw throwable;
        }
        DeployTool.removeDirectory(this.tmpdir);
        if (this.verbose) {
            this.onInfo(this.getMessage("wsdeploy.info.removedTempDir", this.tmpdir.getAbsolutePath()));
        }
        this.tmpdir = null;
    }

    protected void process(WebServicesInfo webServicesInfo) throws Exception {
        Iterator iterator = webServicesInfo.getEndpoints().values().iterator();
        while (iterator.hasNext()) {
            EndpointInfo endpointInfo = (EndpointInfo)iterator.next();
            this.process(endpointInfo, webServicesInfo);
        }
    }

    protected void process(EndpointInfo endpointInfo, WebServicesInfo webServicesInfo) throws Exception {
        if (this.verbose) {
            this.onInfo(this.getMessage("wsdeploy.info.processingEndpoint", endpointInfo.getName()));
        }
        EndpointCompileTool endpointCompileTool = new EndpointCompileTool(this.out, this.program, endpointInfo, webServicesInfo, this.tmpdir, this.userClasspath, this);
        endpointCompileTool.run();
        endpointInfo.setRuntimeDeployed(endpointCompileTool.wasSuccessful());
    }

    protected void defineServletsAndListeners(WebServicesInfo webServicesInfo) throws Exception {
        Object object;
        Object object2;
        Object object3;
        File file = this.translateSourceAppFileName(WEBAPP_DD);
        File file2 = this.translateSourceAppFileName(WEBAPP_DD_PROCESSED);
        file.renameTo(file2);
        file.delete();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new NullEntityResolver());
        Document document = documentBuilder.parse(new InputSource(new FileInputStream(file2)));
        String string = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
        String string2 = "http://java.sun.com/j2ee/dtds/web-app_2_3.dtd";
        DocumentType documentType = document.getDoctype();
        if (documentType != null && documentType.getPublicId() != null && documentType.getSystemId() != null) {
            string = documentType.getPublicId();
            string2 = documentType.getSystemId();
        }
        String string3 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:transform version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'><xsl:output method='xml' doctype-public='" + string + "' doctype-system='" + string2 + "' encoding='UTF-8'/>" + "<xsl:template match='web-app'>" + "    <web-app>" + "        <xsl:copy-of select='display-name'/>" + "        <xsl:copy-of select='description'/>" + "        <xsl:copy-of select='distributable'/>" + "        <xsl:copy-of select='context-param'/>" + "        <xsl:copy-of select='filter'/>" + "        <xsl:copy-of select='filter-mapping'/>" + "        <xsl:copy-of select='listener'/>" + "        <listener><listener-class>com.sun.xml.rpc.server.http.JAXRPCContextListener</listener-class></listener>" + "        <xsl:copy-of select='servlet'/>";
        Object object4 = webServicesInfo.getEndpoints().values().iterator();
        while (object4.hasNext()) {
            object3 = (EndpointInfo)object4.next();
            if (!((EndpointInfo)object3).isRuntimeDeployed()) continue;
            string3 = string3 + "<servlet><servlet-name>" + ((EndpointInfo)object3).getName() + "</servlet-name>" + "<display-name>" + ((EndpointInfo)object3).getName() + "</display-name>" + "<description>JAX-RPC endpoint - " + ((EndpointInfo)object3).getName() + "</description>" + "<servlet-class>com.sun.xml.rpc.server.http.JAXRPCServlet</servlet-class>" + "<load-on-startup>1</load-on-startup>" + "</servlet>";
        }
        string3 = string3 + "        <xsl:copy-of select='servlet-mapping'/>";
        object4 = webServicesInfo.getEndpoints().values().iterator();
        while (object4.hasNext()) {
            object3 = (EndpointInfo)object4.next();
            if (!((EndpointInfo)object3).isRuntimeDeployed()) continue;
            object2 = null;
            object = (EndpointMappingInfo)webServicesInfo.getEndpointMappings().get(((EndpointInfo)object3).getName());
            object2 = object != null ? ((EndpointMappingInfo)object).getUrlPattern() : webServicesInfo.getUrlPatternBase() + "/" + ((EndpointInfo)object3).getName();
            ((EndpointInfo)object3).setRuntimeUrlPattern((String)object2);
            string3 = string3 + "<servlet-mapping><servlet-name>" + ((EndpointInfo)object3).getName() + "</servlet-name>" + "<url-pattern>" + (String)object2 + "</url-pattern>" + "</servlet-mapping>";
        }
        string3 = string3 + "        <xsl:copy-of select='session-config'/>        <xsl:copy-of select='mime-mapping'/>        <xsl:copy-of select='welcome-file-list'/>        <xsl:copy-of select='error-page'/>        <xsl:copy-of select='taglib'/>        <xsl:copy-of select='resource-env-ref'/>        <xsl:copy-of select='resource-ref'/>        <xsl:copy-of select='security-constraint'/>        <xsl:copy-of select='login-config'/>        <xsl:copy-of select='security-role'/>        <xsl:copy-of select='env-entry'/>        <xsl:copy-of select='ejb-ref'/>        <xsl:copy-of select='ejb-local-ref'/>    </web-app></xsl:template></xsl:transform>";
        object4 = new ByteArrayOutputStream();
        object3 = new OutputStreamWriter((OutputStream)object4, "UTF-8");
        ((Writer)object3).write(string3);
        ((OutputStreamWriter)object3).close();
        object2 = ((ByteArrayOutputStream)object4).toByteArray();
        object = TransformerFactory.newInstance();
        Transformer transformer = ((TransformerFactory)object).newTransformer(new StreamSource(new ByteArrayInputStream((byte[])object2)));
        transformer.transform(new DOMSource(document), new StreamResult(file));
    }

    protected void createRuntimeDescriptor(WebServicesInfo webServicesInfo) throws Exception {
        Object object;
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<endpoints xmlns='http://java.sun.com/xml/ns/jax-rpc/ri/runtime' version='1.0'>\n";
        Object object2 = webServicesInfo.getEndpoints().values().iterator();
        while (object2.hasNext()) {
            object = (EndpointInfo)object2.next();
            if (!((EndpointInfo)object).isRuntimeDeployed()) continue;
            string = string + "  <endpoint\n    name='" + ((EndpointInfo)object).getName() + "'\n" + "    interface='" + ((EndpointInfo)object).getInterface() + "'\n" + "    implementation='" + ((EndpointInfo)object).getImplementation() + "'\n" + "    tie='" + ((EndpointInfo)object).getRuntimeTie() + "'\n" + "    model='" + ((EndpointInfo)object).getRuntimeModel() + "'\n";
            if (((EndpointInfo)object).getRuntimeWSDL() != null) {
                string = string + "    wsdl='" + ((EndpointInfo)object).getRuntimeWSDL() + "'\n";
            }
            string = string + "    service='" + ((EndpointInfo)object).getRuntimeServiceName().toString() + "'\n" + "    port='" + ((EndpointInfo)object).getRuntimePortName().toString() + "'\n" + "    urlpattern='" + ((EndpointInfo)object).getRuntimeUrlPattern().toString() + "'/>\n";
        }
        string = string + "</endpoints>\n";
        object2 = new FileOutputStream(this.translateSourceAppFileName(JAXRPC_RI_RUNTIME));
        object = new OutputStreamWriter((OutputStream)object2, "UTF-8");
        ((Writer)object).write(string);
        ((OutputStreamWriter)object).close();
    }

    protected void expandSourceFile() throws Exception {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.sourceFile));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            File file = this.translateSourceAppFileName(string);
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DeployTool.copyStream(zipInputStream, fileOutputStream);
            fileOutputStream.close();
        }
    }

    protected void packageDestinationFile() throws Exception {
        Object object;
        ArrayList arrayList = new ArrayList();
        this.collectAllFiles(this.tmpdir, arrayList);
        String string = this.tmpdir.getAbsolutePath();
        File file = File.createTempFile("war", "war", this.tmpdirBase);
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (File)object2.next();
            String string2 = ((File)object).getAbsolutePath();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string.length() + 1).replace(FSCHAR, '/');
            jarOutputStream.putNextEntry(new ZipEntry(string3));
            FileInputStream fileInputStream = new FileInputStream((File)object);
            DeployTool.copyStream(fileInputStream, jarOutputStream);
            fileInputStream.close();
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
        object2 = new FileInputStream(file);
        object = new FileOutputStream(this.destFile);
        DeployTool.copyStream((InputStream)object2, (OutputStream)object);
        ((FileOutputStream)object).close();
        ((FileInputStream)object2).close();
        file.delete();
        if (this.verbose) {
            this.onInfo(this.getMessage("wsdeploy.info.createdWarFile", this.destFile.getAbsolutePath()));
        }
    }

    protected File translateSourceAppFileName(String string) {
        if (string.charAt(0) == '/') {
            return this.translateSourceAppFileName(string.substring(1));
        }
        return new File(this.tmpdir, string.replace('/', FSCHAR));
    }

    protected File createTemporaryDirectory() {
        String string;
        String string2 = this.tmpdirBase.getAbsolutePath();
        String string3 = null;
        File file = null;
        do {
            String string4 = Long.toHexString(new Random().nextLong() & 0xFFFFFFL);
            string3 = "jaxrpc-deploy-" + string4;
        } while ((file = new File(string = string2 + FS + string3)).exists());
        file.mkdir();
        return file;
    }

    protected void collectAllFiles(File file, List list) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.collectAllFiles(fileArray[i], list);
                    continue;
                }
                list.add(fileArray[i]);
            }
        }
    }

    protected static void removeDirectory(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    DeployTool.removeDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
            file.delete();
        }
    }

    protected static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        DeployTool.copyStream(fileInputStream, fileOutputStream);
        fileOutputStream.close();
        fileInputStream.close();
    }

    protected static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while (n != -1) {
            try {
                n = inputStream.read(byArray, 0, byArray.length);
            }
            catch (EOFException eOFException) {
                break;
            }
            if (n == -1) continue;
            outputStream.write(byArray, 0, n);
        }
    }

    protected String getGenericErrorMessage() {
        return "wsdeploy.error";
    }

    protected String getResourceBundleName() {
        return "com.sun.xml.rpc.resources.wsdeploy";
    }

    public void onError(Localizable localizable) {
        this.report(this.getMessage("wsdeploy.error", this.localizer.localize(localizable)));
    }

    public void onWarning(Localizable localizable) {
        this.report(this.getMessage("wsdeploy.warning", this.localizer.localize(localizable)));
    }

    public void onInfo(Localizable localizable) {
        this.report(this.getMessage("wsdeploy.info", this.localizer.localize(localizable)));
    }
}

