/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.ant;

import com.sun.xml.rpc.tools.wsdeploy.DeployTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Wsdeploy
extends MatchingTask {
    protected Path compileClasspath = null;
    private boolean keep = false;
    private File tmpDir = null;
    private File outWarFile = null;
    protected boolean verbose = false;
    protected boolean version = false;
    private File warFile = null;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path getCP() {
        return this.getClasspath();
    }

    public void setCP(Path path) {
        this.setClasspath(path);
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(File file) {
        this.tmpDir = file;
    }

    public File getOutWarFile() {
        return this.outWarFile;
    }

    public void setOutWarFile(File file) {
        this.outWarFile = file;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public File getInWarFile() {
        return this.warFile;
    }

    public void setInWarFile(File file) {
        this.warFile = file;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    private Path generateCompileClasspath() {
        Path path = new Path(this.getProject());
        if (this.getClasspath() == null) {
            if (this.getIncludeantruntime()) {
                path.addExisting(Path.systemClasspath);
            }
        } else if (this.getIncludeantruntime()) {
            path.addExisting(this.getClasspath().concatSystemClasspath("last"));
        } else {
            path.addExisting(this.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.getIncludejavaruntime()) {
            path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
            path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
        }
        return path;
    }

    private Commandline setupWsdeployCommand(String[] stringArray) {
        Path path;
        Commandline commandline = new Commandline();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                commandline.createArgument().setValue(stringArray[i]);
            }
        }
        if ((path = this.getClasspath()) != null && !path.toString().equals("")) {
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setPath(path);
        }
        if (this.getKeep()) {
            commandline.createArgument().setValue("-keep");
        }
        if (null != this.getTmpDir() && !this.getTmpDir().equals("")) {
            commandline.createArgument().setValue("-tmpdir");
            commandline.createArgument().setFile(this.getTmpDir());
        }
        if (this.getOutWarFile() != null && !this.getOutWarFile().equals("")) {
            commandline.createArgument().setValue("-o");
            commandline.createArgument().setFile(this.getOutWarFile());
        }
        if (this.getVerbose()) {
            commandline.createArgument().setValue("-verbose");
        }
        if (this.getVersion()) {
            commandline.createArgument().setValue("-version");
        }
        if (this.warFile != null) {
            commandline.createArgument().setValue(this.warFile.toString());
        }
        return commandline;
    }

    private Commandline setupWsdeployCommand() {
        return this.setupWsdeployCommand(null);
    }

    public void execute() throws BuildException {
        if (!(this.getVersion() || this.warFile != null && this.warFile.exists())) {
            throw new BuildException("wsdeploy input war file does not exist!", this.location);
        }
        Commandline commandline = this.setupWsdeployCommand();
        if (this.verbose) {
            this.log("command line: wsdeploy " + commandline.toString());
        }
        LogOutputStream logOutputStream = new LogOutputStream((Task)this, 1);
        try {
            DeployTool deployTool = new DeployTool((OutputStream)logOutputStream, "wsdeploy");
            boolean bl = deployTool.run(commandline.getArguments());
            if (!bl) {
                if (!this.verbose) {
                    this.log("Command invoked: wsdeploy " + commandline.toString());
                }
                throw new BuildException("wsdeploy failed", this.location);
            }
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)exception;
            }
            throw new BuildException("Error starting wsdeploy: ", (Throwable)exception, this.getLocation());
        }
        finally {
            try {
                logOutputStream.close();
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
    }
}

