/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.sp.AttributesEx;
import com.sun.xml.rpc.sp.ParseException;
import com.sun.xml.rpc.sp.Parser2;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.ElementIdStack;
import com.sun.xml.rpc.streaming.RecordedXMLReader;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderBase;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public class XMLReaderImpl
extends XMLReaderBase {
    private int _state = 0;
    private QName _name;
    private InputStream _stream;
    private AttributesAdapter _attributeAdapter;
    private ElementIdStack _elementIds;
    private int _elementId;
    private Parser2 _parser;
    private static final int DOC_END = -1;
    private static final int DOC_START = -2;
    private static final int EMPTY = -3;
    private static final int EXCEPTION = -4;

    public XMLReaderImpl(InputSource inputSource) {
        this._stream = inputSource.getByteStream();
        this._parser = new Parser2(this._stream, true, true);
        this._elementIds = new ElementIdStack();
        this._attributeAdapter = new AttributesAdapter();
    }

    public void close() {
        try {
            this._state = 5;
            this._stream.close();
        }
        catch (IOException iOException) {
            throw new XMLReaderException("xmlreader.ioException", new LocalizableExceptionAdapter(iOException));
        }
    }

    public int getState() {
        return this._state;
    }

    public QName getName() {
        if (this._name == null) {
            this._name = new QName(this.getURI(), this.getLocalName());
        }
        return this._name;
    }

    public String getURI() {
        return this._parser.getCurURI();
    }

    public String getLocalName() {
        return this._parser.getCurName();
    }

    public Attributes getAttributes() {
        this._attributeAdapter.setTarget(this._parser.getAttributes());
        return this._attributeAdapter;
    }

    public String getValue() {
        return this._parser.getCurValue();
    }

    public int getElementId() {
        return this._elementId;
    }

    public int getLineNumber() {
        return this._parser.getLineNumber();
    }

    public String getURI(String string) {
        return this._parser.getNamespaceSupport().getURI(string);
    }

    public Iterator getPrefixes() {
        return this._parser.getNamespaceSupport().getPrefixes();
    }

    public int next() {
        if (this._state == 5) {
            return 5;
        }
        this._name = null;
        try {
            this._state = this._parser.parse();
            if (this._state == -1) {
                this._state = 5;
            }
        }
        catch (ParseException parseException) {
            throw new XMLReaderException("xmlreader.parseException", new LocalizableExceptionAdapter(parseException));
        }
        catch (IOException iOException) {
            throw new XMLReaderException("xmlreader.ioException", new LocalizableExceptionAdapter(iOException));
        }
        switch (this._state) {
            case 1: {
                this._elementId = this._elementIds.pushNext();
                break;
            }
            case 2: {
                this._elementId = this._elementIds.pop();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new XMLReaderException("xmlreader.illegalStateEncountered", Integer.toString(this._state));
            }
        }
        return this._state;
    }

    public XMLReader recordElement() {
        return new RecordedXMLReader(this, this._parser.getNamespaceSupport());
    }

    public void skipElement(int n) {
        while (this._state != 5 && (this._state != 2 || this._elementId != n)) {
            this.next();
        }
    }

    static class AttributesAdapter
    implements Attributes {
        private AttributesEx _attr;
        static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";

        public void setTarget(AttributesEx attributesEx) {
            this._attr = attributesEx;
        }

        public int getLength() {
            return this._attr.getLength();
        }

        public boolean isNamespaceDeclaration(int n) {
            return this._attr.getURI(n) == XMLNS_NAMESPACE_URI;
        }

        public QName getName(int n) {
            return new QName(this.getURI(n), this.getLocalName(n));
        }

        public String getURI(int n) {
            return this._attr.getURI(n);
        }

        public String getLocalName(int n) {
            return this._attr.getLocalName(n);
        }

        public String getPrefix(int n) {
            String string = this._attr.getQName(n);
            if (string == null) {
                return null;
            }
            return XmlUtil.getPrefix(string);
        }

        public String getValue(int n) {
            return this._attr.getValue(n);
        }

        public int getIndex(QName qName) {
            return this._attr.getIndex(qName.getNamespaceURI(), qName.getLocalPart());
        }

        public int getIndex(String string, String string2) {
            return this._attr.getIndex(string, string2);
        }

        public int getIndex(String string) {
            return this._attr.getIndex(string);
        }

        public String getValue(QName qName) {
            return this._attr.getValue(qName.getNamespaceURI(), qName.getLocalPart());
        }

        public String getValue(String string, String string2) {
            return this._attr.getValue(string, string2);
        }

        public String getValue(String string) {
            return this._attr.getValue(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(this.getURI(i) + ":" + this.getLocalName(i) + " = " + this.getValue(i));
            }
            return stringBuffer.toString();
        }
    }
}

