/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;

public class NamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final Iterator EMPTY_ENUMERATION = new ArrayList().iterator();
    private Context[] contexts;
    private Context currentContext;
    private int contextPos;

    public NamespaceSupport() {
        this.reset();
    }

    public NamespaceSupport(NamespaceSupport namespaceSupport) {
        this.contexts = new Context[namespaceSupport.contexts.length];
        this.currentContext = null;
        this.contextPos = namespaceSupport.contextPos;
        Context context = null;
        for (int i = 0; i < namespaceSupport.contexts.length; ++i) {
            Context context2;
            Context context3 = namespaceSupport.contexts[i];
            if (context3 == null) {
                this.contexts[i] = null;
                continue;
            }
            this.contexts[i] = context2 = new Context(context3, context);
            if (namespaceSupport.currentContext == context3) {
                this.currentContext = context2;
            }
            context = context2;
        }
    }

    public void reset() {
        this.contexts = new Context[32];
        this.contextPos = 0;
        this.contexts[this.contextPos] = this.currentContext = new Context();
        this.currentContext.declarePrefix("xml", XMLNS);
    }

    public void pushContext() {
        int n = this.contexts.length;
        ++this.contextPos;
        if (this.contextPos >= n) {
            Context[] contextArray = new Context[n * 2];
            System.arraycopy(this.contexts, 0, contextArray, 0, n);
            n *= 2;
            this.contexts = contextArray;
        }
        this.currentContext = this.contexts[this.contextPos];
        if (this.currentContext == null) {
            this.contexts[this.contextPos] = this.currentContext = new Context();
        }
        if (this.contextPos > 0) {
            this.currentContext.setParent(this.contexts[this.contextPos - 1]);
        }
    }

    public void popContext() {
        --this.contextPos;
        if (this.contextPos < 0) {
            throw new EmptyStackException();
        }
        this.currentContext = this.contexts[this.contextPos];
    }

    public void slideContextUp() {
        --this.contextPos;
        this.currentContext = this.contexts[this.contextPos];
    }

    public void slideContextDown() {
        ++this.contextPos;
        if (this.contexts[this.contextPos] == null) {
            this.contexts[this.contextPos] = this.contexts[this.contextPos - 1];
        }
        this.currentContext = this.contexts[this.contextPos];
    }

    public boolean declarePrefix(String string, String string2) {
        if (string.equals("xml") || string.equals("xmlns")) {
            return false;
        }
        this.currentContext.declarePrefix(string, string2);
        return true;
    }

    public String[] processName(String string, String[] stringArray, boolean bl) {
        String[] stringArray2 = this.currentContext.processName(string, bl);
        if (stringArray2 == null) {
            return null;
        }
        stringArray[0] = stringArray2[0];
        stringArray[1] = stringArray2[1];
        stringArray[2] = stringArray2[2];
        return stringArray;
    }

    public String getURI(String string) {
        return this.currentContext.getURI(string);
    }

    public Iterator getPrefixes() {
        return this.currentContext.getPrefixes();
    }

    public String getPrefix(String string) {
        return this.currentContext.getPrefix(string);
    }

    public Iterator getPrefixes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.getPrefixes();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(this.getURI(string2))) continue;
            arrayList.add(string2);
        }
        return arrayList.iterator();
    }

    public Iterator getDeclaredPrefixes() {
        return this.currentContext.getDeclaredPrefixes();
    }

    static final class Context {
        HashMap prefixTable;
        HashMap uriTable;
        HashMap elementNameTable;
        HashMap attributeNameTable;
        String defaultNS = null;
        private ArrayList declarations = null;
        private boolean tablesDirty = false;
        private Context parent = null;

        Context() {
            this.copyTables();
        }

        Context(Context context, Context context2) {
            if (context == null) {
                this.copyTables();
                return;
            }
            if (context2 != null && !context.tablesDirty) {
                this.prefixTable = context.prefixTable == context.parent.prefixTable ? context2.prefixTable : (HashMap)context.prefixTable.clone();
                this.uriTable = context.uriTable == context.parent.uriTable ? context2.uriTable : (HashMap)context.uriTable.clone();
                this.elementNameTable = context.elementNameTable == context.parent.elementNameTable ? context2.elementNameTable : (HashMap)context.elementNameTable.clone();
                this.attributeNameTable = context.attributeNameTable == context.parent.attributeNameTable ? context2.attributeNameTable : (HashMap)context.attributeNameTable.clone();
                this.defaultNS = context.defaultNS == context.parent.defaultNS ? context2.defaultNS : context.defaultNS;
            } else {
                this.prefixTable = (HashMap)context.prefixTable.clone();
                this.uriTable = (HashMap)context.uriTable.clone();
                this.elementNameTable = (HashMap)context.elementNameTable.clone();
                this.attributeNameTable = (HashMap)context.attributeNameTable.clone();
                this.defaultNS = context.defaultNS;
            }
            this.tablesDirty = context.tablesDirty;
            this.parent = context2;
            this.declarations = context.declarations == null ? null : (ArrayList)context.declarations.clone();
        }

        void setParent(Context context) {
            this.parent = context;
            this.declarations = null;
            this.prefixTable = context.prefixTable;
            this.uriTable = context.uriTable;
            this.elementNameTable = context.elementNameTable;
            this.attributeNameTable = context.attributeNameTable;
            this.defaultNS = context.defaultNS;
            this.tablesDirty = false;
        }

        void declarePrefix(String string, String string2) {
            if (!this.tablesDirty) {
                this.copyTables();
            }
            if (this.declarations == null) {
                this.declarations = new ArrayList();
            }
            string = string.intern();
            string2 = string2.intern();
            if ("".equals(string)) {
                this.defaultNS = "".equals(string2) ? null : string2;
            } else {
                this.prefixTable.put(string, string2);
                this.uriTable.put(string2, string);
            }
            this.declarations.add(string);
        }

        String[] processName(String string, boolean bl) {
            HashMap hashMap = bl ? this.elementNameTable : this.attributeNameTable;
            String[] stringArray = (String[])hashMap.get(string);
            if (stringArray != null) {
                return stringArray;
            }
            stringArray = new String[3];
            int n = string.indexOf(58);
            if (n == -1) {
                stringArray[0] = bl || this.defaultNS == null ? "" : this.defaultNS;
                stringArray[1] = string.intern();
                stringArray[2] = stringArray[1];
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = "".equals(string2) ? this.defaultNS : (String)this.prefixTable.get(string2);
                if (string4 == null) {
                    return null;
                }
                stringArray[0] = string4;
                stringArray[1] = string3.intern();
                stringArray[2] = string.intern();
            }
            hashMap.put(stringArray[2], stringArray);
            this.tablesDirty = true;
            return stringArray;
        }

        String getURI(String string) {
            if ("".equals(string)) {
                return this.defaultNS;
            }
            if (this.prefixTable == null) {
                return null;
            }
            return (String)this.prefixTable.get(string);
        }

        String getPrefix(String string) {
            if (this.uriTable == null) {
                return null;
            }
            return (String)this.uriTable.get(string);
        }

        Iterator getDeclaredPrefixes() {
            if (this.declarations == null) {
                return EMPTY_ENUMERATION;
            }
            return this.declarations.iterator();
        }

        Iterator getPrefixes() {
            if (this.prefixTable == null) {
                return EMPTY_ENUMERATION;
            }
            return this.prefixTable.keySet().iterator();
        }

        private void copyTables() {
            this.prefixTable = this.prefixTable != null ? (HashMap)this.prefixTable.clone() : new HashMap();
            this.uriTable = this.uriTable != null ? (HashMap)this.uriTable.clone() : new HashMap();
            this.elementNameTable = new HashMap();
            this.attributeNameTable = new HashMap();
            this.tablesDirty = true;
        }
    }
}

