/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.EndOfInputException;
import com.sun.xml.rpc.sp.ParseException;
import com.sun.xml.rpc.sp.Parser;
import com.sun.xml.rpc.sp.XmlChars;
import com.sun.xml.rpc.sp.XmlReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

final class InputEntity
implements Locator {
    private int start;
    private int finish;
    private char[] buf;
    private int lineNumber = 1;
    private boolean returnedFirstHalf = false;
    private boolean maybeInCRLF = false;
    private String name;
    private InputEntity next;
    private InputSource input;
    private Reader reader;
    private boolean isClosed;
    private Locale locale;
    private StringBuffer rememberedText;
    private int startRemember;
    private boolean isPE;
    private static final int BUFSIZ = 2049;
    private static final char[] newline = new char[]{'\n'};
    private int end = -1;

    public static InputEntity getInputEntity(Locale locale) {
        InputEntity inputEntity = new InputEntity();
        inputEntity.locale = locale;
        return inputEntity;
    }

    private InputEntity() {
    }

    public boolean isInternal() {
        return this.reader == null;
    }

    public boolean isDocument() {
        return this.next == null;
    }

    public boolean isParameterEntity() {
        return this.isPE;
    }

    public String getName() {
        return this.name;
    }

    public void init(InputSource inputSource, String string, InputEntity inputEntity, boolean bl) throws ParseException, IOException {
        this.input = inputSource;
        this.isPE = bl;
        this.reader = inputSource.getCharacterStream();
        if (this.reader == null) {
            InputStream inputStream = inputSource.getByteStream();
            this.reader = inputStream == null ? XmlReader.createReader(new URL(inputSource.getSystemId()).openStream()) : (inputSource.getEncoding() != null ? XmlReader.createReader(inputSource.getByteStream(), inputSource.getEncoding()) : XmlReader.createReader(inputSource.getByteStream()));
        }
        this.next = inputEntity;
        this.buf = new char[2049];
        this.name = string;
        this.checkRecursion(inputEntity);
    }

    public void init(char[] cArray, String string, InputEntity inputEntity, boolean bl) throws ParseException {
        this.next = inputEntity;
        this.buf = cArray;
        this.finish = cArray.length;
        this.name = string;
        this.isPE = bl;
        this.checkRecursion(inputEntity);
    }

    private void checkRecursion(InputEntity inputEntity) throws ParseException {
        if (inputEntity == null) {
            return;
        }
        inputEntity = inputEntity.next;
        while (inputEntity != null) {
            if (inputEntity.name != null && inputEntity.name.equals(this.name)) {
                this.fatal("P-069", new Object[]{this.name});
            }
            inputEntity = inputEntity.next;
        }
    }

    public InputEntity pop() throws ParseException, IOException {
        this.close();
        return this.next;
    }

    public boolean isEOF() throws ParseException, IOException {
        if (this.start >= this.finish) {
            this.fillbuf();
            return this.start >= this.finish;
        }
        return false;
    }

    public String getEncoding() {
        if (this.reader == null) {
            return null;
        }
        if (this.reader instanceof XmlReader) {
            return ((XmlReader)this.reader).getEncoding();
        }
        if (this.reader instanceof InputStreamReader) {
            return ((InputStreamReader)this.reader).getEncoding();
        }
        return null;
    }

    public char getNameChar() throws ParseException, IOException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c;
            if (XmlChars.isNameChar(c = this.buf[this.start++])) {
                return c;
            }
            --this.start;
        }
        return '\u0000';
    }

    public char getc() throws ParseException, IOException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            char c = this.buf[this.start++];
            if (this.returnedFirstHalf) {
                if (c >= '\udc00' && c <= '\udfff') {
                    this.returnedFirstHalf = false;
                    return c;
                }
                this.fatal("P-070", new Object[]{Integer.toHexString(c)});
            }
            if (c >= ' ' && c <= '\ud7ff' || c == '\t' || c >= '\ue000' && c <= '\ufffd') {
                return c;
            }
            if (c == '\r' && !this.isInternal()) {
                this.maybeInCRLF = true;
                c = this.getc();
                if (c != '\n') {
                    this.ungetc();
                }
                this.maybeInCRLF = false;
                ++this.lineNumber;
                return '\n';
            }
            if (c == '\n' || c == '\r') {
                if (!this.isInternal() && !this.maybeInCRLF) {
                    ++this.lineNumber;
                }
                return c;
            }
            if (c >= '\ud800' && c < '\udc00') {
                this.returnedFirstHalf = true;
                return c;
            }
            this.fatal("P-071", new Object[]{Integer.toHexString(c)});
        }
        throw new EndOfInputException();
    }

    public boolean peekc(char c) throws ParseException, IOException {
        if (this.finish <= this.start) {
            this.fillbuf();
        }
        if (this.finish > this.start) {
            if (this.buf[this.start] == c) {
                ++this.start;
                return true;
            }
            return false;
        }
        return false;
    }

    public void ungetc() {
        if (this.start == 0) {
            throw new InternalError("ungetc");
        }
        --this.start;
        if (this.buf[this.start] == '\n' || this.buf[this.start] == '\r') {
            if (!this.isInternal()) {
                --this.lineNumber;
            }
        } else if (this.returnedFirstHalf) {
            this.returnedFirstHalf = false;
        }
    }

    public boolean maybeWhitespace() throws ParseException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            char c;
            if (this.finish <= this.start) {
                this.fillbuf();
            }
            if (this.finish <= this.start) {
                return bl;
            }
            if ((c = this.buf[this.start++]) != ' ' && c != '\t' && c != '\n' && c != '\r') break;
            bl = true;
            if (c != '\n' && c != '\r' || this.isInternal()) continue;
            if (c != '\n' || !bl2) {
                ++this.lineNumber;
                bl2 = false;
            }
            if (c != '\r') continue;
            bl2 = true;
        }
        --this.start;
        return bl;
    }

    String getParsedContent(boolean bl) throws ParseException, IOException {
        if (!bl) {
            int n = this.start;
            if (this.parsedContent()) {
                if (this.end == -1) {
                    this.end = this.start;
                }
                return new String(this.buf, n, this.start - n);
            }
            return null;
        }
        int n = this.start;
        StringBuffer stringBuffer = null;
        while (this.parsedContent()) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (this.end == -1) {
                this.end = this.start;
            }
            stringBuffer.append(this.buf, n, this.end - n);
            this.end = -1;
            if (!bl || this.isEOF()) break;
            n = this.start;
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parsedContent() throws ParseException, IOException {
        int n;
        int n2 = n = this.start;
        boolean bl = false;
        while (true) {
            block25: {
                char c;
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    if (n < this.finish) break block26;
                                    if (n > n2) {
                                        bl = true;
                                        this.start = n;
                                        return bl;
                                    }
                                    if (this.isEOF()) {
                                        return bl;
                                    }
                                    n2 = this.start;
                                    n = n2 - 1;
                                    break block25;
                                }
                                c = this.buf[n];
                                if (c > ']' && c <= '\ud7ff' || c < '&' && c >= ' ' || c > '<' && c < ']' || c > '&' && c < '<' || c == '\t' || c >= '\ue000' && c <= '\ufffd') break block25;
                                if (c == '<' || c == '&') break;
                                if (c != '\n') break block27;
                                if (!this.isInternal()) {
                                    ++this.lineNumber;
                                }
                                break block25;
                            }
                            if (c != '\r') break block28;
                            if (!this.isInternal()) {
                                bl = true;
                                ++this.lineNumber;
                                if (this.finish > n + 1) {
                                    if (this.buf[n + 1] == '\n') {
                                        this.buf[++n - 1] = 10;
                                        this.end = n;
                                    } else {
                                        this.buf[n] = 10;
                                    }
                                } else {
                                    this.buf[n] = 10;
                                }
                                n2 = this.start = n + 1;
                                return bl;
                            }
                            break block25;
                        }
                        if (c != ']') break block29;
                        switch (this.finish - n) {
                            case 2: {
                                if (this.buf[n + 1] != ']') break;
                            }
                            case 1: {
                                if (this.reader != null) {
                                    if (this.isClosed) break;
                                    if (n == n2) {
                                        throw new InternalError("fillbuf");
                                    }
                                    if (--n > n2) {
                                        bl = true;
                                        this.start = n;
                                        return bl;
                                    }
                                    this.fillbuf();
                                    n2 = n = this.start;
                                    break;
                                }
                                break block25;
                            }
                            default: {
                                if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                                    this.fatal("P-072", null);
                                    break;
                                }
                                break block25;
                            }
                        }
                        break block25;
                    }
                    if (c < '\ud800' || c > '\udfff') break block30;
                    if (n + 1 >= this.finish) {
                        if (n > n2) {
                            bl = true;
                            this.end = n;
                            this.start = n + 1;
                            return bl;
                        }
                        if (this.isEOF()) {
                            this.fatal("P-081", new Object[]{Integer.toHexString(c)});
                        }
                        n = n2 = this.start;
                        break block25;
                    } else if (this.checkSurrogatePair(n)) {
                        ++n;
                        break block25;
                    } else {
                        --n;
                        break;
                    }
                }
                this.fatal("P-071", new Object[]{Integer.toHexString(c)});
            }
            ++n;
        }
        if (n == n2) {
            return bl;
        }
        this.start = n;
        return true;
    }

    String getUnparsedContent(boolean bl, String string) throws ParseException, IOException {
        int n = this.start;
        Object var4_4 = null;
        if (!this.unparsedContent(bl, string)) {
            return null;
        }
        return new String(this.buf, n + 8, this.start - 11 - n);
    }

    public boolean unparsedContent(boolean bl, String string) throws ParseException, IOException {
        int n;
        if (!this.peek("![CDATA[", null)) {
            return false;
        }
        while (true) {
            boolean bl2 = false;
            boolean bl3 = bl;
            for (n = this.start; n < this.finish; ++n) {
                char c = this.buf[n];
                if (!XmlChars.isChar(c)) {
                    bl3 = false;
                    if (c >= '\ud800' && c <= '\udfff') {
                        if (this.checkSurrogatePair(n)) {
                            ++n;
                            continue;
                        }
                        --n;
                        break;
                    }
                    this.fatal("P-071", new Object[]{Integer.toHexString(this.buf[n])});
                }
                if (c == '\n') {
                    if (this.isInternal()) continue;
                    ++this.lineNumber;
                    continue;
                }
                if (c == '\r') {
                    if (this.isInternal()) continue;
                    if (bl3 && string != null) {
                        this.fatal(Parser.messages.getMessage(this.locale, string));
                    }
                    ++this.lineNumber;
                    if (this.finish > n + 1 && this.buf[n + 1] == '\n') {
                        ++n;
                    }
                    this.start = n + 1;
                    continue;
                }
                if (c != ']') {
                    if (c == ' ' || c == '\t') continue;
                    bl3 = false;
                    continue;
                }
                if (n + 2 >= this.finish) break;
                if (this.buf[n + 1] == ']' && this.buf[n + 2] == '>') {
                    bl2 = true;
                    break;
                }
                bl3 = false;
            }
            if (bl3 && string != null) {
                this.fatal(Parser.messages.getMessage(this.locale, string));
            }
            if (bl2) break;
            this.start = n;
            if (!this.isEOF()) continue;
            this.fatal("P-073", null);
        }
        this.start = n + 3;
        return true;
    }

    private boolean checkSurrogatePair(int n) throws ParseException {
        if (n + 1 >= this.finish) {
            return false;
        }
        char c = this.buf[n++];
        char c2 = this.buf[n];
        if (c >= '\ud800' && c < '\udc00' && c2 >= '\udc00' && c2 <= '\udfff') {
            return true;
        }
        this.fatal("P-074", new Object[]{Integer.toHexString(c & 0xFFFF), Integer.toHexString(c2 & 0xFFFF)});
        return false;
    }

    public boolean ignorableWhitespace() throws ParseException, IOException {
        boolean bl = false;
        int n = this.start;
        block5: while (true) {
            if (this.finish <= this.start) {
                this.fillbuf();
                n = this.start;
            }
            if (this.finish <= this.start) {
                return bl;
            }
            char c = this.buf[this.start++];
            switch (c) {
                case '\n': {
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                }
                case '\t': 
                case ' ': {
                    bl = true;
                    continue block5;
                }
                case '\r': {
                    bl = true;
                    if (!this.isInternal()) {
                        ++this.lineNumber;
                    }
                    if (this.start >= this.finish || this.buf[this.start] == '\n') {
                        // empty if block
                    }
                    n = ++this.start;
                    continue block5;
                }
            }
            break;
        }
        this.ungetc();
        return bl;
    }

    public boolean peek(String string, char[] cArray) throws ParseException, IOException {
        int n;
        int n2 = cArray != null ? cArray.length : string.length();
        if (this.finish <= this.start || this.finish - this.start < n2) {
            this.fillbuf();
        }
        if (this.finish <= this.start) {
            return false;
        }
        if (cArray != null) {
            for (n = 0; n < n2 && this.start + n < this.finish; ++n) {
                if (this.buf[this.start + n] == cArray[n]) continue;
                return false;
            }
        } else {
            for (n = 0; n < n2 && this.start + n < this.finish; ++n) {
                if (this.buf[this.start + n] == string.charAt(n)) continue;
                return false;
            }
        }
        if (n < n2) {
            if (this.reader == null || this.isClosed) {
                return false;
            }
            if (n2 > this.buf.length) {
                this.fatal("P-077", new Object[]{new Integer(this.buf.length)});
            }
            this.fillbuf();
            return this.peek(string, cArray);
        }
        this.start += n2;
        return true;
    }

    public void startRemembering() {
        if (this.startRemember != 0) {
            throw new InternalError();
        }
        this.startRemember = this.start;
    }

    public String rememberText() {
        String string;
        if (this.rememberedText != null) {
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
            string = this.rememberedText.toString();
        } else {
            string = new String(this.buf, this.startRemember, this.start - this.startRemember);
        }
        this.startRemember = 0;
        this.rememberedText = null;
        return string;
    }

    private Locator getLocator() {
        InputEntity inputEntity = this;
        while (inputEntity != null && inputEntity.input == null) {
            inputEntity = inputEntity.next;
        }
        return inputEntity == null ? this : inputEntity;
    }

    public String getPublicId() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.input.getPublicId();
        }
        return locator.getPublicId();
    }

    public String getSystemId() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.input.getSystemId();
        }
        return locator.getSystemId();
    }

    public int getLineNumber() {
        Locator locator = this.getLocator();
        if (locator == this) {
            return this.lineNumber;
        }
        return locator.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    private void fillbuf() throws ParseException, IOException {
        boolean bl;
        if (this.reader == null || this.isClosed) {
            return;
        }
        if (this.startRemember != 0) {
            if (this.rememberedText == null) {
                this.rememberedText = new StringBuffer(this.buf.length);
            }
            this.rememberedText.append(this.buf, this.startRemember, this.start - this.startRemember);
        }
        boolean bl2 = bl = this.finish > 0 && this.start > 0;
        if (bl) {
            --this.start;
        }
        int n = this.finish - this.start;
        System.arraycopy(this.buf, this.start, this.buf, 0, n);
        this.start = 0;
        this.finish = n;
        try {
            n = this.buf.length - n;
            n = this.reader.read(this.buf, this.finish, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.fatal("P-075", new Object[]{unsupportedEncodingException.getMessage()});
        }
        catch (CharConversionException charConversionException) {
            this.fatal("P-076", new Object[]{charConversionException.getMessage()});
        }
        if (n >= 0) {
            this.finish += n;
        } else {
            this.close();
        }
        if (bl) {
            ++this.start;
        }
        if (this.startRemember != 0) {
            this.startRemember = 1;
        }
    }

    public void close() {
        try {
            if (this.reader != null && !this.isClosed) {
                this.reader.close();
            }
            this.isClosed = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void fatal(String string) throws ParseException {
        ParseException parseException = new ParseException(string, this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        this.close();
        throw parseException;
    }

    private void fatal(String string, Object[] objectArray) throws ParseException {
        this.fatal(Parser.messages.getMessage(this.locale, string, objectArray));
    }
}

