/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.ContentModel;
import com.sun.xml.rpc.sp.EndOfInputException;

class ContentModelState {
    private ContentModel model;
    private boolean sawOne;
    private ContentModelState next;

    ContentModelState(ContentModel contentModel) {
        this(contentModel, null);
    }

    private ContentModelState(Object object, ContentModelState contentModelState) {
        this.model = (ContentModel)object;
        this.next = contentModelState;
        this.sawOne = false;
    }

    boolean terminate() {
        switch (this.model.type) {
            case '+': {
                if (!this.sawOne && !this.model.empty()) {
                    return false;
                }
            }
            case '*': 
            case '?': {
                return this.next == null || this.next.terminate();
            }
            case '|': {
                return this.model.empty() && (this.next == null || this.next.terminate());
            }
            case ',': {
                ContentModel contentModel = this.model;
                while (contentModel != null && contentModel.empty()) {
                    contentModel = contentModel.next;
                }
                if (contentModel != null) {
                    return false;
                }
                return this.next == null || this.next.terminate();
            }
            case '\u0000': {
                return false;
            }
        }
        throw new InternalError();
    }

    ContentModelState advance(String string) throws EndOfInputException {
        switch (this.model.type) {
            case '*': 
            case '+': {
                if (this.model.first(string)) {
                    this.sawOne = true;
                    if (this.model.content instanceof String) {
                        return this;
                    }
                    return new ContentModelState(this.model.content, this).advance(string);
                }
                if (this.model.type != '*' && !this.sawOne || this.next == null) break;
                return this.next.advance(string);
            }
            case '?': {
                if (this.model.first(string)) {
                    if (this.model.content instanceof String) {
                        return this.next;
                    }
                    return new ContentModelState(this.model.content, this.next).advance(string);
                }
                if (this.next == null) break;
                return this.next.advance(string);
            }
            case '|': {
                ContentModel contentModel = this.model;
                while (contentModel != null) {
                    if (contentModel.content instanceof String) {
                        if (string == contentModel.content) {
                            return this.next;
                        }
                    } else if (((ContentModel)contentModel.content).first(string)) {
                        return new ContentModelState(contentModel.content, this.next).advance(string);
                    }
                    contentModel = contentModel.next;
                }
                if (!this.model.empty() || this.next == null) break;
                return this.next.advance(string);
            }
            case ',': {
                if (this.model.first(string)) {
                    ContentModelState contentModelState;
                    if (this.model.type == '\u0000') {
                        return this.next;
                    }
                    if (this.model.next == null) {
                        contentModelState = new ContentModelState(this.model.content, this.next);
                    } else {
                        contentModelState = new ContentModelState(this.model.content, this);
                        this.model = this.model.next;
                    }
                    return contentModelState.advance(string);
                }
                if (!this.model.empty() || this.next == null) break;
                return this.next.advance(string);
            }
            case '\u0000': {
                if (this.model.content != string) break;
                return this.next;
            }
        }
        throw new EndOfInputException();
    }
}

