/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.sp;

import com.sun.xml.rpc.sp.AttributesEx;
import org.xml.sax.Attributes;

final class AttributesExImpl
implements AttributesEx {
    int length;
    String[] data;
    private String idAttributeName;
    private static final String SPECIFIED_TRUE = "";

    public AttributesExImpl() {
        this.length = 0;
        this.data = null;
    }

    public AttributesExImpl(Attributes attributes) {
        this.setAttributes(attributes);
    }

    public int getLength() {
        return this.length;
    }

    public String getURI(int n) {
        if (n >= 0 && n < this.length) {
            return this.data[n * 7];
        }
        return null;
    }

    public String getLocalName(int n) {
        if (n >= 0 && n < this.length) {
            return this.data[n * 7 + 1];
        }
        return null;
    }

    public String getQName(int n) {
        if (n >= 0 && n < this.length) {
            return this.data[n * 7 + 2];
        }
        return null;
    }

    public String getType(int n) {
        if (n >= 0 && n < this.length) {
            return this.data[n * 7 + 3];
        }
        return null;
    }

    public String getValue(int n) {
        if (n >= 0 && n < this.length) {
            return this.data[n * 7 + 4];
        }
        return null;
    }

    public String getDefault(int n) {
        if (n >= 0 && n < this.length) {
            return this.data[n * 7 + 5];
        }
        return null;
    }

    public boolean isSpecified(int n) {
        if (n >= 0 && n < this.length) {
            return this.data[n * 7 + 6] == SPECIFIED_TRUE;
        }
        return false;
    }

    public int getIndex(String string, String string2) {
        int n = this.length * 7;
        for (int i = 0; i < n; i += 7) {
            if (!this.data[i].equals(string) || !this.data[i + 1].equals(string2)) continue;
            return i / 7;
        }
        return -1;
    }

    public int getIndex(String string) {
        int n = this.length * 7;
        for (int i = 0; i < n; i += 7) {
            if (!this.data[i + 2].equals(string)) continue;
            return i / 7;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        int n = this.length * 7;
        for (int i = 0; i < n; i += 7) {
            if (!this.data[i].equals(string) || !this.data[i + 1].equals(string2)) continue;
            return this.data[i + 3];
        }
        return null;
    }

    public String getType(String string) {
        int n = this.length * 7;
        for (int i = 0; i < n; i += 7) {
            if (!this.data[i + 2].equals(string)) continue;
            return this.data[i + 3];
        }
        return null;
    }

    public String getValue(String string, String string2) {
        int n = this.length * 7;
        for (int i = 0; i < n; i += 7) {
            if (!this.data[i].equals(string) || !this.data[i + 1].equals(string2)) continue;
            return this.data[i + 4];
        }
        return null;
    }

    public String getValue(String string) {
        int n = this.length * 7;
        for (int i = 0; i < n; i += 7) {
            if (!this.data[i + 2].equals(string)) continue;
            return this.data[i + 4];
        }
        return null;
    }

    public void clear() {
        int n = this.length * 7;
        for (int i = 0; i < n; ++i) {
            this.data[i] = null;
        }
        this.length = 0;
    }

    public void setAttributes(Attributes attributes) {
        this.clear();
        this.length = attributes.getLength();
        if (this.length > 0) {
            this.data = new String[this.length * 7];
            for (int i = 0; i < this.length; ++i) {
                this.data[i * 7] = attributes.getURI(i);
                this.data[i * 7 + 1] = attributes.getLocalName(i);
                this.data[i * 7 + 2] = attributes.getQName(i);
                this.data[i * 7 + 3] = attributes.getType(i);
                this.data[i * 7 + 4] = attributes.getValue(i);
            }
        }
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length * 7] = string;
        this.data[this.length * 7 + 1] = string2;
        this.data[this.length * 7 + 2] = string3;
        this.data[this.length * 7 + 3] = string4;
        this.data[this.length * 7 + 4] = string5;
        ++this.length;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.ensureCapacity(this.length + 1);
        this.data[this.length * 7] = string;
        this.data[this.length * 7 + 1] = string2;
        this.data[this.length * 7 + 2] = string3;
        this.data[this.length * 7 + 3] = string4;
        this.data[this.length * 7 + 4] = string5;
        this.data[this.length * 7 + 5] = string6;
        this.data[this.length * 7 + 6] = bl ? SPECIFIED_TRUE : null;
        ++this.length;
    }

    public void setAttribute(int n, String string, String string2, String string3, String string4, String string5) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7] = string;
            this.data[n * 7 + 1] = string2;
            this.data[n * 7 + 2] = string3;
            this.data[n * 7 + 3] = string4;
            this.data[n * 7 + 4] = string5;
        } else {
            this.badIndex(n);
        }
    }

    public void setAttribute(int n, String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7] = string;
            this.data[n * 7 + 1] = string2;
            this.data[n * 7 + 2] = string3;
            this.data[n * 7 + 3] = string4;
            this.data[n * 7 + 4] = string5;
            this.data[n * 7 + 5] = string6;
            this.data[n * 7 + 6] = bl ? SPECIFIED_TRUE : null;
        } else {
            this.badIndex(n);
        }
    }

    public void removeAttribute(int n) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7] = null;
            this.data[n * 7 + 1] = null;
            this.data[n * 7 + 2] = null;
            this.data[n * 7 + 3] = null;
            this.data[n * 7 + 4] = null;
            this.data[n * 7 + 5] = null;
            this.data[n * 7 + 6] = null;
            if (n < this.length - 1) {
                System.arraycopy(this.data, (n + 1) * 7, this.data, n * 7, (this.length - n - 1) * 7);
            }
            --this.length;
        } else {
            this.badIndex(n);
        }
    }

    public void setURI(int n, String string) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7] = string;
        } else {
            this.badIndex(n);
        }
    }

    public void setLocalName(int n, String string) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7 + 1] = string;
        } else {
            this.badIndex(n);
        }
    }

    public void setQName(int n, String string) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7 + 2] = string;
        } else {
            this.badIndex(n);
        }
    }

    public void setType(int n, String string) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7 + 3] = string;
        } else {
            this.badIndex(n);
        }
    }

    public void setValue(int n, String string) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7 + 4] = string;
        } else {
            this.badIndex(n);
        }
    }

    public void setDefault(int n, String string) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7 + 5] = string;
        } else {
            this.badIndex(n);
        }
    }

    public void setSpecified(int n, boolean bl) {
        if (n >= 0 && n < this.length) {
            this.data[n * 7 + 6] = bl ? SPECIFIED_TRUE : null;
        } else {
            this.badIndex(n);
        }
    }

    public String getIdAttributeName() {
        return this.idAttributeName;
    }

    void setIdAttributeName(String string) {
        this.idAttributeName = string;
    }

    private void ensureCapacity(int n) {
        int n2;
        if (n <= 0) {
            return;
        }
        if (this.data == null || this.data.length == 0) {
            n2 = 35;
        } else {
            if (this.data.length >= n * 7) {
                return;
            }
            n2 = this.data.length;
        }
        while (n2 < n * 7) {
            n2 *= 2;
        }
        String[] stringArray = new String[n2];
        if (this.length > 0) {
            System.arraycopy(this.data, 0, stringArray, 0, this.length * 7);
        }
        this.data = stringArray;
    }

    private void badIndex(int n) throws ArrayIndexOutOfBoundsException {
        String string = "Attempt to modify attribute at illegal index: " + n;
        throw new ArrayIndexOutOfBoundsException(string);
    }
}

