/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.soap.message;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.util.NullIterator;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SOAPMessageContext
implements javax.xml.rpc.handler.soap.SOAPMessageContext {
    int currentHandler = -1;
    private SOAPMessage _message;
    private boolean _failure;
    private Map _properties;
    private static MessageFactory _messageFactory;
    private static final String DEFAULT_SERVER_ERROR_ENVELOPE = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><env:Fault><faultcode>env:Server</faultcode><faultstring>Internal server error</faultstring></env:Fault></env:Body></env:Envelope>";

    public String[] getRoles() {
        return null;
    }

    public SOAPMessage getMessage() {
        return this._message;
    }

    public void setMessage(SOAPMessage sOAPMessage) {
        this._message = sOAPMessage;
    }

    public boolean isFailure() {
        return this._failure;
    }

    public void setFailure(boolean bl) {
        this._failure = bl;
    }

    public void setCurrentHandler(int n) {
        this.currentHandler = n;
    }

    public int getCurrentHandler() {
        return this.currentHandler;
    }

    public Object getProperty(String string) {
        if (this._properties == null) {
            return null;
        }
        return this._properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        this._properties.put(string, object);
    }

    public void removeProperty(String string) {
        if (this._properties != null) {
            this._properties.remove(string);
        }
    }

    public boolean containsProperty(String string) {
        if (this._properties == null) {
            return false;
        }
        return this._properties.containsKey(string);
    }

    public Iterator getPropertyNames() {
        if (this._properties == null) {
            return NullIterator.getInstance();
        }
        return this._properties.keySet().iterator();
    }

    public SOAPMessage createMessage() {
        try {
            return _messageFactory.createMessage();
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream) throws IOException {
        try {
            return _messageFactory.createMessage(mimeHeaders, inputStream);
        }
        catch (SOAPException sOAPException) {
            return null;
        }
    }

    public void writeInternalServerErrorResponse() {
        try {
            this.setFailure(true);
            SOAPMessage sOAPMessage = this.createMessage();
            sOAPMessage.getSOAPPart().setContent((Source)new StreamSource((InputStream)XmlUtil.getUTF8ByteInputStream(DEFAULT_SERVER_ERROR_ENVELOPE)));
            this.setMessage(sOAPMessage);
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    public void writeSimpleErrorResponse(QName qName, String string) {
        try {
            this.setFailure(true);
            SOAPMessage sOAPMessage = this.createMessage();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            outputStreamWriter.write("<?xml version='1.0' encoding='UTF-8'?>\n<env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><env:Fault><faultcode>env:");
            outputStreamWriter.write(qName.getLocalPart());
            outputStreamWriter.write("</faultcode><faultstring>");
            outputStreamWriter.write(string);
            outputStreamWriter.write("</faultstring></env:Fault></env:Body></env:Envelope>");
            ((Writer)outputStreamWriter).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            sOAPMessage.getSOAPPart().setContent((Source)new StreamSource((InputStream)new ByteInputStream(byArray, byArray.length)));
            this.setMessage(sOAPMessage);
        }
        catch (Exception exception) {
            this.writeInternalServerErrorResponse();
        }
    }

    static {
        try {
            _messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }
}

