/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http.ea;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.ServletDelegate;
import com.sun.xml.rpc.server.http.ServletEndpointContextImpl;
import com.sun.xml.rpc.server.http.ea.ImplementorFactory;
import com.sun.xml.rpc.server.http.ea.WSDLPublisher;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRPCServletDelegate
implements ServletDelegate {
    private ServletConfig _servletConfig;
    private ServletContext _servletContext;
    private ImplementorFactory _implementorFactory;
    private WSDLPublisher _wsdlPublisher;
    private Localizer _localizer;
    private Map _localizerMap;
    private LocalizableMessageFactory _messageFactory;
    private static final String CONFIG_FILE_PROPERTY = "configuration.file";
    private static final String WSDL_QUERY_STRING = "WSDL";
    private static final String FAULT_STRING_MISSING_PORT = "Missing port information";
    private static final String FAULT_STRING_PORT_NOT_FOUND = "Port not found";
    private static final String FAULT_STRING_INTERNAL_SERVER_ERROR = "Internal Server Error";
    private static final Log _logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.rpc");

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            this._servletConfig = servletConfig;
            this._servletContext = servletConfig.getServletContext();
            this._localizer = new Localizer();
            this._localizerMap = new HashMap();
            this._localizerMap.put(this._localizer.getLocale(), this._localizer);
            this._messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)this._localizer.localize(this._messageFactory.getMessage("info.servlet.initializing")));
            }
            this._implementorFactory = new ImplementorFactory(servletConfig, this.getConfigFile(servletConfig));
            this._wsdlPublisher = new WSDLPublisher(servletConfig, this.getConfigFile(servletConfig));
        }
        catch (JAXRPCServletException jAXRPCServletException) {
            String string = this._localizer.localize(jAXRPCServletException);
            throw new ServletException(string);
        }
        catch (Throwable throwable) {
            String string = this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowable", new Object[]{throwable}));
            throw new ServletException(string);
        }
    }

    protected InputStream getConfigFile(ServletConfig servletConfig) {
        String string = servletConfig.getInitParameter(CONFIG_FILE_PROPERTY);
        if (string == null) {
            throw new JAXRPCServletException("error.servlet.init.config.parameter.missing", new Object[]{CONFIG_FILE_PROPERTY});
        }
        InputStream inputStream = this._servletContext.getResourceAsStream(string);
        if (inputStream == null) {
            throw new JAXRPCServletException("error.servlet.init.config.fileNotFound", new Object[]{string});
        }
        return inputStream;
    }

    public void destroy() {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)this._localizer.localize(this._messageFactory.getMessage("info.servlet.destroying")));
        }
        if (this._implementorFactory != null) {
            this._implementorFactory.destroy();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            String string;
            MimeHeaders mimeHeaders = JAXRPCServletDelegate.getHeaders(httpServletRequest);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            byte[] byArray = JAXRPCServletDelegate.readFully((InputStream)servletInputStream);
            int n = httpServletRequest.getContentLength() == -1 ? byArray.length : httpServletRequest.getContentLength();
            ByteInputStream byteInputStream = new ByteInputStream(byArray, n);
            SOAPMessageContext sOAPMessageContext = new SOAPMessageContext();
            SOAPMessage sOAPMessage = sOAPMessageContext.createMessage(mimeHeaders, (InputStream)byteInputStream);
            if (sOAPMessage == null) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)this._localizer.localize(this._messageFactory.getMessage("info.servlet.gotEmptyRequestMessage")));
                }
                sOAPMessageContext.writeInternalServerErrorResponse();
            } else {
                sOAPMessageContext.setMessage(sOAPMessage);
                string = httpServletRequest.getPathInfo();
                if (string != null && string.length() > 1) {
                    Implementor implementor;
                    String string2;
                    String string3 = string2 = string.charAt(0) == '/' ? string.substring(1) : string;
                    if (_logger.isTraceEnabled()) {
                        _logger.trace((Object)this._localizer.localize(this._messageFactory.getMessage("trace.servlet.requestForPortNamed", string2)));
                    }
                    if ((implementor = this._implementorFactory.getImplementorFor(string2)) == null) {
                        _logger.error((Object)this._localizer.localize(this._messageFactory.getMessage("error.servlet.noImplementorForPort", string2)));
                        sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, "Port not found(\"" + string2 + "\")");
                    } else {
                        if (_logger.isTraceEnabled()) {
                            _logger.trace((Object)this._localizer.localize(this._messageFactory.getMessage("trace.servlet.handingRequestOverToImplementor", implementor.toString())));
                        }
                        ServletEndpointContextImpl servletEndpointContextImpl = implementor.getContext();
                        try {
                            servletEndpointContextImpl.setMessageContext((MessageContext)sOAPMessageContext);
                            servletEndpointContextImpl.setHttpServletRequest(httpServletRequest);
                            sOAPMessageContext.setProperty("com.sun.xml.rpc.server.http.ServletContext", this._servletContext);
                            sOAPMessageContext.setProperty("com.sun.xml.rpc.server.http.HttpServletRequest", httpServletRequest);
                            sOAPMessageContext.setProperty("com.sun.xml.rpc.server.http.Implementor", implementor);
                            implementor.getTie().handle(sOAPMessageContext);
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        finally {
                            servletEndpointContextImpl.clear();
                        }
                        if (_logger.isTraceEnabled()) {
                            _logger.trace((Object)this._localizer.localize(this._messageFactory.getMessage("trace.servlet.gotResponseFromImplementor", implementor.toString())));
                        }
                        this._implementorFactory.releaseImplementor(string2, implementor);
                    }
                } else {
                    _logger.error((Object)this._localizer.localize(this._messageFactory.getMessage("error.servlet.noPortSpecified")));
                    sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, FAULT_STRING_MISSING_PORT);
                }
            }
            string = sOAPMessageContext.getMessage();
            if (string.saveRequired()) {
                string.saveChanges();
            }
            this.writeReply(httpServletResponse, sOAPMessageContext);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            _logger.error((Object)this._localizer.localize(jAXRPCExceptionBase), (Throwable)((Object)jAXRPCExceptionBase));
            httpServletResponse.setStatus(500);
            try {
                SOAPMessageContext sOAPMessageContext = new SOAPMessageContext();
                sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, "Internal Server Error (" + this._localizer.localize(jAXRPCExceptionBase) + ")");
                this.writeReply(httpServletResponse, sOAPMessageContext);
            }
            catch (Throwable throwable) {
                _logger.error((Object)this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowableWhileRecovering", new Object[]{throwable})), throwable);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof Localizable) {
                _logger.error((Object)this._localizer.localize((Localizable)((Object)throwable)), throwable);
            } else {
                _logger.error((Object)this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowable", new Object[]{throwable})), throwable);
            }
            httpServletResponse.setStatus(500);
            try {
                SOAPMessageContext sOAPMessageContext = new SOAPMessageContext();
                sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, "Internal Server Error (" + throwable.toString() + ")");
                this.writeReply(httpServletResponse, sOAPMessageContext);
            }
            catch (Throwable throwable2) {
                _logger.error((Object)this._localizer.localize(this._messageFactory.getMessage("error.servlet.caughtThrowableWhileRecovering", new Object[]{throwable2})), throwable2);
            }
        }
    }

    protected void writeReply(HttpServletResponse httpServletResponse, SOAPMessageContext sOAPMessageContext) throws SOAPException, IOException {
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        if (sOAPMessageContext.isFailure()) {
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)this._localizer.localize(this._messageFactory.getMessage("trace.servlet.writingFaultResponse")));
            }
            httpServletResponse.setStatus(500);
        } else {
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)this._localizer.localize(this._messageFactory.getMessage("trace.servlet.writingSuccessResponse")));
            }
            httpServletResponse.setStatus(200);
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        String[] stringArray = sOAPMessage.getMimeHeaders().getHeader("Content-Type");
        if (stringArray != null && stringArray.length > 0) {
            httpServletResponse.setContentType(stringArray[0]);
        } else {
            httpServletResponse.setContentType("text/xml");
        }
        JAXRPCServletDelegate.putHeaders(sOAPMessage.getMimeHeaders(), httpServletResponse);
        sOAPMessage.writeTo((OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        Localizer localizer = this.getLocalizerFor((ServletRequest)httpServletRequest);
        try {
            if (httpServletRequest.getPathInfo() != null) {
                httpServletResponse.setContentType("text/html");
                httpServletResponse.setStatus(200);
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.println("<html>");
                printWriter.println("<head><title>");
                printWriter.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.title")));
                printWriter.println("</title></head><body>");
                printWriter.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body1")));
                String string = httpServletRequest.getRequestURI();
                int n = string.lastIndexOf(httpServletRequest.getPathInfo());
                if (n == -1) {
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body2")));
                } else {
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body3a")));
                    printWriter.println(string.substring(0, n));
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.nonRootPage.body3b")));
                }
                printWriter.println("</body></html>");
            } else if (httpServletRequest.getQueryString() != null && httpServletRequest.getQueryString().equals(WSDL_QUERY_STRING)) {
                if (this._wsdlPublisher.hasDocument()) {
                    this._wsdlPublisher.publish(httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI() + "/", httpServletResponse);
                } else {
                    httpServletResponse.setContentType("text/html");
                    httpServletResponse.setStatus(200);
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    printWriter.println("<html>");
                    printWriter.println("<head><title>");
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.wsdlPage.title")));
                    printWriter.println("</title></head><body>");
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.wsdlPage.noWsdl")));
                    printWriter.println("</body></html>");
                }
            } else {
                httpServletResponse.setContentType("text/html");
                httpServletResponse.setStatus(200);
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.println("<html>");
                printWriter.println("<head><title>");
                printWriter.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.title")));
                printWriter.println("</title></head><body>");
                printWriter.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body1")));
                if (this._implementorFactory != null) {
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body2a")));
                    Iterator iterator = this._implementorFactory.names();
                    if (!iterator.hasNext()) {
                        printWriter.print("NONE");
                    } else {
                        boolean bl = true;
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            if (!bl) {
                                printWriter.print(", ");
                            }
                            printWriter.print('\"');
                            printWriter.print(string);
                            String string2 = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI() + "/" + string;
                            printWriter.print('\"');
                            printWriter.print(" (");
                            printWriter.print(string2);
                            printWriter.print(')');
                            bl = false;
                        }
                    }
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body2b")));
                    if (this._wsdlPublisher.hasDocument()) {
                        printWriter.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body3a")));
                        printWriter.println(httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI() + "?WSDL");
                        printWriter.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body3b")));
                    }
                } else {
                    printWriter.println(localizer.localize(this._messageFactory.getMessage("html.rootPage.body4")));
                }
                printWriter.println("</body></html>");
            }
        }
        catch (IOException iOException) {
            _logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            throw new ServletException(iOException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Localizer getLocalizerFor(ServletRequest servletRequest) {
        Locale locale = servletRequest.getLocale();
        if (locale.equals(this._localizer.getLocale())) {
            return this._localizer;
        }
        Map map = this._localizerMap;
        synchronized (map) {
            Localizer localizer = (Localizer)this._localizerMap.get(locale);
            if (localizer == null) {
                localizer = new Localizer(locale);
                this._localizerMap.put(locale, localizer);
            }
            return localizer;
        }
    }

    protected static MimeHeaders getHeaders(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        MimeHeaders mimeHeaders = new MimeHeaders();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = httpServletRequest.getHeader(string);
            mimeHeaders.addHeader(string, string2);
        }
        return mimeHeaders;
    }

    protected static void putHeaders(MimeHeaders mimeHeaders, HttpServletResponse httpServletResponse) {
        mimeHeaders.removeHeader("Content-Type");
        mimeHeaders.removeHeader("Content-Length");
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            httpServletResponse.setHeader(mimeHeader.getName(), mimeHeader.getValue());
        }
    }

    protected static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }
}

