/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http.ea;

import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.JAXRPCServletException;
import com.sun.xml.rpc.server.http.ea.ImplementorInfo;
import com.sun.xml.rpc.server.http.ea.ImplementorRegistry;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ServiceException;

public class ImplementorFactory {
    protected ServletConfig _servletConfig;
    protected ImplementorRegistry _registry = new ImplementorRegistry();
    protected Map _cachedImplementors = new HashMap();

    public ImplementorFactory(ServletConfig servletConfig) {
        this._servletConfig = servletConfig;
    }

    public ImplementorFactory(ServletConfig servletConfig, String string) {
        if (string == null) {
            throw new JAXRPCServletException("error.implementorFactory.noConfiguration");
        }
        this._registry.readFrom(string);
        this._servletConfig = servletConfig;
    }

    public ImplementorFactory(ServletConfig servletConfig, InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("error.implementorFactory.noInputStream");
        }
        this._registry.readFrom(inputStream);
        this._servletConfig = servletConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Implementor getImplementorFor(String string) {
        Implementor implementor;
        Object object = this;
        synchronized (object) {
            implementor = (Implementor)this._cachedImplementors.get(string);
            if (implementor != null) {
                return implementor;
            }
        }
        try {
            object = this._registry.getImplementorInfo(string);
            if (this._servletConfig != null) {
                implementor = ((ImplementorInfo)object).createImplementor(this._servletConfig.getServletContext());
                implementor.init();
                Implementor implementor2 = null;
                ImplementorFactory implementorFactory = this;
                synchronized (implementorFactory) {
                    implementor2 = (Implementor)this._cachedImplementors.get(string);
                    if (implementor2 == null) {
                        this._cachedImplementors.put(string, implementor);
                    }
                }
                if (implementor2 == null) {
                    return implementor;
                }
                implementor.destroy();
                return implementor2;
            }
            implementor = ((ImplementorInfo)object).createImplementor(null);
            this._cachedImplementors.put(string, implementor);
            return implementor;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", string);
        }
        catch (InstantiationException instantiationException) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", string);
        }
        catch (ServiceException serviceException) {
            throw new JAXRPCServletException("error.implementorFactory.newInstanceFailed", string);
        }
        catch (JAXRPCServletException jAXRPCServletException) {
            throw jAXRPCServletException;
        }
        catch (JAXRPCException jAXRPCException) {
            throw new JAXRPCServletException("error.implementorFactory.servantInitFailed", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseImplementor(String string, Implementor implementor) {
        boolean bl = false;
        ImplementorFactory implementorFactory = this;
        synchronized (implementorFactory) {
            Implementor implementor2 = (Implementor)this._cachedImplementors.get(string);
            if (implementor2 != implementor) {
                bl = true;
            }
        }
        if (bl) {
            implementor.destroy();
        }
    }

    public Iterator names() {
        return this._registry.names();
    }

    public void destroy() {
        if (this._servletConfig != null) {
            Iterator iterator = this._cachedImplementors.values().iterator();
            while (iterator.hasNext()) {
                Implementor implementor = (Implementor)iterator.next();
                implementor.destroy();
            }
        }
        try {
            this._cachedImplementors.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

