/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.encoding.soap.SOAPConstants;
import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.ImplementorCache;
import com.sun.xml.rpc.server.http.JAXRPCRuntimeInfo;
import com.sun.xml.rpc.server.http.RuntimeEndpointInfo;
import com.sun.xml.rpc.server.http.ServletDelegate;
import com.sun.xml.rpc.server.http.ServletEndpointContextImpl;
import com.sun.xml.rpc.server.http.WSDLPublisher;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXRPCServletDelegate
implements ServletDelegate {
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private JAXRPCRuntimeInfo jaxrpcInfo;
    private Localizer defaultLocalizer;
    private LocalizableMessageFactory messageFactory;
    private ImplementorCache implementorCache;
    private Map fixedUrlPatternEndpoints;
    private List pathUrlPatternEndpoints;
    private Map localizerMap;
    private WSDLPublisher publisher;
    private boolean publishWSDL;
    private boolean publishModel;
    private boolean publishStatusPage;
    private static final Log logger = LogFactory.getLog((String)"javax.enterprise.system.webservices.rpc");

    public void init(ServletConfig servletConfig) throws ServletException {
        Object object;
        Object object2;
        Object object3;
        this.defaultLocalizer = new Localizer();
        this.localizerMap = new HashMap();
        this.localizerMap.put(this.defaultLocalizer.getLocale(), this.defaultLocalizer);
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.initialize")));
        }
        this.fixedUrlPatternEndpoints = new HashMap();
        this.pathUrlPatternEndpoints = new ArrayList();
        this.jaxrpcInfo = (JAXRPCRuntimeInfo)this.servletContext.getAttribute("com.sun.xml.rpc.server.http.info");
        if (this.jaxrpcInfo == null) {
            logger.warn((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.missingContextInformation")));
        } else {
            object3 = new HashMap();
            object2 = this.jaxrpcInfo.getEndpoints().iterator();
            while (object2.hasNext()) {
                object = (RuntimeEndpointInfo)object2.next();
                if (object3.containsKey(((RuntimeEndpointInfo)object).getName())) {
                    logger.warn((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.duplicateEndpointName", ((RuntimeEndpointInfo)object).getName())));
                    continue;
                }
                object3.put(((RuntimeEndpointInfo)object).getName(), object);
                this.registerEndpointUrlPattern((RuntimeEndpointInfo)object);
            }
        }
        object3 = this.servletContext.getInitParameter("com.sun.xml.rpc.server.http.publishWSDL");
        this.publishWSDL = object3 == null ? true : Boolean.valueOf((String)object3);
        object2 = this.servletContext.getInitParameter("com.sun.xml.rpc.server.http.publishModel");
        this.publishModel = object2 == null ? true : Boolean.valueOf((String)object2);
        object = this.servletContext.getInitParameter("com.sun.xml.rpc.server.http.publishStatusPage");
        this.publishStatusPage = object == null ? true : Boolean.valueOf((String)object);
        this.implementorCache = new ImplementorCache(servletConfig);
        this.publisher = new WSDLPublisher(this.servletContext, this.jaxrpcInfo);
    }

    public void destroy() {
        this.implementorCache.destroy();
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.destroy")));
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            Localizer localizer = this.getLocalizerFor((ServletRequest)httpServletRequest);
            RuntimeEndpointInfo runtimeEndpointInfo = this.getEndpointFor(httpServletRequest);
            if (runtimeEndpointInfo != null && httpServletRequest.getQueryString() != null) {
                if (httpServletRequest.getQueryString().equals("WSDL")) {
                    if (this.publishWSDL && runtimeEndpointInfo.getWSDLFileName() != null) {
                        this.publisher.handle(runtimeEndpointInfo, httpServletRequest, httpServletResponse);
                    } else {
                        this.writeNotFoundErrorPage(localizer, httpServletResponse, "Invalid request");
                    }
                } else if (httpServletRequest.getQueryString().equals("model")) {
                    if (this.publishModel && runtimeEndpointInfo.getModelFileName() != null) {
                        httpServletResponse.setContentType("application/x-gzip");
                        InputStream inputStream = this.servletContext.getResourceAsStream(runtimeEndpointInfo.getModelFileName());
                        JAXRPCServletDelegate.copyStream(inputStream, (OutputStream)httpServletResponse.getOutputStream());
                        inputStream.close();
                    } else {
                        this.writeNotFoundErrorPage(localizer, httpServletResponse, "Invalid request");
                    }
                } else {
                    this.writeNotFoundErrorPage(localizer, httpServletResponse, "Invalid request");
                }
            } else if (httpServletRequest.getPathInfo() == null) {
                if (this.publishStatusPage) {
                    httpServletResponse.setContentType("text/html");
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    printWriter.println("<html>");
                    printWriter.println("<head><title>");
                    printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title")));
                    printWriter.println("</title></head>");
                    printWriter.println("<body>");
                    printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title2")));
                    if (this.jaxrpcInfo == null) {
                        printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.noInfoAvailable")));
                    } else {
                        printWriter.println("<table width='100%' border='1'>");
                        printWriter.println("<tr>");
                        printWriter.println("<td>");
                        printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.portName")));
                        printWriter.println("</td>");
                        printWriter.println("<td>");
                        printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.status")));
                        printWriter.println("</td>");
                        printWriter.println("<td>");
                        printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.information")));
                        printWriter.println("</td>");
                        printWriter.println("</tr>");
                        String string = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getContextPath();
                        Iterator iterator = this.jaxrpcInfo.getEndpoints().iterator();
                        while (iterator.hasNext()) {
                            RuntimeEndpointInfo runtimeEndpointInfo2 = (RuntimeEndpointInfo)iterator.next();
                            String string2 = string + this.getValidPathForEndpoint(runtimeEndpointInfo2);
                            printWriter.println("<tr>");
                            printWriter.println("<td>" + runtimeEndpointInfo2.getName() + "</td>");
                            printWriter.println("<td>");
                            if (runtimeEndpointInfo2.isDeployed()) {
                                printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.status.active")));
                            } else {
                                printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.status.error")));
                            }
                            printWriter.println("</td>");
                            printWriter.println("<td>");
                            printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.information.table", new Object[]{string2, runtimeEndpointInfo2.getPortName(), runtimeEndpointInfo2.getRemoteInterface().getName(), runtimeEndpointInfo2.getImplementationClass().getName()})));
                            printWriter.println("</td>");
                            printWriter.println("</tr>");
                        }
                        printWriter.println("</table>");
                    }
                    printWriter.println("</body>");
                    printWriter.println("</html>");
                } else {
                    this.writeNotFoundErrorPage(localizer, httpServletResponse, "Invalid request");
                }
            } else if (this.publishStatusPage) {
                httpServletResponse.setContentType("text/html");
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.println("<html>");
                printWriter.println("<head><title>");
                printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title")));
                printWriter.println("</title></head>");
                printWriter.println("<body>");
                printWriter.println("</body>");
                printWriter.println("</html>");
            } else {
                this.writeNotFoundErrorPage(localizer, httpServletResponse, "Invalid request");
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            throw new ServletException(exception.getMessage());
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            RuntimeEndpointInfo runtimeEndpointInfo;
            MimeHeaders mimeHeaders = JAXRPCServletDelegate.getHeaders(httpServletRequest);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            byte[] byArray = JAXRPCServletDelegate.readFully((InputStream)servletInputStream);
            int n = httpServletRequest.getContentLength() == -1 ? byArray.length : httpServletRequest.getContentLength();
            ByteInputStream byteInputStream = new ByteInputStream(byArray, n);
            SOAPMessageContext sOAPMessageContext = new SOAPMessageContext();
            SOAPMessage sOAPMessage = sOAPMessageContext.createMessage(mimeHeaders, (InputStream)byteInputStream);
            if (sOAPMessage == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.emptyRequestMessage")));
                }
                sOAPMessageContext.writeInternalServerErrorResponse();
            } else {
                sOAPMessageContext.setMessage(sOAPMessage);
                runtimeEndpointInfo = this.getEndpointFor(httpServletRequest);
                if (runtimeEndpointInfo != null) {
                    Implementor implementor;
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.gotRequestForEndpoint", runtimeEndpointInfo.getName())));
                    }
                    if ((implementor = this.implementorCache.getImplementorFor(runtimeEndpointInfo)) == null) {
                        logger.error((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.error.noImplementorForEndpoint", runtimeEndpointInfo.getName())));
                        sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.portNotFound", runtimeEndpointInfo.getName())));
                    } else {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.invokingImplementor", implementor.toString())));
                        }
                        ServletEndpointContextImpl servletEndpointContextImpl = implementor.getContext();
                        try {
                            servletEndpointContextImpl.setMessageContext((MessageContext)sOAPMessageContext);
                            servletEndpointContextImpl.setHttpServletRequest(httpServletRequest);
                            sOAPMessageContext.setProperty("com.sun.xml.rpc.server.http.ServletContext", this.servletContext);
                            sOAPMessageContext.setProperty("com.sun.xml.rpc.server.http.HttpServletRequest", httpServletRequest);
                            sOAPMessageContext.setProperty("com.sun.xml.rpc.server.http.Implementor", implementor);
                            implementor.getTie().handle(sOAPMessageContext);
                        }
                        catch (Exception exception) {
                            throw exception;
                        }
                        finally {
                            servletEndpointContextImpl.clear();
                        }
                        this.implementorCache.releaseImplementor(runtimeEndpointInfo, implementor);
                    }
                } else {
                    logger.error((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.error.noEndpointSpecified")));
                    sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.missingPort")));
                }
            }
            runtimeEndpointInfo = sOAPMessageContext.getMessage();
            if (runtimeEndpointInfo.saveRequired()) {
                runtimeEndpointInfo.saveChanges();
            }
            this.writeReply(httpServletResponse, sOAPMessageContext);
        }
        catch (JAXRPCExceptionBase jAXRPCExceptionBase) {
            logger.error((Object)this.defaultLocalizer.localize(jAXRPCExceptionBase), (Throwable)((Object)jAXRPCExceptionBase));
            httpServletResponse.setStatus(500);
            try {
                SOAPMessageContext sOAPMessageContext = new SOAPMessageContext();
                sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.internalServerError", this.defaultLocalizer.localize(jAXRPCExceptionBase))));
                this.writeReply(httpServletResponse, sOAPMessageContext);
            }
            catch (Throwable throwable) {
                logger.error((Object)"caught throwable while recovering", throwable);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof Localizable) {
                logger.error((Object)this.defaultLocalizer.localize((Localizable)((Object)throwable)), throwable);
            } else {
                logger.error((Object)"caught throwable", throwable);
            }
            httpServletResponse.setStatus(500);
            try {
                SOAPMessageContext sOAPMessageContext = new SOAPMessageContext();
                sOAPMessageContext.writeSimpleErrorResponse(SOAPConstants.FAULT_CODE_SERVER, this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.missingPort")));
                this.writeReply(httpServletResponse, sOAPMessageContext);
            }
            catch (Throwable throwable2) {
                logger.error((Object)"caught throwable while recovering", throwable2);
            }
        }
    }

    protected void writeReply(HttpServletResponse httpServletResponse, SOAPMessageContext sOAPMessageContext) throws SOAPException, IOException {
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        if (sOAPMessageContext.isFailure()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.writingFaultResponse")));
            }
            httpServletResponse.setStatus(500);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.writingSuccessResponse")));
            }
            httpServletResponse.setStatus(200);
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        String[] stringArray = sOAPMessage.getMimeHeaders().getHeader("Content-Type");
        if (stringArray != null && stringArray.length > 0) {
            httpServletResponse.setContentType(stringArray[0]);
        } else {
            httpServletResponse.setContentType("text/xml");
        }
        JAXRPCServletDelegate.putHeaders(sOAPMessage.getMimeHeaders(), httpServletResponse);
        sOAPMessage.writeTo((OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    protected void writeNotFoundErrorPage(Localizer localizer, HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head><title>");
        printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title")));
        printWriter.println("</title></head>");
        printWriter.println("<body>");
        printWriter.println(localizer.localize(this.messageFactory.getMessage("servlet.html.notFound", string)));
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    protected static MimeHeaders getHeaders(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        MimeHeaders mimeHeaders = new MimeHeaders();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = httpServletRequest.getHeader(string);
            mimeHeaders.addHeader(string, string2);
        }
        return mimeHeaders;
    }

    protected static void putHeaders(MimeHeaders mimeHeaders, HttpServletResponse httpServletResponse) {
        mimeHeaders.removeHeader("Content-Type");
        mimeHeaders.removeHeader("Content-Length");
        Iterator iterator = mimeHeaders.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader mimeHeader = (MimeHeader)iterator.next();
            httpServletResponse.setHeader(mimeHeader.getName(), mimeHeader.getValue());
        }
    }

    protected static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    protected void registerEndpointUrlPattern(RuntimeEndpointInfo runtimeEndpointInfo) {
        String string = runtimeEndpointInfo.getUrlPattern();
        if (string.indexOf("*.") != -1) {
            logger.warn((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.ignoringImplicitUrlPattern", runtimeEndpointInfo.getName())));
        } else if (string.endsWith("/*")) {
            this.pathUrlPatternEndpoints.add(runtimeEndpointInfo);
        } else if (this.fixedUrlPatternEndpoints.containsKey(string)) {
            logger.warn((Object)this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.duplicateEndpointUrlPattern", runtimeEndpointInfo.getName())));
        } else {
            this.fixedUrlPatternEndpoints.put(string, runtimeEndpointInfo);
        }
    }

    protected String getValidPathForEndpoint(RuntimeEndpointInfo runtimeEndpointInfo) {
        String string = runtimeEndpointInfo.getUrlPattern();
        if (string.endsWith("/*")) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    protected RuntimeEndpointInfo getEndpointFor(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        RuntimeEndpointInfo runtimeEndpointInfo = (RuntimeEndpointInfo)this.fixedUrlPatternEndpoints.get(string);
        if (runtimeEndpointInfo == null) {
            Iterator iterator = this.pathUrlPatternEndpoints.iterator();
            while (iterator.hasNext()) {
                RuntimeEndpointInfo runtimeEndpointInfo2 = (RuntimeEndpointInfo)iterator.next();
                if (!runtimeEndpointInfo2.getUrlPattern().startsWith(string)) continue;
                runtimeEndpointInfo = runtimeEndpointInfo2;
                break;
            }
        }
        return runtimeEndpointInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Localizer getLocalizerFor(ServletRequest servletRequest) {
        Locale locale = servletRequest.getLocale();
        if (locale.equals(this.defaultLocalizer.getLocale())) {
            return this.defaultLocalizer;
        }
        Map map = this.localizerMap;
        synchronized (map) {
            Localizer localizer = (Localizer)this.localizerMap.get(locale);
            if (localizer == null) {
                localizer = new Localizer(locale);
                this.localizerMap.put(locale, localizer);
            }
            return localizer;
        }
    }

    protected static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }
}

